/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.controller.AclControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTestConstants;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

@Timeout(value=40L)
public class AclControlManagerTest {
    @Test
    public void testValidateNewAcl() {
        AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW)));
        Assertions.assertEquals((Object)"Invalid patternType UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.UNKNOWN), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
        Assertions.assertEquals((Object)"Invalid resourceType UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.UNKNOWN, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
        Assertions.assertEquals((Object)"Invalid operation UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.UNKNOWN, AclPermissionType.ALLOW))))).getMessage());
        Assertions.assertEquals((Object)"Invalid permissionType UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.UNKNOWN))))).getMessage());
    }

    @Test
    public void testValidateAclWithBadPrincipal() {
        Assertions.assertEquals((Object)"Could not parse principal from `invalid` (no colon is present separating the principal type from the principal name)", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("invalid", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
    }

    @Test
    public void testValidateAclWithEmptyPrincipal() {
        Assertions.assertEquals((Object)"Could not parse principal from `` (no colon is present separating the principal type from the principal name)", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateNewAcl((AclBinding)new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("", "*", AclOperation.ALTER, AclPermissionType.ALLOW))))).getMessage());
    }

    @Test
    public void testValidateFilter() {
        AclControlManager.validateFilter((AclBindingFilter)new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "*", PatternType.LITERAL), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.ANY)));
        Assertions.assertEquals((Object)"Unknown patternFilter.", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateFilter((AclBindingFilter)new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "*", PatternType.UNKNOWN), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.ANY))))).getMessage());
        Assertions.assertEquals((Object)"Unknown entryFilter.", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateFilter((AclBindingFilter)new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "*", PatternType.MATCH), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.UNKNOWN))))).getMessage());
    }

    @Test
    public void testValidateAclState() {
        AclControlManager.validateAclStateForCreate((AclState)AclState.ACTIVE);
        AclControlManager.validateAclStateForCreate((AclState)AclState.DELETED);
        Assertions.assertEquals((Object)"Invalid AclState ANY", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateAclStateForCreate((AclState)AclState.ANY))).getMessage());
        Assertions.assertEquals((Object)"Invalid AclState UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateAclStateForCreate((AclState)AclState.UNKNOWN))).getMessage());
        AclControlManager.validateAclStateForDelete((AclState)AclState.ANY);
        AclControlManager.validateAclStateForDelete((AclState)AclState.DELETED);
        AclControlManager.validateAclStateForDelete((AclState)AclState.ACTIVE);
        Assertions.assertEquals((Object)"Invalid AclState UNKNOWN", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> AclControlManager.validateAclStateForDelete((AclState)AclState.UNKNOWN))).getMessage());
    }

    @Test
    public void testLoadSnapshot() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        snapshotRegistry.getOrCreateSnapshot(0L);
        AclControlManager manager = new AclControlManager.Builder().setSnapshotRegistry(snapshotRegistry).build();
        HashSet loadedAcls = new HashSet();
        StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.ALL).forEach(acl -> {
            AccessControlEntryRecord record = acl.toRecord();
            Assertions.assertTrue((boolean)loadedAcls.add(new ApiMessageAndVersion((ApiMessage)record, 0)));
            manager.replay(acl.toRecord());
        });
        HashSet<ApiMessageAndVersion> foundAcls = new HashSet<ApiMessageAndVersion>();
        for (Map.Entry entry : manager.idToAcl().entrySet()) {
            foundAcls.add(new ApiMessageAndVersion((ApiMessage)new StandardAclWithId((Uuid)entry.getKey(), (ConfluentStandardAcl)entry.getValue()).toRecord(), 0));
        }
        Assertions.assertEquals(loadedAcls, foundAcls);
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadAclSnapshot(manager.idToAcl());
        Set expected = StandardAuthorizerTestConstants.ALL.stream().map(standardAcl -> new ConfluentStandardAcl(standardAcl, Optional.empty())).collect(Collectors.toSet());
        Assertions.assertEquals(expected, new HashSet<ConfluentStandardAcl>(authorizer.acls.values()));
        snapshotRegistry.revertToSnapshot(0L);
        authorizer.loadAclSnapshot(manager.idToAcl());
        Assertions.assertTrue((boolean)manager.idToAcl().isEmpty());
    }

    @Test
    public void testAddAndDelete() {
        AclControlManager manager = new AclControlManager.Builder().build();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadAclSnapshot(manager.idToAcl());
        manager.replay(StandardAuthorizerTestConstants.withIdAndActiveState(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0)).toRecord());
        Assertions.assertEquals((Object)new ConfluentStandardAcl(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0), Optional.empty()), manager.idToAcl().values().iterator().next());
        manager.replay(new RemoveAccessControlEntryRecord().setId(StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0))));
        Assertions.assertTrue((boolean)manager.idToAcl().isEmpty());
    }

    @Test
    public void testCreateAclDeleteAcl() {
        int i;
        AclControlManager manager = new AclControlManager.Builder().build();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadAclSnapshot(manager.idToAcl());
        ArrayList<AclBinding> toCreate = new ArrayList<AclBinding>();
        for (int i2 = 0; i2 < 2; ++i2) {
            toCreate.add(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(i2).toBinding());
        }
        toCreate.add(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0).toBinding());
        toCreate.add(new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.UNKNOWN), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW)));
        ControllerResult createResult = manager.createAcls(toCreate);
        ArrayList<AclCreateResult> expectedResults = new ArrayList<AclCreateResult>();
        for (i = 0; i < 3; ++i) {
            expectedResults.add(AclCreateResult.SUCCESS);
        }
        expectedResults.add(new AclCreateResult((ApiException)new InvalidRequestException("Invalid patternType UNKNOWN")));
        for (i = 0; i < expectedResults.size(); ++i) {
            AclCreateResult expectedResult = (AclCreateResult)expectedResults.get(i);
            if (expectedResult.exception().isPresent()) {
                Assertions.assertEquals((Object)((ApiException)expectedResult.exception().get()).getMessage(), (Object)((ApiException)((AclCreateResult)((List)createResult.response()).get(i)).exception().get()).getMessage());
                continue;
            }
            Assertions.assertFalse((boolean)((AclCreateResult)((List)createResult.response()).get(i)).exception().isPresent());
        }
        RecordTestUtils.replayAll(manager, createResult.records());
        Assertions.assertFalse((boolean)manager.idToAcl().isEmpty());
        ControllerResult deleteResult = manager.deleteAcls(Arrays.asList(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), AccessControlEntryFilter.ANY), new AclBindingFilter(new ResourcePatternFilter(ResourceType.UNKNOWN, null, PatternType.LITERAL), AccessControlEntryFilter.ANY)));
        Assertions.assertEquals((int)2, (int)((List)deleteResult.response()).size());
        HashSet<AclBinding> deleted = new HashSet<AclBinding>();
        for (AclDeleteResult.AclBindingDeleteResult result : ((AclDeleteResult)((List)deleteResult.response()).get(0)).aclBindingDeleteResults()) {
            Assertions.assertEquals(Optional.empty(), (Object)result.exception());
            deleted.add(result.aclBinding());
        }
        Assertions.assertEquals(new HashSet<AclBinding>(Arrays.asList(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0).toBinding(), StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1).toBinding())), deleted);
        Assertions.assertEquals(InvalidRequestException.class, ((ApiException)((AclDeleteResult)((List)deleteResult.response()).get(1)).exception().get()).getClass());
        RecordTestUtils.replayAll(manager, deleteResult.records());
        Iterator iterator = manager.idToAcl().entrySet().iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)new ConfluentStandardAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0), Optional.empty()), iterator.next().getValue());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCreateAclDeleteAclWithAclState() throws Throwable {
        int i;
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        AclControlManager manager = new AclControlManager.Builder().build();
        authorizer.loadAclSnapshot(manager.idToAcl());
        ArrayList<AclBinding> inactiveACLs = new ArrayList<AclBinding>();
        for (int i2 = 0; i2 < 2; ++i2) {
            inactiveACLs.add(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(i2).toBinding());
        }
        inactiveACLs.add(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0).toBinding());
        inactiveACLs.add(new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.UNKNOWN), new AccessControlEntry("User:*", "*", AclOperation.ALTER, AclPermissionType.ALLOW)));
        ControllerResult createResult = manager.createAcls(inactiveACLs, AclState.DELETED);
        ArrayList<AclCreateResult> expectedResults = new ArrayList<AclCreateResult>();
        for (i = 0; i < 3; ++i) {
            expectedResults.add(AclCreateResult.SUCCESS);
        }
        expectedResults.add(new AclCreateResult((ApiException)new InvalidRequestException("Invalid patternType UNKNOWN")));
        for (i = 0; i < expectedResults.size(); ++i) {
            AclCreateResult expectedResult = (AclCreateResult)expectedResults.get(i);
            if (expectedResult.exception().isPresent()) {
                Assertions.assertEquals((Object)((ApiException)expectedResult.exception().get()).getMessage(), (Object)((ApiException)((AclCreateResult)((List)createResult.response()).get(i)).exception().get()).getMessage());
                continue;
            }
            Assertions.assertFalse((boolean)((AclCreateResult)((List)createResult.response()).get(i)).exception().isPresent());
        }
        RecordTestUtils.replayAll(manager, createResult.records());
        Assertions.assertFalse((boolean)manager.idToAcl().isEmpty());
        AclBinding activeAcl = StandardAuthorizerTestConstants.LITERAL_ACLS.get(0).toBinding();
        manager.createAcls(Collections.singletonList(activeAcl), AclState.ACTIVE);
        ControllerResult deleteResult = manager.deleteAcls(Arrays.asList(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, null, PatternType.LITERAL), AccessControlEntryFilter.ANY)));
        Assertions.assertEquals((int)1, (int)((List)deleteResult.response()).size());
        HashSet<AclBinding> deleted = new HashSet<AclBinding>();
        for (AclDeleteResult.AclBindingDeleteResult result : ((AclDeleteResult)((List)deleteResult.response()).get(0)).aclBindingDeleteResults()) {
            Assertions.assertEquals(Optional.empty(), (Object)result.exception());
            deleted.add(result.aclBinding());
        }
        Assertions.assertEquals(new HashSet<AclBinding>(Collections.singletonList(StandardAuthorizerTestConstants.LITERAL_ACLS.get(0).toBinding())), deleted);
        RecordTestUtils.replayAll(manager, deleteResult.records());
        Iterator iterator = manager.idToAcl().entrySet().iterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)new ConfluentStandardAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0), Optional.empty(), AclState.DELETED), iterator.next().getValue());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    Boolean isValidLink(Uuid linkId, Set<Uuid> validLinkIds) {
        return validLinkIds.contains(linkId);
    }

    @Test
    public void testCreateInvalidClusterLinkAcl() {
        Uuid validLinkId = Uuid.randomUuid();
        Uuid validLinkId2 = Uuid.randomUuid();
        Uuid invalidLinkId = Uuid.randomUuid();
        Uuid invalidLinkId2 = Uuid.ZERO_UUID;
        HashSet<Uuid> validLinkIds = new HashSet<Uuid>();
        validLinkIds.add(validLinkId);
        validLinkIds.add(validLinkId2);
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        AclControlManager manager = new AclControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(snapshotRegistry).setValidLinkIdChecker(linkId -> this.isValidLink((Uuid)linkId, (Set<Uuid>)validLinkIds)).build();
        AclBinding validAclBinding1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW));
        AclBinding validAclBinding2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW, Arrays.asList(validLinkId, validLinkId2)));
        AclBinding invalidAclBinding1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW, Arrays.asList(validLinkId, invalidLinkId)));
        AclBinding invalidAclBinding2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW, Arrays.asList(invalidLinkId, invalidLinkId2)));
        ControllerResult createResult = manager.createAcls(Arrays.asList(validAclBinding1, validAclBinding2, invalidAclBinding1, invalidAclBinding2));
        Assertions.assertEquals((int)3, (int)createResult.records().size());
        Assertions.assertEquals((int)4, (int)((List)createResult.response()).size());
        for (int ii = 0; ii < ((List)createResult.response()).size(); ++ii) {
            AclCreateResult response = (AclCreateResult)((List)createResult.response()).get(ii);
            if (ii < 2) {
                Assertions.assertFalse((boolean)response.exception().isPresent());
                continue;
            }
            Assertions.assertTrue((boolean)response.exception().isPresent());
            Assertions.assertThrows(InvalidRequestException.class, () -> {
                throw (ApiException)response.exception().get();
            });
        }
    }

    @Test
    public void testRemoveClusterLinkAcls() {
        Uuid linkId = Uuid.randomUuid();
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        StandardAuthorizer standardAuthorizer = (StandardAuthorizer)Mockito.mock(StandardAuthorizer.class);
        AclControlManager manager = new AclControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(snapshotRegistry).setValidLinkIdChecker(lId -> lId.equals((Object)linkId)).build();
        Assertions.assertThrows(IllegalStateException.class, () -> manager.unlinkAcls(Uuid.ZERO_UUID));
        AclBinding localAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW));
        AclBinding clusterLinkAcl1 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW, Collections.singleton(linkId)));
        AclBinding clusterLinkAcl2 = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-2", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW, Collections.singleton(linkId)));
        List<AclBinding> allAcls = Arrays.asList(localAcl, clusterLinkAcl1, clusterLinkAcl2);
        ControllerResult createResult = manager.createAcls(allAcls);
        createResult.records().forEach(record -> manager.replay((AccessControlEntryRecord)record.message()));
        Map idToAclMap = manager.idToAcl();
        standardAuthorizer.loadAclSnapshot(idToAclMap);
        Assertions.assertEquals((int)3, (int)idToAclMap.size());
        Uuid localAclId = Uuid.ZERO_UUID;
        Uuid clusterLinkAcl1Id = Uuid.ZERO_UUID;
        Uuid clusterLinkAcl2Id = Uuid.ZERO_UUID;
        for (Map.Entry entry : idToAclMap.entrySet()) {
            if (((ConfluentStandardAcl)entry.getValue()).toBinding().equals((Object)localAcl)) {
                localAclId = (Uuid)entry.getKey();
                continue;
            }
            if (((ConfluentStandardAcl)entry.getValue()).toBinding().equals((Object)clusterLinkAcl1)) {
                clusterLinkAcl1Id = (Uuid)entry.getKey();
                continue;
            }
            if (!((ConfluentStandardAcl)entry.getValue()).toBinding().equals((Object)clusterLinkAcl2)) continue;
            clusterLinkAcl2Id = (Uuid)entry.getKey();
        }
        Assertions.assertNotEquals((Object)localAclId, (Object)Uuid.ZERO_UUID);
        Assertions.assertNotEquals((Object)clusterLinkAcl1Id, (Object)Uuid.ZERO_UUID);
        Assertions.assertNotEquals((Object)clusterLinkAcl2Id, (Object)Uuid.ZERO_UUID);
        manager.unlinkAcls(linkId);
        idToAclMap = manager.idToAcl();
        Assertions.assertEquals((int)2, (int)idToAclMap.size());
        Assertions.assertTrue((boolean)idToAclMap.containsKey(localAclId));
        Assertions.assertFalse((boolean)idToAclMap.containsKey(clusterLinkAcl1Id));
        Assertions.assertTrue((boolean)idToAclMap.containsKey(clusterLinkAcl2Id));
        HashSet expectedAcls = new HashSet();
        expectedAcls.addAll(ConfluentStandardAcl.fromAclBinding((AclBinding)localAcl));
        expectedAcls.addAll(ConfluentStandardAcl.fromAclBinding((AclBinding)clusterLinkAcl2).stream().map(ConfluentStandardAcl::toLocalAcl).collect(Collectors.toSet()));
        manager.validateAclsInCache(expectedAcls);
        ((StandardAuthorizer)Mockito.verify((Object)standardAuthorizer)).loadAclSnapshot((Map)Mockito.any());
    }

    @Test
    public void testCreateMultipleAcls() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        AclControlManager manager = new AclControlManager.Builder().setLogContext(logContext).setSnapshotRegistry(snapshotRegistry).setValidLinkIdChecker(linkId -> true).build();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadAclSnapshot(manager.idToAcl());
        Uuid link1 = Uuid.fromString((String)"R3bMhXGmQNmK46EcBnrAiQ");
        Uuid link2 = Uuid.fromString((String)"1btx_LQcTNmABQKW0MRBVQ");
        ArrayList<Uuid> links = new ArrayList<Uuid>();
        links.add(link1);
        links.add(link2);
        AclBinding aclBinding = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW, links));
        ControllerResult createResult = manager.createAcls(Collections.singletonList(aclBinding));
        Assertions.assertEquals((int)2, (int)createResult.records().size());
        Assertions.assertEquals((int)1, (int)((List)createResult.response()).size());
        Assertions.assertEquals(Optional.empty(), (Object)((AclCreateResult)((List)createResult.response()).get(0)).exception());
        AccessControlEntryRecord accessControlEntryRecord1 = (AccessControlEntryRecord)((ApiMessageAndVersion)createResult.records().get(0)).message();
        AccessControlEntryRecord accessControlEntryRecord2 = (AccessControlEntryRecord)((ApiMessageAndVersion)createResult.records().get(1)).message();
        Assertions.assertEquals((Object)accessControlEntryRecord1.clusterLinkId(), (Object)link1);
        Assertions.assertEquals((Object)accessControlEntryRecord2.clusterLinkId(), (Object)link2);
    }

    @Test
    public void testDeleteDedupe() {
        AclControlManager manager = new AclControlManager.Builder().build();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.loadAclSnapshot(manager.idToAcl());
        AclBinding aclBinding = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "topic-1", PatternType.LITERAL), new AccessControlEntry("User:user", "10.0.0.1", AclOperation.ALL, AclPermissionType.ALLOW));
        ControllerResult createResult = manager.createAcls(Collections.singletonList(aclBinding));
        Uuid id = ((AccessControlEntryRecord)((ApiMessageAndVersion)createResult.records().get(0)).message()).id();
        Assertions.assertEquals((int)1, (int)createResult.records().size());
        ControllerResult deleteAclResultsAnyFilter = manager.deleteAcls(Collections.singletonList(AclBindingFilter.ANY));
        Assertions.assertEquals((int)1, (int)deleteAclResultsAnyFilter.records().size());
        Assertions.assertEquals((Object)id, (Object)((RemoveAccessControlEntryRecord)((ApiMessageAndVersion)deleteAclResultsAnyFilter.records().get(0)).message()).id());
        Assertions.assertEquals((int)1, (int)((List)deleteAclResultsAnyFilter.response()).size());
        ControllerResult deleteAclResultsSpecificFilter = manager.deleteAcls(Collections.singletonList(aclBinding.toFilter()));
        Assertions.assertEquals((int)1, (int)deleteAclResultsSpecificFilter.records().size());
        Assertions.assertEquals((Object)id, (Object)((RemoveAccessControlEntryRecord)((ApiMessageAndVersion)deleteAclResultsSpecificFilter.records().get(0)).message()).id());
        Assertions.assertEquals((int)1, (int)((List)deleteAclResultsSpecificFilter.response()).size());
        ControllerResult deleteAclResultsBothFilters = manager.deleteAcls(Arrays.asList(AclBindingFilter.ANY, aclBinding.toFilter()));
        Assertions.assertEquals((int)1, (int)deleteAclResultsBothFilters.records().size());
        Assertions.assertEquals((Object)id, (Object)((RemoveAccessControlEntryRecord)((ApiMessageAndVersion)deleteAclResultsBothFilters.records().get(0)).message()).id());
        Assertions.assertEquals((int)2, (int)((List)deleteAclResultsBothFilters.response()).size());
    }

    static class MockClusterMetadataAuthorizer
    implements ClusterMetadataAuthorizer {
        Map<Uuid, ConfluentStandardAcl> acls = Collections.emptyMap();

        MockClusterMetadataAuthorizer() {
        }

        public void setAclMutator(AclMutator aclMutator) {
        }

        public AclMutator aclMutatorOrException() {
            throw new NotControllerException("The current node is not the active controller.");
        }

        public void completeInitialLoad() {
        }

        public void completeInitialLoad(Exception e) {
        }

        public void loadAclSnapshot(Map<Uuid, ConfluentStandardAcl> acls) {
            this.acls = new HashMap<Uuid, ConfluentStandardAcl>(acls);
        }

        public void applyAclChanges(Map<Uuid, Optional<ConfluentStandardAcl>> aclChanges) {
        }

        public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return null;
        }

        public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() throws IOException {
        }

        public void configure(Map<String, ?> configs) {
        }
    }
}

