/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.AclsImageTest;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterImageTest;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.ConfigurationsImageTest;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ProducerIdsImageTest;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicsImageTest;
import org.apache.kafka.metadata.BrokerReplicaExclusion;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.migration.CapturingAclMigrationClient;
import org.apache.kafka.metadata.migration.CapturingBrokerHealthMigrationClient;
import org.apache.kafka.metadata.migration.CapturingClusterLinkMigrationClient;
import org.apache.kafka.metadata.migration.CapturingConfigMigrationClient;
import org.apache.kafka.metadata.migration.CapturingMigrationClient;
import org.apache.kafka.metadata.migration.CapturingReplicaExclusionMigrationClient;
import org.apache.kafka.metadata.migration.CapturingTopicMigrationClient;
import org.apache.kafka.metadata.migration.KRaftMigrationDriver;
import org.apache.kafka.metadata.migration.KRaftMigrationOperationConsumer;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KRaftMigrationZkWriterTest {
    @Test
    public void testExtraneousZkPartitions() {
        CapturingTopicMigrationClient topicClient = new CapturingTopicMigrationClient(){

            @Override
            public void iterateTopics(EnumSet<TopicMigrationClient.TopicVisitorInterest> interests, TopicMigrationClient.TopicVisitor visitor) {
                HashMap<Integer, List<Integer>> assignments = new HashMap<Integer, List<Integer>>();
                assignments.put(0, Arrays.asList(2, 3, 4));
                assignments.put(1, Arrays.asList(3, 4, 5));
                assignments.put(2, Arrays.asList(2, 4, 5));
                assignments.put(3, Arrays.asList(1, 2, 3));
                visitor.visitTopic("foo", TopicsImageTest.FOO_UUID, assignments, Optional.empty());
                IntStream.of(0, 2, 3).forEach(partitionId -> visitor.visitPartition(new TopicIdPartition(TopicsImageTest.FOO_UUID, new TopicPartition("foo", partitionId)), TopicsImageTest.IMAGE1.getPartition(TopicsImageTest.FOO_UUID, partitionId)));
            }
        };
        CapturingConfigMigrationClient configClient = new CapturingConfigMigrationClient();
        CapturingAclMigrationClient aclClient = new CapturingAclMigrationClient();
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0).setTopicMigrationClient(topicClient).setConfigMigrationClient(configClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient, __ -> {});
        MetadataImage image = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImageTest.IMAGE1, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        writer.handleSnapshot(image, (opType, opLog, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        Assertions.assertEquals((int)topicClient.updatedTopics.get("foo").size(), (int)3);
        Assertions.assertEquals(topicClient.deletedTopicPartitions.get("foo"), Collections.singleton(3));
        Assertions.assertEquals(topicClient.updatedTopicPartitions.get("foo"), Collections.singleton(1));
    }

    @Test
    public void testReconcileSnapshotEmptyZk() {
        CapturingTopicMigrationClient topicClient = new CapturingTopicMigrationClient();
        CapturingConfigMigrationClient configClient = new CapturingConfigMigrationClient();
        CapturingAclMigrationClient aclClient = new CapturingAclMigrationClient();
        CapturingBrokerHealthMigrationClient brokerHealthClient = new CapturingBrokerHealthMigrationClient();
        CapturingReplicaExclusionMigrationClient replicaExclusionClient = new CapturingReplicaExclusionMigrationClient();
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0).setTopicMigrationClient(topicClient).setConfigMigrationClient(configClient).setAclMigrationClient(aclClient).setBrokerHealthMigrationClient(brokerHealthClient).setReplicaExclusionMigrationClient(replicaExclusionClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient, __ -> {});
        MetadataImage image = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImageTest.IMAGE1, TopicsImageTest.IMAGE1, ConfigurationsImageTest.IMAGE1, ClientQuotasImage.EMPTY, ProducerIdsImageTest.IMAGE1, AclsImageTest.IMAGE1, ClusterLinksImage.EMPTY, new BrokerReplicaExclusionsImage(Collections.singletonMap(1, "rcca-123")), CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        HashMap opCounts = new HashMap();
        KRaftMigrationOperationConsumer consumer = KRaftMigrationDriver.countingOperationConsumer(opCounts, (logMsg, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        writer.handleSnapshot(image, consumer);
        Assertions.assertEquals((int)3, (Integer)((Integer)opCounts.remove("CreateTopic")));
        Assertions.assertEquals((int)2, (Integer)((Integer)opCounts.remove("UpdateBrokerConfig")));
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateProducerId")));
        Assertions.assertEquals((int)4, (Integer)((Integer)opCounts.remove("UpdateAcl")));
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateBrokerHealth")));
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("CreateReplicaExclusions")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)3, (int)topicClient.createdTopics.size());
        Assertions.assertTrue((boolean)topicClient.createdTopics.contains("foo"));
        Assertions.assertTrue((boolean)topicClient.createdTopics.contains("bar"));
        Assertions.assertTrue((boolean)topicClient.createdTopics.contains("freight"));
        Assertions.assertEquals((Object)"bar", (Object)configClient.writtenConfigs.get(new ConfigResource(ConfigResource.Type.BROKER, "0")).get("foo"));
        Assertions.assertEquals((Object)"quux", (Object)configClient.writtenConfigs.get(new ConfigResource(ConfigResource.Type.BROKER, "0")).get("baz"));
        Assertions.assertEquals((Object)"foobaz", (Object)configClient.writtenConfigs.get(new ConfigResource(ConfigResource.Type.BROKER, "1")).get("foobar"));
        Assertions.assertEquals((int)4, (int)aclClient.updatedResources.size());
        Assertions.assertEquals((int)1, (int)brokerHealthClient.updatedBrokerHealth.size());
        Assertions.assertEquals((int)1, (int)replicaExclusionClient.updatedReplicaExclusions.size());
    }

    @Test
    public void testReconcileSnapshotTopics() {
        CapturingTopicMigrationClient topicClient = new CapturingTopicMigrationClient(){

            @Override
            public void iterateTopics(EnumSet<TopicMigrationClient.TopicVisitorInterest> interests, TopicMigrationClient.TopicVisitor visitor) {
                HashMap<Integer, List<Integer>> assignments = new HashMap<Integer, List<Integer>>();
                assignments.put(0, Arrays.asList(2, 3, 4));
                assignments.put(1, Arrays.asList(3, 4, 5));
                assignments.put(2, Arrays.asList(2, 4, 5));
                visitor.visitTopic("foo", TopicsImageTest.FOO_UUID, assignments, Optional.empty());
            }
        };
        CapturingConfigMigrationClient configClient = new CapturingConfigMigrationClient();
        CapturingAclMigrationClient aclClient = new CapturingAclMigrationClient();
        CapturingClusterLinkMigrationClient linkMigrationClient = new CapturingClusterLinkMigrationClient();
        CapturingBrokerHealthMigrationClient brokerHealthClient = new CapturingBrokerHealthMigrationClient();
        CapturingReplicaExclusionMigrationClient replicaExclusionClient = new CapturingReplicaExclusionMigrationClient();
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0).setTopicMigrationClient(topicClient).setConfigMigrationClient(configClient).setAclMigrationClient(aclClient).setClusterLinkMigrationClient(linkMigrationClient).setBrokerHealthMigrationClient(brokerHealthClient).setReplicaExclusionMigrationClient(replicaExclusionClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient, __ -> {});
        MetadataImage image = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImageTest.IMAGE1, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        HashMap opCounts = new HashMap();
        KRaftMigrationOperationConsumer consumer = KRaftMigrationDriver.countingOperationConsumer(opCounts, (logMsg, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        writer.handleSnapshot(image, consumer);
        Assertions.assertEquals((int)2, (Integer)((Integer)opCounts.remove("CreateTopic")));
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdatePartition")));
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateTopic")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((Object)"bar", (Object)topicClient.createdTopics.get(0));
    }

    @Test
    public void testNewReplicaExclusions() {
        CapturingReplicaExclusionMigrationClient replicaExclusionClient = new CapturingReplicaExclusionMigrationClient();
        HashSet<Integer> zkRegisteredBrokers = new HashSet<Integer>(Arrays.asList(0, 1, 2));
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0, 1, 2).setReplicaExclusionMigrationClient(replicaExclusionClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient, __ -> {});
        HashMap opCounts = new HashMap();
        KRaftMigrationOperationConsumer consumer = KRaftMigrationDriver.countingOperationConsumer(opCounts, (logMsg, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        BrokerReplicaExclusionsImage image1 = new BrokerReplicaExclusionsImage(Collections.singletonMap(1, "RCCA-123"));
        writer.handleReplicaExclusionImage(image1, new HashSet<Integer>(zkRegisteredBrokers), consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("CreateReplicaExclusions")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)1, (int)replicaExclusionClient.updatedReplicaExclusions.size());
        this.checkReplicaExclusionsEqual(image1.activeBrokerReplicaExclusions(), replicaExclusionClient.updatedReplicaExclusions);
        BrokerReplicaExclusionsImage image2 = this.imageWithAdditionalExclusions(image1, Collections.singletonMap(2, "RCCA-234"));
        writer.handleReplicaExclusionImage(image2, new HashSet<Integer>(zkRegisteredBrokers), consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateReplicaExclusions")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)2, (int)replicaExclusionClient.updatedReplicaExclusions.size());
        this.checkReplicaExclusionsEqual(image2.activeBrokerReplicaExclusions(), replicaExclusionClient.updatedReplicaExclusions);
    }

    @Test
    public void testRemovingReplicaExclusions() {
        CapturingReplicaExclusionMigrationClient replicaExclusionClient = new CapturingReplicaExclusionMigrationClient();
        HashSet<Integer> zkRegisteredBrokers = new HashSet<Integer>(Arrays.asList(0, 1, 2));
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0, 1, 2).setReplicaExclusionMigrationClient(replicaExclusionClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient, __ -> {});
        HashMap opCounts = new HashMap();
        KRaftMigrationOperationConsumer consumer = KRaftMigrationDriver.countingOperationConsumer(opCounts, (logMsg, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        BrokerReplicaExclusionsImage image1 = new BrokerReplicaExclusionsImage(Collections.singletonMap(1, "RCCA-123"));
        BrokerReplicaExclusionsImage image2 = this.imageWithAdditionalExclusions(image1, Collections.singletonMap(2, "RCCA-234"));
        writer.handleReplicaExclusionImage(image2, zkRegisteredBrokers, consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("CreateReplicaExclusions")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)2, (int)replicaExclusionClient.updatedReplicaExclusions.size());
        this.checkReplicaExclusionsEqual(image2.activeBrokerReplicaExclusions(), replicaExclusionClient.updatedReplicaExclusions);
        writer.handleReplicaExclusionImage(image1, zkRegisteredBrokers, consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateReplicaExclusions")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)1, (int)replicaExclusionClient.updatedReplicaExclusions.size());
        this.checkReplicaExclusionsEqual(image1.activeBrokerReplicaExclusions(), replicaExclusionClient.updatedReplicaExclusions);
        writer.handleReplicaExclusionImage(new BrokerReplicaExclusionsImage(new HashMap()), zkRegisteredBrokers, consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateReplicaExclusions")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)0, (int)replicaExclusionClient.updatedReplicaExclusions.size());
    }

    @Test
    public void testNewDegradations() {
        CapturingBrokerHealthMigrationClient brokerHealthClient = new CapturingBrokerHealthMigrationClient();
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0, 1, 2).setBrokerHealthMigrationClient(brokerHealthClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient, __ -> {});
        HashMap opCounts = new HashMap();
        KRaftMigrationOperationConsumer consumer = KRaftMigrationDriver.countingOperationConsumer(opCounts, (logMsg, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        writer.handleClusterImage(ClusterImageTest.IMAGE1, consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateBrokerHealth")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)1, (int)brokerHealthClient.updatedBrokerHealth.size());
        Assertions.assertEquals((Object)DegradedBrokerHealthState.toDegradedBrokerComponents((Set)ClusterImageTest.IMAGE1.broker(1).degradedComponents()), brokerHealthClient.updatedBrokerHealth.get(1));
        DegradedBrokerHealthState degradedBrokerHealthState = new DegradedBrokerHealthState("RCCA-234", BrokerComponent.STORAGE);
        ClusterImage image2 = this.imageWithAdditionalDegradations(ClusterImageTest.IMAGE1, Collections.singletonMap(2, Collections.singleton(degradedBrokerHealthState)));
        writer.handleClusterImage(image2, consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateBrokerHealth")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)2, (int)brokerHealthClient.updatedBrokerHealth.size());
        Assertions.assertFalse((boolean)brokerHealthClient.updatedBrokerHealth.containsKey(0));
        Assertions.assertEquals((Object)DegradedBrokerHealthState.toDegradedBrokerComponents((Set)image2.broker(1).degradedComponents()), brokerHealthClient.updatedBrokerHealth.get(1));
        Assertions.assertEquals((Object)DegradedBrokerHealthState.toDegradedBrokerComponents((Set)image2.broker(2).degradedComponents()), brokerHealthClient.updatedBrokerHealth.get(2));
        HashMap<Integer, Set<DegradedBrokerHealthState>> additionalDegradations = new HashMap<Integer, Set<DegradedBrokerHealthState>>();
        additionalDegradations.put(1, Collections.singleton(degradedBrokerHealthState));
        additionalDegradations.put(2, Collections.singleton(degradedBrokerHealthState));
        ClusterImage image3 = this.imageWithAdditionalDegradations(ClusterImageTest.IMAGE1, additionalDegradations);
        image3.broker(1).degradedComponents().add(degradedBrokerHealthState);
        image3.broker(2).degradedComponents().add(degradedBrokerHealthState);
        writer.handleClusterImage(image3, consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateBrokerHealth")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)2, (int)brokerHealthClient.updatedBrokerHealth.size());
        Assertions.assertFalse((boolean)brokerHealthClient.updatedBrokerHealth.containsKey(0));
        Assertions.assertEquals((Object)DegradedBrokerHealthState.toDegradedBrokerComponents((Set)image3.broker(1).degradedComponents()), brokerHealthClient.updatedBrokerHealth.get(1));
        Assertions.assertEquals((Object)DegradedBrokerHealthState.toDegradedBrokerComponents((Set)image3.broker(2).degradedComponents()), brokerHealthClient.updatedBrokerHealth.get(2));
    }

    @Test
    public void testRemovingDegradations() {
        CapturingBrokerHealthMigrationClient brokerHealthClient = new CapturingBrokerHealthMigrationClient();
        CapturingMigrationClient migrationClient = CapturingMigrationClient.newBuilder().setBrokersInZk(0, 1, 2).setBrokerHealthMigrationClient(brokerHealthClient).build();
        KRaftMigrationZkWriter writer = new KRaftMigrationZkWriter((MigrationClient)migrationClient, __ -> {});
        HashMap opCounts = new HashMap();
        KRaftMigrationOperationConsumer consumer = KRaftMigrationDriver.countingOperationConsumer(opCounts, (logMsg, operation) -> operation.apply(ZkMigrationLeadershipState.EMPTY));
        DegradedBrokerHealthState degradedBrokerHealthState = new DegradedBrokerHealthState("RCCA-234", BrokerComponent.STORAGE);
        ClusterImage image2 = this.imageWithAdditionalDegradations(ClusterImageTest.IMAGE1, Collections.singletonMap(2, Collections.singleton(degradedBrokerHealthState)));
        writer.handleClusterImage(image2, consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateBrokerHealth")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)2, (int)brokerHealthClient.updatedBrokerHealth.size());
        Assertions.assertEquals((Object)DegradedBrokerHealthState.toDegradedBrokerComponents((Set)image2.broker(1).degradedComponents()), brokerHealthClient.updatedBrokerHealth.get(1));
        Assertions.assertEquals((Object)DegradedBrokerHealthState.toDegradedBrokerComponents((Set)image2.broker(2).degradedComponents()), brokerHealthClient.updatedBrokerHealth.get(2));
        writer.handleClusterImage(ClusterImageTest.IMAGE1, consumer);
        Assertions.assertEquals((int)1, (Integer)((Integer)opCounts.remove("UpdateBrokerHealth")));
        Assertions.assertEquals((int)0, (int)opCounts.size());
        Assertions.assertEquals((int)1, (int)brokerHealthClient.updatedBrokerHealth.size());
        Assertions.assertEquals((Object)DegradedBrokerHealthState.toDegradedBrokerComponents((Set)ClusterImageTest.IMAGE1.broker(1).degradedComponents()), brokerHealthClient.updatedBrokerHealth.get(1));
    }

    private ClusterImage imageWithAdditionalDegradations(ClusterImage baseImage, Map<Integer, Set<DegradedBrokerHealthState>> additionalDegradations) {
        HashMap updatedBrokers = new HashMap(baseImage.brokers());
        baseImage.brokers().forEach((brokerId, brokerRegistration) -> {
            if (additionalDegradations.containsKey(brokerId)) {
                HashSet updatedBrokerHealthState = new HashSet((Collection)additionalDegradations.get(brokerId));
                updatedBrokerHealthState.addAll(brokerRegistration.degradedComponents());
                updatedBrokers.put(brokerId, brokerRegistration.cloneWith(Optional.empty(), Optional.empty(), Optional.of(updatedBrokerHealthState), Optional.empty()));
            }
        });
        return new ClusterImage(updatedBrokers, Collections.emptyMap());
    }

    private BrokerReplicaExclusionsImage imageWithAdditionalExclusions(BrokerReplicaExclusionsImage baseImage, Map<Integer, String> additionalExclusions) {
        HashMap<Integer, String> updatedExclusions = new HashMap<Integer, String>(baseImage.activeBrokerReplicaExclusions());
        updatedExclusions.putAll(additionalExclusions);
        return new BrokerReplicaExclusionsImage(updatedExclusions);
    }

    private void checkReplicaExclusionsEqual(Map<Integer, String> expectedReplicaExclusions, Set<BrokerReplicaExclusion> actualReplicaExclusions) {
        Set expected = expectedReplicaExclusions.entrySet().stream().map(e -> new BrokerReplicaExclusion(((Integer)e.getKey()).intValue(), (String)e.getValue())).collect(Collectors.toSet());
        Assertions.assertEquals(expected, actualReplicaExclusions);
    }
}

