/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.config;

import java.util.HashMap;
import org.apache.kafka.metadata.config.ConfigRegistryTestConstants;
import org.apache.kafka.metadata.config.SpecificResourceConfigMonitor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=120L)
public final class SpecificResourceConfigMonitorTest {
    private static final Logger LOG = LoggerFactory.getLogger(SpecificResourceConfigMonitorTest.class);

    @Test
    public void testKeyAndDefinition() {
        TestContext context = new TestContext();
        Assertions.assertEquals((Object)ConfigRegistryTestConstants.BROKER_NUM_QUUX, (Object)context.monitor.keyAndDefinition());
    }

    @Test
    public void testKey() {
        TestContext context = new TestContext();
        Assertions.assertEquals((Object)ConfigRegistryTestConstants.BROKER_NUM_QUUX.key(), (Object)context.monitor.key());
    }

    @Test
    public void testDefinition() {
        TestContext context = new TestContext();
        Assertions.assertEquals((Object)ConfigRegistryTestConstants.BROKER_NUM_QUUX.definition(), (Object)context.monitor.definition());
    }

    @Test
    public void testNoUpdates() {
        TestContext context = new TestContext();
        Assertions.assertEquals((int)5, (Integer)((Integer)context.monitor.effectiveValue()));
    }

    @Test
    public void testUpdateSpecificResource() {
        TestContext context = new TestContext();
        context.monitor.update(LOG, "1", "123");
        Assertions.assertEquals((int)123, (Integer)((Integer)context.monitor.effectiveValue()));
    }

    @Test
    public void testUpdateSpecificResourceTwiceHasNoEffect() {
        TestContext context = new TestContext();
        context.monitor.update(LOG, "1", "123");
        context.monitor.update(LOG, "1", "123");
        Assertions.assertEquals((int)123, (Integer)((Integer)context.monitor.effectiveValue()));
    }

    @Test
    public void testUpdateOtherResource() {
        TestContext context = new TestContext();
        context.monitor.update(LOG, "2", "123");
        Assertions.assertEquals((int)5, (Integer)((Integer)context.monitor.effectiveValue()));
    }

    @Test
    public void testUpdateDefaultResource() {
        TestContext context = new TestContext();
        context.monitor.update(LOG, "", "456");
        Assertions.assertEquals((int)456, (Integer)((Integer)context.monitor.effectiveValue()));
    }

    @Test
    public void testUpdateAndRemoveDefaultResource() {
        TestContext context = new TestContext();
        context.monitor.update(LOG, "", "123");
        context.monitor.update(LOG, "", null);
        Assertions.assertEquals((int)5, (Integer)((Integer)context.monitor.effectiveValue()));
    }

    @Test
    public void testUpdateSpecificResourceAndDefault() {
        TestContext context = new TestContext();
        context.monitor.update(LOG, "", "123");
        context.monitor.update(LOG, "1", "456");
        context.monitor.update(LOG, "2", "789");
        Assertions.assertEquals((int)456, (Integer)((Integer)context.monitor.effectiveValue()));
    }

    @Test
    public void testUpdateSpecificResourceAndRemove() {
        TestContext context = new TestContext();
        context.monitor.update(LOG, "", "123");
        context.monitor.update(LOG, "1", "456");
        context.monitor.update(LOG, "1", null);
        Assertions.assertEquals((int)123, (Integer)((Integer)context.monitor.effectiveValue()));
    }

    static class TestContext {
        SpecificResourceConfigMonitor<Integer> monitor = new SpecificResourceConfigMonitor(ConfigRegistryTestConstants.BROKER_NUM_QUUX, "1", new HashMap(), (Object)5);

        TestContext() {
        }
    }
}

