/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Collections;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.authorizer.PrefixNode;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PrefixNodeTest {
    @Test
    public void testValidateAclCache() {
        Assertions.assertTrue((boolean)PrefixNode.EMPTY.validateAclCache(KafkaPrincipal.ANONYMOUS, ResourceType.ANY, "ANY"));
        StandardAcl childAcl = StandardAuthorizerTestConstants.PREFIX_ACLS.get(2);
        ResourceAcls resourceAcls = new ResourceAcls(childAcl);
        PrefixNode childNode = new PrefixNode(childAcl.resourceName(), resourceAcls, new PrefixNode[0]);
        Assertions.assertTrue((boolean)childNode.validateAclCache(childAcl.kafkaPrincipal(), childAcl.resourceType(), childAcl.resourceName()));
        StandardAcl parentAcl = StandardAuthorizerTestConstants.PREFIX_ACLS.get(5);
        resourceAcls = new ResourceAcls(parentAcl);
        PrefixNode parentNode = new PrefixNode(parentAcl.resourceName(), resourceAcls, new PrefixNode[]{childNode});
        Assertions.assertTrue((boolean)parentNode.validateAclCache(parentAcl.kafkaPrincipal(), parentAcl.resourceType(), parentAcl.resourceName()));
    }

    @Test
    public void testEmptyPrefixNode() {
        Assertions.assertTrue((boolean)PrefixNode.EMPTY.isEmpty());
        Assertions.assertEquals(Collections.emptyList(), (Object)PrefixNode.EMPTY.acls());
        Assertions.assertEquals((Object)ResourceAcls.EMPTY, (Object)PrefixNode.EMPTY.resourceAcls());
        Assertions.assertTrue((boolean)PrefixNode.EMPTY.children().isEmpty());
        Assertions.assertFalse((boolean)PrefixNode.EMPTY.findMatchingAcl(null, null).isPresent());
    }

    @Test
    public void testWildCardAuthorize() {
        StandardAcl childAcl = StandardAuthorizerTestConstants.PREFIX_ACLS.get(0);
        ResourceAcls resourceAcls = new ResourceAcls(childAcl);
        PrefixNode childPrefixNode = new PrefixNode(childAcl.resourceName(), resourceAcls, new PrefixNode[0]);
        resourceAcls = new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1);
        PrefixNode prefixNode = new PrefixNode("", resourceAcls, new PrefixNode[]{childPrefixNode});
        Assertions.assertFalse((boolean)prefixNode.findMatchingAcl(AclOperation.READ, "127.0.0.1").isPresent());
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0), prefixNode.findMatchingAcl(AclOperation.WRITE, "127.0.0.1").get());
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1), prefixNode.findMatchingAcl(AclOperation.READ, "127.0.0.10").get());
    }

    @Test
    public void testAuthorizeWildCardAclHostMatch() {
        StandardAcl childAcl = StandardAuthorizerTestConstants.PREFIX_ACLS.get(0);
        ResourceAcls resourceAcls = new ResourceAcls(childAcl);
        PrefixNode childPrefixNode = new PrefixNode(childAcl.resourceName(), resourceAcls, new PrefixNode[0]);
        resourceAcls = new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1);
        PrefixNode prefixNode = new PrefixNode("", resourceAcls, new PrefixNode[]{childPrefixNode});
        Assertions.assertFalse((boolean)prefixNode.findMatchingAcl(AclOperation.READ, "127.0.0.1").isPresent());
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1), prefixNode.findMatchingAcl(AclOperation.READ, "127.0.0.10").get());
    }
}

