/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.metadata.authorizer.AclLoader;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.PrefixNode;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTestConstants;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class AclLoaderTest {
    private static final List<Map<Uuid, ConfluentStandardAcl>> SNAPSHOTS = Arrays.asList(Collections.unmodifiableMap(AclLoaderTest.generateSnapshot0()), Collections.unmodifiableMap(AclLoaderTest.generateSnapshot1()), Collections.unmodifiableMap(AclLoaderTest.generateSnapshot2()));

    private static Map<Uuid, ConfluentStandardAcl> generateSnapshot0() {
        HashMap<Uuid, ConfluentStandardAcl> snapshot = new HashMap<Uuid, ConfluentStandardAcl>();
        StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.LITERAL_ACLS.subList(0, 3)).forEach(aclWithId -> snapshot.put(aclWithId.id(), aclWithId.acl()));
        StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.PREFIX_ACLS.subList(0, 1)).forEach(aclWithId -> snapshot.put(aclWithId.id(), aclWithId.acl()));
        return snapshot;
    }

    private static Map<Uuid, ConfluentStandardAcl> generateSnapshot1() {
        HashMap<Uuid, ConfluentStandardAcl> snapshot = new HashMap<Uuid, ConfluentStandardAcl>();
        StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.WILDCARD_ACLS.subList(0, 2)).forEach(aclWithId -> snapshot.put(aclWithId.id(), aclWithId.acl()));
        StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.LITERAL_ACLS.subList(0, 3)).forEach(aclWithId -> snapshot.put(aclWithId.id(), aclWithId.acl()));
        StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.PREFIX_ACLS.subList(0, 5)).forEach(aclWithId -> snapshot.put(aclWithId.id(), aclWithId.acl()));
        return snapshot;
    }

    private static Map<Uuid, ConfluentStandardAcl> generateSnapshot2() {
        HashMap<Uuid, ConfluentStandardAcl> snapshot = new HashMap<Uuid, ConfluentStandardAcl>();
        StandardAuthorizerTestConstants.withIdsAndDeletedState(StandardAuthorizerTestConstants.LITERAL_ACLS.subList(0, 3)).forEach(aclWithId -> snapshot.put(aclWithId.id(), aclWithId.acl()));
        StandardAuthorizerTestConstants.withIdsAndDeletedState(StandardAuthorizerTestConstants.PREFIX_ACLS.subList(0, 1)).forEach(aclWithId -> snapshot.put(aclWithId.id(), aclWithId.acl()));
        return snapshot;
    }

    @Test
    public void testLoadSnapshot0() {
        AclLoader loader = new AclLoader(SNAPSHOTS.get(0));
        ImmutableMap expectedLiteralsForPrincipal = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(0).resource(), (Object)new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.LITERAL_ACLS.get(0))));
        ImmutableMap expectedLiterals = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(0).kafkaPrincipal(), (Object)expectedLiteralsForPrincipal);
        expectedLiteralsForPrincipal = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(1).resource(), (Object)new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.LITERAL_ACLS.get(1))));
        expectedLiterals = expectedLiterals.updated((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(1).kafkaPrincipal(), (Object)expectedLiteralsForPrincipal);
        expectedLiteralsForPrincipal = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(2).resource(), (Object)new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.LITERAL_ACLS.get(2))));
        expectedLiterals = expectedLiterals.updated((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(2).kafkaPrincipal(), (Object)expectedLiteralsForPrincipal);
        ImmutableMap expectedPrefixedForResourceType = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(0).kafkaPrincipal(), (Object)new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("foo_", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0))), new PrefixNode[0])}));
        ImmutableMap expectedPrefixed = ImmutableMap.singleton((Object)ResourceType.TOPIC, (Object)expectedPrefixedForResourceType);
        AclLoader.Result result = loader.build();
        Assertions.assertEquals((Object)result.newAclsById(), (Object)ImmutableMap.from(SNAPSHOTS.get(0)));
        Assertions.assertEquals((Object)expectedLiterals, (Object)result.newLiterals());
        Assertions.assertEquals((Object)expectedPrefixed, (Object)result.newPrefixed());
    }

    @Test
    public void testLoadSnapshot1() {
        AclLoader loader = new AclLoader(SNAPSHOTS.get(1));
        ImmutableMap expectedPrefixedForPrincipal = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0).kafkaPrincipal(), (Object)new PrefixNode("", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0))), new PrefixNode[]{new PrefixNode("foo_", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0))), new PrefixNode[0])}));
        expectedPrefixedForPrincipal = expectedPrefixedForPrincipal.updated((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1).kafkaPrincipal(), (Object)new PrefixNode("", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1))), new PrefixNode[0]));
        ImmutableMap expectedPrefixed = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0).resourceType(), (Object)expectedPrefixedForPrincipal);
        expectedPrefixedForPrincipal = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(1).kafkaPrincipal(), (Object)new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("mygroup", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1))), new PrefixNode[0]), new PrefixNode("foo", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2))), new PrefixNode[0])}));
        expectedPrefixedForPrincipal = expectedPrefixedForPrincipal.updated((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(3).kafkaPrincipal(), (Object)new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("f", new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3), StandardAuthorizerTestConstants.PREFIX_ACLS.get(4))), new PrefixNode[0])}));
        expectedPrefixed = expectedPrefixed.updated((Object)ResourceType.GROUP, (Object)expectedPrefixedForPrincipal);
        AclLoader.Result result = loader.build();
        Assertions.assertEquals(SNAPSHOTS.get(1), (Object)result.newAclsById());
        Assertions.assertEquals((Object)expectedPrefixed, (Object)result.newPrefixed());
    }

    @Test
    public void testLoadSnapshot2() {
        AclLoader loader = new AclLoader(SNAPSHOTS.get(2));
        AclLoader.Result result = loader.build();
        Assertions.assertEquals(SNAPSHOTS.get(2), (Object)result.newAclsById());
        Assertions.assertEquals((int)result.newAclsByResource().size(), (int)0);
        Assertions.assertEquals((int)result.newInactiveAclsByResource().size(), (int)4);
        Assertions.assertEquals((int)result.newPrefixed().size(), (int)0);
        Assertions.assertEquals((int)result.newLiterals().size(), (int)0);
    }

    @Test
    public void testLoadLiteralDelta() {
        AclLoader loader = new AclLoader(SNAPSHOTS.get(0));
        AclLoader.Result result = loader.build();
        HashMap changes = new HashMap();
        changes.put(StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.LITERAL_ACLS.get(0)), Optional.of(new ConfluentStandardAcl(StandardAuthorizerTestConstants.LITERAL_ACLS.get(3), Optional.empty())));
        changes.put(StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.LITERAL_ACLS.get(1)), Optional.empty());
        ImmutableMap newAclsById = ImmutableMap.from(SNAPSHOTS.get(0));
        newAclsById = newAclsById.updated((Object)StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.LITERAL_ACLS.get(0)), (Object)new ConfluentStandardAcl(StandardAuthorizerTestConstants.LITERAL_ACLS.get(3), Optional.empty()));
        newAclsById = newAclsById.removed((Object)StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.LITERAL_ACLS.get(1)));
        ImmutableMap expectedLiteralsForPrincipal = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(2).resource(), (Object)new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.LITERAL_ACLS.get(2))));
        ImmutableMap expectedLiterals = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(2).kafkaPrincipal(), (Object)expectedLiteralsForPrincipal);
        expectedLiteralsForPrincipal = expectedLiteralsForPrincipal.updated((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(3).resource(), (Object)new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.LITERAL_ACLS.get(3))));
        expectedLiterals = expectedLiterals.updated((Object)StandardAuthorizerTestConstants.LITERAL_ACLS.get(2).kafkaPrincipal(), (Object)expectedLiteralsForPrincipal);
        AclLoader loader2 = new AclLoader(result.newAclsById(), result.newAclsByResource(), result.newInactiveAclsByResource(), result.newPrefixed(), result.newLiterals(), changes);
        AclLoader.Result result2 = loader2.build();
        Assertions.assertEquals((Object)newAclsById, (Object)result2.newAclsById());
        Assertions.assertEquals((Object)expectedLiterals, (Object)result2.newLiterals());
        Assertions.assertEquals((Object)result.newPrefixed(), (Object)result2.newPrefixed());
    }

    @Test
    public void testLoadPrefixDelta() {
        AclLoader loader = new AclLoader(SNAPSHOTS.get(1));
        AclLoader.Result result1 = loader.build();
        HashMap changes2 = new HashMap();
        changes2.put(StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3)), Optional.empty());
        AclLoader loader2 = new AclLoader(result1.newAclsById(), result1.newAclsByResource(), result1.newInactiveAclsByResource(), result1.newPrefixed(), result1.newLiterals(), changes2);
        AclLoader.Result result2 = loader2.build();
        ImmutableMap expectedPrefixedForPrincipal2 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0).kafkaPrincipal(), (Object)new PrefixNode("", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0))), new PrefixNode[]{new PrefixNode("foo_", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0))), new PrefixNode[0])}));
        expectedPrefixedForPrincipal2 = expectedPrefixedForPrincipal2.updated((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1).kafkaPrincipal(), (Object)new PrefixNode("", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1))), new PrefixNode[0]));
        ImmutableMap expectedPrefixed2 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0).resourceType(), (Object)expectedPrefixedForPrincipal2);
        expectedPrefixedForPrincipal2 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(1).kafkaPrincipal(), (Object)new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("mygroup", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1))), new PrefixNode[0]), new PrefixNode("foo", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2))), new PrefixNode[0])}));
        expectedPrefixedForPrincipal2 = expectedPrefixedForPrincipal2.updated((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(3).kafkaPrincipal(), (Object)new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("f", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(4))), new PrefixNode[0])}));
        expectedPrefixed2 = expectedPrefixed2.updated((Object)ResourceType.GROUP, (Object)expectedPrefixedForPrincipal2);
        Assertions.assertEquals((Object)expectedPrefixed2, (Object)result2.newPrefixed());
        HashMap changes3 = new HashMap();
        changes3.put(StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(4)), Optional.empty());
        changes3.put(StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5)), Optional.of(new ConfluentStandardAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5), Optional.empty())));
        AclLoader loader3 = new AclLoader(result2.newAclsById(), result2.newAclsByResource(), result2.newInactiveAclsByResource(), result2.newPrefixed(), result2.newLiterals(), changes3);
        AclLoader.Result result3 = loader3.build();
        ImmutableMap expectedPrefixedForPrincipal3 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0).kafkaPrincipal(), (Object)new PrefixNode("", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0))), new PrefixNode[]{new PrefixNode("foo_", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0))), new PrefixNode[0])}));
        expectedPrefixedForPrincipal3 = expectedPrefixedForPrincipal3.updated((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1).kafkaPrincipal(), (Object)new PrefixNode("", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1))), new PrefixNode[0]));
        ImmutableMap expectedPrefixed3 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0).resourceType(), (Object)expectedPrefixedForPrincipal3);
        expectedPrefixedForPrincipal3 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(1).kafkaPrincipal(), (Object)new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("mygroup", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1))), new PrefixNode[0]), new PrefixNode("f", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5))), new PrefixNode[]{new PrefixNode("foo", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2))), new PrefixNode[0])})}));
        expectedPrefixed3 = expectedPrefixed3.updated((Object)ResourceType.GROUP, (Object)expectedPrefixedForPrincipal3);
        Assertions.assertEquals((Object)expectedPrefixed3, (Object)result3.newPrefixed());
        HashMap changes4 = new HashMap();
        changes4.put(StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5)), Optional.empty());
        AclLoader loader4 = new AclLoader(result3.newAclsById(), result3.newAclsByResource(), result3.newInactiveAclsByResource(), result3.newPrefixed(), result3.newLiterals(), changes4);
        AclLoader.Result result4 = loader4.build();
        ImmutableMap expectedPrefixedForPrincipal4 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0).kafkaPrincipal(), (Object)new PrefixNode("", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0))), new PrefixNode[]{new PrefixNode("foo_", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0))), new PrefixNode[0])}));
        expectedPrefixedForPrincipal4 = expectedPrefixedForPrincipal4.updated((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1).kafkaPrincipal(), (Object)new PrefixNode("", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1))), new PrefixNode[0]));
        ImmutableMap expectedPrefixed4 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0).resourceType(), (Object)expectedPrefixedForPrincipal4);
        expectedPrefixedForPrincipal4 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(1).kafkaPrincipal(), (Object)new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("mygroup", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1))), new PrefixNode[0]), new PrefixNode("foo", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2))), new PrefixNode[0])}));
        expectedPrefixed4 = expectedPrefixed4.updated((Object)ResourceType.GROUP, (Object)expectedPrefixedForPrincipal4);
        Assertions.assertEquals((Object)expectedPrefixed4, (Object)result4.newPrefixed());
    }

    @Test
    public void testLoadPrefixDelta2() {
        AclLoader loader1 = new AclLoader(ImmutableMap.empty(), ImmutableMap.empty(), ImmutableMap.empty(), ImmutableMap.empty(), ImmutableMap.empty(), Collections.emptyMap());
        AclLoader.Result result1 = loader1.build();
        Assertions.assertEquals(Collections.emptyMap(), (Object)result1.newPrefixed());
        HashMap<Uuid, Optional<ConfluentStandardAcl>> changes1 = new HashMap<Uuid, Optional<ConfluentStandardAcl>>();
        changes1.put(StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1)), Optional.of(new ConfluentStandardAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1), Optional.empty())));
        changes1.put(StandardAuthorizerTestConstants.idForAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2)), Optional.of(new ConfluentStandardAcl(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2), Optional.empty())));
        AclLoader loader2 = new AclLoader(result1.newAclsById(), result1.newAclsByResource(), result1.newInactiveAclsByResource(), result1.newPrefixed(), result1.newLiterals(), changes1);
        AclLoader.Result result2 = loader2.build();
        ImmutableMap expectedPrefixedForPrincipal2 = ImmutableMap.singleton((Object)StandardAuthorizerTestConstants.PREFIX_ACLS.get(1).kafkaPrincipal(), (Object)new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("mygroup", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1))), new PrefixNode[0]), new PrefixNode("foo", new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2))), new PrefixNode[0])}));
        ImmutableMap expectedPrefixed2 = ImmutableMap.singleton((Object)ResourceType.GROUP, (Object)expectedPrefixedForPrincipal2);
        Assertions.assertEquals((Object)expectedPrefixed2, (Object)result2.newPrefixed());
    }
}

