/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.OptionalInt;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.loader.SnapshotManifest;
import org.apache.kafka.image.publisher.ControllerRegistrationsPublisher;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class ControllerRegistrationsPublisherTest {
    private static final MetadataDelta TEST_DELTA;
    private static final MetadataImage TEST_IMAGE;
    private static final MetadataProvenance PROVENANCE;

    @Test
    public void testInitialControllers() {
        ControllerRegistrationsPublisher publisher = new ControllerRegistrationsPublisher();
        Assertions.assertEquals(Collections.emptyMap(), (Object)publisher.controllers());
    }

    @Test
    public void testName() {
        ControllerRegistrationsPublisher publisher = new ControllerRegistrationsPublisher();
        Assertions.assertEquals((Object)"ControllerRegistrationsPublisher", (Object)publisher.name());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testOnMetadataUpdate(boolean fromSnapshot) {
        ControllerRegistrationsPublisher publisher = new ControllerRegistrationsPublisher();
        if (fromSnapshot) {
            publisher.onMetadataUpdate(TEST_DELTA, TEST_IMAGE, (LoaderManifest)new SnapshotManifest(new MetadataProvenance(100L, 10, 2000L), 100L));
        } else {
            publisher.onMetadataUpdate(TEST_DELTA, TEST_IMAGE, (LoaderManifest)LogDeltaManifest.newBuilder().provenance(PROVENANCE).leaderAndEpoch(new LeaderAndEpoch(OptionalInt.of(1), 200)).numBatches(3).elapsedNs(1000L).numBytes(234L).build());
        }
        System.out.println("TEST_IMAGE.cluster = " + TEST_IMAGE.cluster());
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1, 2)), publisher.controllers().keySet());
        Assertions.assertTrue((boolean)((ControllerRegistration)publisher.controllers().get(0)).zkMigrationReady());
        Assertions.assertFalse((boolean)((ControllerRegistration)publisher.controllers().get(1)).zkMigrationReady());
        Assertions.assertFalse((boolean)((ControllerRegistration)publisher.controllers().get(2)).zkMigrationReady());
    }

    static {
        PROVENANCE = new MetadataProvenance(100L, 10, 2000L);
        TEST_DELTA = new MetadataDelta.Builder().build();
        TEST_DELTA.replay(new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(MetadataVersion.IBP_3_6_IV2.confluentFeatureLevel()));
        TEST_DELTA.replay(RecordTestUtils.createTestControllerRegistration(0, true));
        TEST_DELTA.replay(RecordTestUtils.createTestControllerRegistration(1, false));
        TEST_DELTA.replay(RecordTestUtils.createTestControllerRegistration(2, false));
        TEST_IMAGE = TEST_DELTA.apply(PROVENANCE);
    }
}

