/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.node.ClusterLinksImageNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.ClusterLink;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClusterLinksImageNodeTest {
    private static final ClusterLinksImage IMAGE;
    private static final ClusterLinksImageNode NODE;

    @Test
    public void testDirectChildren() {
        Assertions.assertEquals(Arrays.asList("byId", "byName", "linkNamesByTenant"), (Object)NODE.childNames());
    }

    @Test
    public void testClusterLinksImageByIdChildren() {
        MetadataNode idNode = NODE.child("byId");
        Assertions.assertNotNull((Object)idNode);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("Jz1HO4dfRvOZxNZ0SZVWsg", "1L7zmca9TaaZXmKA1Hy5pw")), new HashSet(idNode.childNames()));
    }

    @Test
    public void testClusterLinksImageByIdChild() {
        MetadataNode idNode = NODE.child("byId");
        Assertions.assertNotNull((Object)idNode);
        Assertions.assertEquals((Object)"ClusterLinkImage(linkName=myClusterLink1, linkId=Jz1HO4dfRvOZxNZ0SZVWsg, tenantPrefix=lkc-pgg01o, remoteClusterId=myRemoteClusterId1, linkMode=DESTINATION)", (Object)idNode.child("Jz1HO4dfRvOZxNZ0SZVWsg").stringify());
    }

    @Test
    public void testClusterLinksImageByIdNonExistentChild() {
        MetadataNode idNode = NODE.child("byId");
        Assertions.assertNotNull((Object)idNode);
        Assertions.assertNull((Object)idNode.child("zzdG5AVOT9yVvXGMOQk3iA"));
    }

    @Test
    public void testClusterLinksImageByNameChildren() {
        MetadataNode nameNode = NODE.child("byName");
        Assertions.assertNotNull((Object)nameNode);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("myClusterLink1", "myClusterLink2")), new HashSet(nameNode.childNames()));
    }

    @Test
    public void testClusterLinksImageByNameChild() {
        MetadataNode nameNode = NODE.child("byName");
        Assertions.assertNotNull((Object)nameNode);
        Assertions.assertEquals((Object)"ClusterLinkImage(linkName=myClusterLink2, linkId=1L7zmca9TaaZXmKA1Hy5pw, remoteClusterId=myRemoteClusterId2, linkMode=DESTINATION)", (Object)nameNode.child("myClusterLink2").stringify());
    }

    @Test
    public void testClusterLinksImageByNameNonExistentChild() {
        MetadataNode nameNode = NODE.child("byName");
        Assertions.assertNotNull((Object)nameNode);
        Assertions.assertNull((Object)nameNode.child("myClusterLink3"));
    }

    @Test
    public void testLinkNamesByTenantChildren() {
        MetadataNode linkNamesByTenantNode = NODE.child("linkNamesByTenant");
        Assertions.assertNotNull((Object)linkNamesByTenantNode);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("lkc-pgg01o")), new HashSet(linkNamesByTenantNode.childNames()));
    }

    @Test
    public void testLinkNamesByTenantChild() {
        MetadataNode linkNamesByTenantNode = NODE.child("linkNamesByTenant");
        Assertions.assertNotNull((Object)linkNamesByTenantNode);
        Assertions.assertEquals((Object)"myClusterLink1", (Object)linkNamesByTenantNode.child("lkc-pgg01o").stringify());
    }

    @Test
    public void testLinkNamesByTenantNonExistentChild() {
        MetadataNode idNode = NODE.child("linkNamesByTenant");
        Assertions.assertNotNull((Object)idNode);
        Assertions.assertNull((Object)idNode.child("lkc-abcde"));
    }

    static {
        HashMap linksById = new HashMap();
        HashMap linksByName = new HashMap();
        HashMap linkNamesByTenant = new HashMap();
        ClusterLink cl1 = new ClusterLink("myClusterLink1", Uuid.fromString((String)"Jz1HO4dfRvOZxNZ0SZVWsg"), "lkc-pgg01o", "myRemoteClusterId1", "DESTINATION");
        ClusterLink cl2 = new ClusterLink("myClusterLink2", Uuid.fromString((String)"1L7zmca9TaaZXmKA1Hy5pw"), null, "myRemoteClusterId2", "DESTINATION");
        Arrays.asList(cl1, cl2).forEach(clusterLink -> {
            linksById.put(clusterLink.linkId(), clusterLink);
            linksByName.put(clusterLink.linkName(), clusterLink);
            clusterLink.tenantPrefix().ifPresent(prefix -> linkNamesByTenant.computeIfAbsent(prefix, __ -> new HashSet()).add(clusterLink.linkName()));
        });
        IMAGE = new ClusterLinksImage(linksById, linksByName, linkNamesByTenant);
        NODE = new ClusterLinksImageNode(IMAGE);
    }
}

