/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.node.ClusterImageControllersNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.VersionRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClusterImageControllersNodeTest {
    private static final ClusterImage TEST_IMAGE = new ClusterImage(Collections.emptyMap(), Collections.singletonMap(2, new ControllerRegistration.Builder().setId(2).setIncarnationId(Uuid.fromString((String)"adGo6sTPS0uJshjvdTUmqQ")).setZkMigrationReady(false).setSupportedFeatures(Collections.singletonMap("confluent.metadata.version", VersionRange.of((int)100, (int)104))).setListeners(Collections.emptyMap()).build()));
    private static final ClusterImageControllersNode NODE = new ClusterImageControllersNode(TEST_IMAGE);

    @Test
    public void testChildNames() {
        Assertions.assertEquals(Arrays.asList("2"), (Object)NODE.childNames());
    }

    @Test
    public void testNode1Child() {
        MetadataNode child = NODE.child("2");
        Assertions.assertNotNull((Object)child);
        Assertions.assertEquals((Object)"ControllerRegistration(id=2, incarnationId=adGo6sTPS0uJshjvdTUmqQ, zkMigrationReady=false, listeners=[], supportedFeatures={confluent.metadata.version: 100-104}, metadataEncryptors=null)", (Object)child.stringify());
    }

    @Test
    public void testUnknownChild() {
        Assertions.assertNull((Object)NODE.child("1"));
    }
}

