/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.CellState;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.node.CellImageNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class CellImageNodeTest {
    private static final Map<Integer, Cell> CELL_ID_TO_CELL;
    private static final byte CELL_MIGRATION_STATE;
    private static final CellImage IMAGE;
    private static final CellImageNode NODE;

    @Test
    public void testChild0() {
        Assertions.assertEquals((Object)"Cell{cellId=0, brokers=[0, 1, 2], state=READY, minSize=0, maxSize=3}", (Object)NODE.child("0").stringify());
    }

    @Test
    public void testChild2() {
        Assertions.assertEquals((Object)"Cell{cellId=2, brokers=[3, 4, 5], state=QUARANTINED, minSize=2, maxSize=4}", (Object)NODE.child("2").stringify());
    }

    @Test
    public void testNonExistentChild() {
        Assertions.assertNull((Object)NODE.child("3"));
    }

    static {
        HashMap<Integer, Cell> cells = new HashMap<Integer, Cell>();
        cells.put(0, new Cell(0, new HashSet<Integer>(Arrays.asList(0, 1, 2)), CellState.READY, 0, 3));
        cells.put(2, new Cell(2, new HashSet<Integer>(Arrays.asList(3, 4, 5)), CellState.QUARANTINED, 2, 4));
        CELL_ID_TO_CELL = Collections.unmodifiableMap(cells);
        CELL_MIGRATION_STATE = CellMigrationState.INITIATED.code();
        IMAGE = new CellImage(CELL_ID_TO_CELL, CELL_MIGRATION_STATE);
        NODE = new CellImageNode(IMAGE);
    }
}

