/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.metadata.RemoveUserScramCredentialRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ScramDelta;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ScramImageTest {
    public static final ScramImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final ScramDelta DELTA1;
    static final ScramImage IMAGE2;

    static byte[] randomBuffer(Random random, int length) {
        byte[] buf = new byte[length];
        random.nextBytes(buf);
        return buf;
    }

    static ScramCredentialData randomScramCredentialData(Random random) {
        return new ScramCredentialData(ScramImageTest.randomBuffer(random, 1024), ScramImageTest.randomBuffer(random, 1024), ScramImageTest.randomBuffer(random, 1024), 1024 + random.nextInt(1024));
    }

    @Test
    public void testEmptyImageRoundTrip() {
        ScramImageTest.testToImage(ScramImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        ScramImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = ScramImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        ScramImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        ScramImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(ScramImage image) {
        ScramImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(ScramImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        ScramImageTest.testToImage(image, fromRecords.orElseGet(() -> ScramImageTest.getImageRecords(image)));
    }

    private static void testToImage(ScramImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<ScramDelta, ScramImage>(() -> ScramImage.EMPTY, ScramDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(ScramImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        return writer.records();
    }

    @Test
    public void testEmptyWithInvalidIBP() {
        ImageWriterOptions imageWriterOptions = new ImageWriterOptions.Builder().setMetadataVersion(MetadataVersion.IBP_3_4_IV0).build();
        RecordListWriter writer = new RecordListWriter();
        ScramImage.EMPTY.write((ImageWriter)writer, imageWriterOptions);
    }

    @Test
    public void testImage1withInvalidIBP() {
        ImageWriterOptions imageWriterOptions = new ImageWriterOptions.Builder().setMetadataVersion(MetadataVersion.IBP_3_4_IV0).build();
        RecordListWriter writer = new RecordListWriter();
        try {
            IMAGE1.write((ImageWriter)writer, imageWriterOptions);
            Assertions.fail((String)"expected exception writing IMAGE with SCRAM records for MetadataVersion.IBP_3_4_IV0");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        MockRandom random = new MockRandom();
        HashMap image1mechanisms = new HashMap();
        HashMap<String, ScramCredentialData> image1sha256 = new HashMap<String, ScramCredentialData>();
        image1sha256.put("alpha", ScramImageTest.randomScramCredentialData((Random)random));
        image1sha256.put("beta", ScramImageTest.randomScramCredentialData((Random)random));
        image1mechanisms.put(ScramMechanism.SCRAM_SHA_256, image1sha256);
        HashMap<String, ScramCredentialData> image1sha512 = new HashMap<String, ScramCredentialData>();
        image1sha512.put("alpha", ScramImageTest.randomScramCredentialData((Random)random));
        image1sha512.put("gamma", ScramImageTest.randomScramCredentialData((Random)random));
        image1mechanisms.put(ScramMechanism.SCRAM_SHA_512, image1sha512);
        IMAGE1 = new ScramImage(image1mechanisms);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveUserScramCredentialRecord().setName("alpha").setMechanism(ScramMechanism.SCRAM_SHA_512.type()), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveUserScramCredentialRecord().setName("gamma").setMechanism(ScramMechanism.SCRAM_SHA_512.type()), 0));
        ScramCredentialData secondAlpha256Credential = ScramImageTest.randomScramCredentialData((Random)random);
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new UserScramCredentialRecord().setName("alpha").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setSalt(secondAlpha256Credential.salt()).setStoredKey(secondAlpha256Credential.storedKey()).setServerKey(secondAlpha256Credential.serverKey()).setIterations(secondAlpha256Credential.iterations()), 0));
        ScramCredentialData secondAlpha512Credential = ScramImageTest.randomScramCredentialData((Random)random);
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new UserScramCredentialRecord().setName("alpha").setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setSalt(secondAlpha512Credential.salt()).setStoredKey(secondAlpha512Credential.storedKey()).setServerKey(secondAlpha512Credential.serverKey()).setIterations(secondAlpha512Credential.iterations()), 0));
        DELTA1 = new ScramDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap image2mechanisms = new HashMap();
        HashMap<String, Object> image2sha256 = new HashMap<String, Object>();
        image2sha256.put("alpha", secondAlpha256Credential);
        image2sha256.put("beta", image1sha256.get("beta"));
        image2mechanisms.put(ScramMechanism.SCRAM_SHA_256, image2sha256);
        HashMap<String, ScramCredentialData> image2sha512 = new HashMap<String, ScramCredentialData>();
        image2sha512.put("alpha", secondAlpha512Credential);
        image2mechanisms.put(ScramMechanism.SCRAM_SHA_512, image2sha512);
        IMAGE2 = new ScramImage(image2mechanisms);
    }
}

