/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.metrics.TenantMetricsPublisher;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.immutable.ImmutableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TenantMetricsPublisherTest {
    private TenantMetricsPublisher tenantMetricsPublisher;
    private FaultHandler faultHandler;

    @BeforeEach
    public void setUp() {
        this.faultHandler = (FaultHandler)Mockito.mock(FaultHandler.class);
        this.tenantMetricsPublisher = new TenantMetricsPublisher(this.faultHandler);
    }

    @Test
    public void testTenantMetadataPublisherInitialization() {
        Assertions.assertEquals(Collections.emptyMap(), (Object)this.tenantMetricsPublisher.tenantPartitionCountTracker);
    }

    @Test
    public void testParitionCountScaleupScaleDownForTenants() {
        String tenant1 = "tenant1";
        String tenant2 = "tenant2";
        Uuid topic1Uuid = Uuid.fromString((String)"tgHBnRglT5W_RlENnuG5vg");
        String topic1 = "topic1";
        Uuid topic2Uuid = Uuid.fromString((String)"uNBNqj97TKGB0c5qq2FJAQ");
        String topic2 = "topic2";
        HashMap<String, TopicImage> topicImagesMap = new HashMap<String, TopicImage>();
        topicImagesMap.put(topic1, TenantMetricsPublisherTest.newTopicImage(topic1, topic1Uuid, new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{2, 3}).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).setLeader(Integer.valueOf(3)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{2, 3}).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(345)).setLeader(Integer.valueOf(1)).build()));
        topicImagesMap.put(topic2, TenantMetricsPublisherTest.newTopicImage(topic2, topic2Uuid, new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)5)).setIsr(new int[]{2, 3}).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(445)).setLeader(Integer.valueOf(3)).build()));
        ImmutableMap topicsByName = ImmutableMap.empty();
        topicsByName = topicsByName.updated((Object)topic1, topicImagesMap.get(topic1));
        topicsByName = topicsByName.updated((Object)topic2, topicImagesMap.get(topic2));
        ImmutableMap topicNamesByTenant = ImmutableMap.empty();
        ImmutableSet topicsForTenant1 = ImmutableSet.empty();
        topicsForTenant1 = topicsForTenant1.added((Object)topic1);
        topicsForTenant1 = topicsForTenant1.added((Object)topic2);
        topicNamesByTenant = topicNamesByTenant.updated((Object)(tenant1 + "_"), (Object)topicsForTenant1);
        topicNamesByTenant = topicNamesByTenant.updated((Object)(tenant2 + "_"), (Object)topicsForTenant1);
        TopicsImage t1 = new TopicsImage(ImmutableMap.empty(), topicsByName, topicNamesByTenant, ImmutableMap.empty());
        MetadataImage image1 = TenantMetricsPublisherTest.createMetadataImage(t1);
        this.tenantMetricsPublisher.setLastUpdateTime(Long.valueOf(System.currentTimeMillis() - TenantMetricsPublisher.THRESHOLD_IN_MS - 1000L));
        this.tenantMetricsPublisher.maybeComputeAndPublishTenantPartitionCountMetric(image1);
        TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy tenant1Policy = this.tenantMetricsPublisher.getPartitionCountForTenant(tenant1);
        Assertions.assertEquals((Long)tenant1Policy.getPartitionCountCompacted(), (long)0L);
        Assertions.assertEquals((Long)tenant1Policy.getPartitionCountNonCompacted(), (long)3L);
        TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy tenant2Policy = this.tenantMetricsPublisher.getPartitionCountForTenant(tenant2);
        Assertions.assertEquals((Long)tenant2Policy.getPartitionCountCompacted(), (long)0L);
        Assertions.assertEquals((Long)tenant2Policy.getPartitionCountNonCompacted(), (long)3L);
        topicsByName = ImmutableMap.empty();
        topicsByName = topicsByName.updated((Object)topic1, topicImagesMap.get(topic1));
        topicsForTenant1 = ImmutableSet.empty();
        topicsForTenant1 = topicsForTenant1.added((Object)topic1);
        topicNamesByTenant = ImmutableMap.empty();
        topicNamesByTenant = topicNamesByTenant.updated((Object)(tenant1 + "_"), (Object)topicsForTenant1);
        t1 = new TopicsImage(ImmutableMap.empty(), topicsByName, topicNamesByTenant, ImmutableMap.empty());
        MetadataImage image2 = TenantMetricsPublisherTest.createMetadataImage(t1);
        this.tenantMetricsPublisher.setLastUpdateTime(Long.valueOf(System.currentTimeMillis() - TenantMetricsPublisher.THRESHOLD_IN_MS - 1000L));
        this.tenantMetricsPublisher.maybeComputeAndPublishTenantPartitionCountMetric(image2);
        tenant1Policy = this.tenantMetricsPublisher.getPartitionCountForTenant(tenant1);
        Assertions.assertEquals((long)0L, (Long)tenant1Policy.getPartitionCountCompacted());
        Assertions.assertEquals((long)2L, (Long)tenant1Policy.getPartitionCountNonCompacted());
        Assertions.assertThrows(RuntimeException.class, () -> this.tenantMetricsPublisher.getPartitionCountForTenant(tenant2));
        t1 = new TopicsImage(ImmutableMap.empty(), ImmutableMap.empty(), ImmutableMap.empty(), ImmutableMap.empty());
        MetadataImage image3 = TenantMetricsPublisherTest.createMetadataImage(t1);
        this.tenantMetricsPublisher.setLastUpdateTime(Long.valueOf(System.currentTimeMillis() - TenantMetricsPublisher.THRESHOLD_IN_MS - 1000L));
        this.tenantMetricsPublisher.maybeComputeAndPublishTenantPartitionCountMetric(image3);
        Assertions.assertThrows(RuntimeException.class, () -> this.tenantMetricsPublisher.getPartitionCountForTenant(tenant1));
        Assertions.assertThrows(RuntimeException.class, () -> this.tenantMetricsPublisher.getPartitionCountForTenant(tenant2));
        topicsByName = ImmutableMap.empty();
        topicsByName = topicsByName.updated((Object)topic1, topicImagesMap.get(topic1));
        topicsForTenant1 = ImmutableSet.empty();
        topicsForTenant1 = topicsForTenant1.added((Object)topic1);
        topicNamesByTenant = ImmutableMap.empty();
        topicNamesByTenant = topicNamesByTenant.updated((Object)(tenant1 + "_"), (Object)topicsForTenant1);
        t1 = new TopicsImage(ImmutableMap.empty(), topicsByName, topicNamesByTenant, ImmutableMap.empty());
        MetadataImage image4 = new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, t1, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        this.tenantMetricsPublisher.setLastUpdateTime(Long.valueOf(System.currentTimeMillis() - TenantMetricsPublisher.THRESHOLD_IN_MS - 1000L));
        this.tenantMetricsPublisher.maybeComputeAndPublishTenantPartitionCountMetric(image4);
        tenant1Policy = this.tenantMetricsPublisher.getPartitionCountForTenant(tenant1);
        Assertions.assertEquals((long)0L, (Long)tenant1Policy.getPartitionCountCompacted());
        Assertions.assertEquals((long)2L, (Long)tenant1Policy.getPartitionCountNonCompacted());
        Assertions.assertThrows(RuntimeException.class, () -> this.tenantMetricsPublisher.getPartitionCountForTenant(tenant2));
    }

    @Test
    public void testGetPartitionCountForTenant() {
        String testTenant = "test_tenant";
        TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy metric = new TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy(Long.valueOf(10L), Long.valueOf(5L));
        this.tenantMetricsPublisher.tenantPartitionCountTracker.put(testTenant + "_", metric);
        TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy retrievedMetric = this.tenantMetricsPublisher.getPartitionCountForTenant(testTenant);
        Assertions.assertEquals((Object)metric, (Object)retrievedMetric);
    }

    @Test
    public void testGetPartitionCountForTenantNonExistent() {
        String nonExistentTenant = "non_existent_tenant";
        Assertions.assertThrows(RuntimeException.class, () -> this.tenantMetricsPublisher.getPartitionCountForTenant(nonExistentTenant));
    }

    @Test
    public void testClose() {
        this.tenantMetricsPublisher.close();
        Assertions.assertEquals(new HashMap(), (Object)this.tenantMetricsPublisher.tenantPartitionCountTracker);
    }

    @Test
    public void testRegisteredTenantIteratorRemove() {
        this.tenantMetricsPublisher.setTenantRegisterInterface(this::testPublisherFunctionReturnsTrue);
        this.tenantMetricsPublisher.setIsTenantOwnedInterface(this::testPublisherFunctionReturnsTrue);
        this.tenantMetricsPublisher.setRemoveTenantGaugeInterface(this::testPublisherFunctionReturnsTrue);
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("1");
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("2");
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("3");
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("4");
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("5");
        Assertions.assertEquals((int)5, (int)this.tenantMetricsPublisher.registeredTenants().size());
        this.tenantMetricsPublisher.maybeRemoveTenantGauges();
        Assertions.assertEquals((int)5, (int)this.tenantMetricsPublisher.registeredTenants().size());
        this.tenantMetricsPublisher.setIsTenantOwnedInterface(this::testPublisherFunctionReturnsFalse);
        this.tenantMetricsPublisher.maybeRemoveTenantGauges();
        Assertions.assertEquals((int)0, (int)this.tenantMetricsPublisher.registeredTenants().size());
    }

    private Boolean testPublisherFunctionReturnsTrue(String tenant) {
        return true;
    }

    private Boolean testPublisherFunctionReturnsFalse(String tenant) {
        return false;
    }

    private static TopicImage newTopicImage(String name, Uuid id, PartitionRegistration ... partitions) {
        HashMap<Integer, PartitionRegistration> partitionMap = new HashMap<Integer, PartitionRegistration>();
        int i = 0;
        for (PartitionRegistration partition : partitions) {
            partitionMap.put(i++, partition);
        }
        return new TopicImage(name, id, partitionMap, null);
    }

    private static MetadataImage createMetadataImage(TopicsImage t1) {
        return new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, t1, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
    }
}

