/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.kafka.controller.metrics.ConfluentControllerMetrics;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfluentControllerMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        try {
            try (ConfluentControllerMetrics metrics = new ConfluentControllerMetrics(Optional.of(registry));){
                HashSet<String> expected = new HashSet<String>(Arrays.asList("kafka.controller:type=KafkaController,name=GlobalPartitionCount", "kafka.controller:type=KafkaController,name=GlobalTopicCount", "kafka.controller:type=KafkaController,name=GlobalUnderMinIsrPartitionCount", "kafka.controller:type=KafkaController,name=OfflinePartitionsCount", "kafka.controller:type=KafkaController,name=PartitionAvailability", "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount"));
                ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller", expected);
            }
            ControllerMetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.controller", Collections.emptySet());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIntGaugeMetric(Function<ConfluentControllerMetrics, Integer> metricsGetter, Function<MetricsRegistry, Integer> registryGetter, BiConsumer<ConfluentControllerMetrics, Integer> setter, BiConsumer<ConfluentControllerMetrics, Integer> incrementer) {
        MetricsRegistry registry = new MetricsRegistry();
        try (ConfluentControllerMetrics metrics = new ConfluentControllerMetrics(Optional.of(registry));){
            Assertions.assertEquals((int)0, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)0, (Integer)registryGetter.apply(registry));
            setter.accept(metrics, 123);
            Assertions.assertEquals((int)123, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)123, (Integer)registryGetter.apply(registry));
            incrementer.accept(metrics, 123);
            Assertions.assertEquals((int)246, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)246, (Integer)registryGetter.apply(registry));
            incrementer.accept(metrics, -246);
            Assertions.assertEquals((int)0, (Integer)metricsGetter.apply(metrics));
            Assertions.assertEquals((int)0, (Integer)registryGetter.apply(registry));
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void testGlobalTopicCountMetric() {
        this.testIntGaugeMetric(m -> m.globalTopicCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ConfluentControllerMetricsTest.metricName("KafkaController", "GlobalTopicCount"))).value(), (m, v) -> m.setGlobalTopicCount(v.intValue()), (m, v) -> m.addToGlobalTopicCount(v.intValue()));
    }

    @Test
    public void testGlobalPartitionCountMetric() {
        this.testIntGaugeMetric(m -> m.globalPartitionCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ConfluentControllerMetricsTest.metricName("KafkaController", "GlobalPartitionCount"))).value(), (m, v) -> m.setGlobalPartitionCount(v.intValue()), (m, v) -> m.addToGlobalPartitionCount(v.intValue()));
    }

    @Test
    public void testOfflinePartitionsCountMetric() {
        this.testIntGaugeMetric(m -> m.globalOfflinePartitionCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ConfluentControllerMetricsTest.metricName("KafkaController", "OfflinePartitionsCount"))).value(), (m, v) -> m.setGlobalOfflinePartitionCount(v.intValue()), (m, v) -> m.addToGlobalOfflinePartitionCount(v.intValue()));
    }

    @Test
    public void testUnderMinIsrPartitionCount() {
        this.testIntGaugeMetric(m -> m.globalUnderMinIsrCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ConfluentControllerMetricsTest.metricName("KafkaController", "GlobalUnderMinIsrPartitionCount"))).value(), (m, v) -> m.setGlobalUnderMinIsrCount(v.intValue()), (m, v) -> m.addToGlobalUnderMinIsrCount(v.intValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionAvailabilityWithNoPartitions() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ConfluentControllerMetrics metrics = new ConfluentControllerMetrics(Optional.of(registry));){
            Assertions.assertEquals((double)1.0, (double)metrics.globalPartitionAvailability());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionAvailability() {
        MetricsRegistry registry = new MetricsRegistry();
        try (ConfluentControllerMetrics metrics = new ConfluentControllerMetrics(Optional.of(registry));){
            metrics.setGlobalTopicCount(1);
            metrics.setGlobalPartitionCount(4);
            metrics.setGlobalOfflinePartitionCount(1);
            metrics.setGlobalUnderMinIsrCount(1);
            Assertions.assertEquals((double)0.5, (double)metrics.globalPartitionAvailability());
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void testPreferredReplicaImbalanceCount() {
        this.testIntGaugeMetric(m -> m.preferredReplicaImbalanceCount(), registry -> (Integer)((Gauge)registry.allMetrics().get(ConfluentControllerMetricsTest.metricName("KafkaController", "PreferredReplicaImbalanceCount"))).value(), (m, v) -> m.setPreferredReplicaImbalanceCount(v.intValue()), (m, v) -> m.addToPreferredReplicaImbalanceCount(v.intValue()));
    }

    private static MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.controller:type=%s,name=%s", type, name);
        return new MetricName("kafka.controller", type, name, null, mBeanName);
    }
}

