/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Collections;
import java.util.OptionalInt;
import org.apache.kafka.controller.metrics.ConfluentControllerMetricsCache;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ConfluentControllerMetricsCacheTest {
    @Test
    public void testNodeIdString() {
        ConfluentControllerMetricsCache cache = new ConfluentControllerMetricsCache((FaultHandler)new MockFaultHandler("ConfluentControllerMetricsCacheTest "), __ -> null, 5, 3);
        Assertions.assertEquals((Object)"5", (Object)cache.nodeIdString());
    }

    @Test
    public void testMinIsrWithNoOverrides() {
        ConfluentControllerMetricsCache cache = new ConfluentControllerMetricsCache((FaultHandler)new MockFaultHandler("ConfluentControllerMetricsCacheTest "), __ -> null, 5, 2);
        Assertions.assertEquals((int)2, (int)cache.minIsrForTopic("foo"));
    }

    @Test
    public void testMinIsrWithClusterLevelOverride() {
        ConfluentControllerMetricsCache cache = new ConfluentControllerMetricsCache((FaultHandler)new MockFaultHandler("ConfluentControllerMetricsCacheTest "), __ -> null, 5, 3);
        cache.setClusterLevelMinIsrConfig(OptionalInt.of(1));
        Assertions.assertEquals((int)1, (int)cache.minIsrForTopic("foo"));
    }

    @Test
    public void testMinIsrWithNodeLevelOverride() {
        ConfluentControllerMetricsCache cache = new ConfluentControllerMetricsCache((FaultHandler)new MockFaultHandler("ConfluentControllerMetricsCacheTest "), __ -> null, 5, 3);
        cache.setNodeLevelMinIsrConfig(OptionalInt.of(3));
        Assertions.assertEquals((int)3, (int)cache.minIsrForTopic("foo"));
    }

    @Test
    public void testMinIsrWithClusterLevelAndNodeLevelOverride() {
        ConfluentControllerMetricsCache cache = new ConfluentControllerMetricsCache((FaultHandler)new MockFaultHandler("ConfluentControllerMetricsCacheTest "), __ -> null, 5, 3);
        cache.setNodeLevelMinIsrConfig(OptionalInt.of(1));
        cache.setClusterLevelMinIsrConfig(OptionalInt.of(3));
        Assertions.assertEquals((int)1, (int)cache.minIsrForTopic("foo"));
    }

    @ParameterizedTest
    @ValueSource(strings={"none", "node", "cluster", "node and cluster"})
    public void testPerTopicOverride(String sources) {
        ConfluentControllerMetricsCache cache = new ConfluentControllerMetricsCache((FaultHandler)new MockFaultHandler("ConfluentControllerMetricsCacheTest "), __ -> null, 5, 2);
        if (sources.contains("node")) {
            cache.setNodeLevelMinIsrConfig(OptionalInt.of(3));
        }
        if (sources.contains("cluster")) {
            cache.setClusterLevelMinIsrConfig(OptionalInt.of(2));
        }
        cache.setPerTopicMinIsrConfig("foo", OptionalInt.of(6));
        Assertions.assertEquals((int)6, (int)cache.minIsrForTopic("foo"));
    }

    @ParameterizedTest
    @ValueSource(strings={"none", "node", "cluster", "topic", "node and cluster", "cluster and topic", "node, cluster, and topic"})
    public void testPerTopicOverrideWithChanges(String sources) {
        ConfluentControllerMetricsCache cache = new ConfluentControllerMetricsCache((FaultHandler)new MockFaultHandler("ConfluentControllerMetricsCacheTest "), __ -> null, 5, 2);
        if (sources.contains("node")) {
            cache.setNodeLevelMinIsrConfig(OptionalInt.of(3));
        }
        if (sources.contains("cluster")) {
            cache.setClusterLevelMinIsrConfig(OptionalInt.of(2));
        }
        if (sources.contains("topic")) {
            cache.setClusterLevelMinIsrConfig(OptionalInt.of(6));
        }
        cache.setPerTopicMinIsrConfig("foo", OptionalInt.of(6));
        Assertions.assertEquals((int)7, (int)cache.minIsrForTopic("foo", Collections.singletonMap("foo", OptionalInt.of(7))));
    }

    @Test
    public void testPerTopicOverrideWithChangesRemovingPerTopic() {
        ConfluentControllerMetricsCache cache = new ConfluentControllerMetricsCache((FaultHandler)new MockFaultHandler("ConfluentControllerMetricsCacheTest "), __ -> null, 5, 2);
        cache.setPerTopicMinIsrConfig("foo", OptionalInt.of(6));
        Assertions.assertEquals((int)2, (int)cache.minIsrForTopic("foo", Collections.singletonMap("foo", OptionalInt.empty())));
    }
}

