/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.common.CellLoad;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.CellLoadMetrics;
import org.apache.kafka.metadata.placement.CellAssignor;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class CellLoadMetricsTest {
    CellLoadMetricsTest() {
    }

    public static void assertMetricsForTypeEqual(MetricsRegistry registry, String expectedPrefix, Set<String> expected) {
        TreeSet actual = new TreeSet();
        registry.allMetrics().forEach((name, __) -> {
            StringBuilder bld = new StringBuilder();
            bld.append(name.getGroup());
            bld.append(":type=").append(name.getType());
            bld.append(",name=").append(name.getName());
            if (name.hasScope()) {
                bld.append(",scope=").append(name.getScope());
            }
            if (bld.toString().startsWith(expectedPrefix)) {
                actual.add(bld.toString());
            }
        });
        Assertions.assertEquals(new TreeSet<String>(expected), actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoMetricsCreatedByDefault() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try (CellLoadMetrics metrics = new CellLoadMetrics(Optional.of(registry), (Time)time);){
            CellLoadMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", new HashSet<String>());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCellLoadFreshMetricCreatedOnSet() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        try {
            try (CellLoadMetrics metrics = new CellLoadMetrics(Optional.of(registry), (Time)time);){
                metrics.setLastCellLoadUpdateTimeMs(1000L);
                metrics.installCellLoadFreshMetricIfNeeded();
                HashSet<String> expected = new HashSet<String>(Arrays.asList("kafka.controller:type=KafkaController,name=CellLoadFresh"));
                CellLoadMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", expected);
            }
            CellLoadMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", new HashSet<String>());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetLastCellLoadUpdateTimeMs() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime(0L, 0L);
        try (CellLoadMetrics metrics = new CellLoadMetrics(Optional.of(registry), (Time)time);){
            Assertions.assertEquals((long)0L, (long)metrics.lastCellLoadUpdateTimeMs());
            Assertions.assertTrue((boolean)metrics.cellLoadIsFresh());
            time.sleep(CellAssignor.CELL_LOAD_FRESH_DURATION_MS + 1L);
            Assertions.assertFalse((boolean)metrics.cellLoadIsFresh());
            metrics.setLastCellLoadUpdateTimeMs(time.milliseconds());
            Assertions.assertEquals((long)time.milliseconds(), (long)metrics.lastCellLoadUpdateTimeMs());
            Assertions.assertTrue((boolean)metrics.cellLoadIsFresh());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCellLoadsWithEmptyMap() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime(0L, 0L);
        try (CellLoadMetrics metrics = new CellLoadMetrics(Optional.of(registry), (Time)time);){
            metrics.updateCellLoads(Collections.emptySet(), 4567L);
            Assertions.assertEquals((long)0L, (long)metrics.lastCellLoadUpdateTimeMs());
            CellLoadMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", new HashSet<String>());
            Assertions.assertEquals(Collections.emptyMap(), (Object)metrics.cellIdToLoad());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCellLoads() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime(0L, 0L);
        try {
            try (CellLoadMetrics metrics = new CellLoadMetrics(Optional.of(registry), (Time)time);){
                metrics.updateCellLoads(new HashSet<CellLoad>(Arrays.asList(new CellLoad(1, 0.5), new CellLoad(2, 1.0), new CellLoad(3, 2.0))), 1234567L);
                Assertions.assertEquals((long)1234567L, (long)metrics.lastCellLoadUpdateTimeMs());
                CellLoadMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", new HashSet<String>(Arrays.asList("kafka.controller:type=KafkaController,name=CellLoadFresh", "kafka.controller:type=KafkaController,name=Load,scope=cellId.1", "kafka.controller:type=KafkaController,name=Load,scope=cellId.2", "kafka.controller:type=KafkaController,name=Load,scope=cellId.3")));
                metrics.updateCellLoads(new HashSet<CellLoad>(Arrays.asList(new CellLoad(1, 1.0), new CellLoad(3, 2.0))), 1234567L);
                Assertions.assertEquals((long)1234567L, (long)metrics.lastCellLoadUpdateTimeMs());
                CellLoadMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", new HashSet<String>(Arrays.asList("kafka.controller:type=KafkaController,name=CellLoadFresh", "kafka.controller:type=KafkaController,name=Load,scope=cellId.1", "kafka.controller:type=KafkaController,name=Load,scope=cellId.3")));
                Assertions.assertEquals((double)2.0, (Double)((Double)((Gauge)registry.allMetrics().get(CellLoadMetrics.cellLoadMetricName((int)3))).value()));
            }
            CellLoadMetricsTest.assertMetricsForTypeEqual(registry, "kafka.controller", new HashSet<String>());
        }
        finally {
            registry.shutdown();
        }
    }
}

