/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.errors;

import java.util.OptionalInt;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.controller.errors.ControllerExceptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ControllerExceptionsTest {
    @Test
    public void testTimeoutExceptionIsTimeoutException() {
        Assertions.assertTrue((boolean)ControllerExceptions.isTimeoutException((Throwable)new TimeoutException()));
    }

    @Test
    public void testWrappedTimeoutExceptionIsTimeoutException() {
        Assertions.assertTrue((boolean)ControllerExceptions.isTimeoutException((Throwable)new ExecutionException("execution exception", (Throwable)new TimeoutException())));
    }

    @Test
    public void testRuntimeExceptionIsNotTimeoutException() {
        Assertions.assertFalse((boolean)ControllerExceptions.isTimeoutException((Throwable)new RuntimeException()));
    }

    @Test
    public void testWrappedRuntimeExceptionIsNotTimeoutException() {
        Assertions.assertFalse((boolean)ControllerExceptions.isTimeoutException((Throwable)new ExecutionException(new RuntimeException())));
    }

    @Test
    public void testTopicExistsExceptionIsNotTimeoutException() {
        Assertions.assertFalse((boolean)ControllerExceptions.isTimeoutException((Throwable)new TopicExistsException("Topic exists.")));
    }

    @Test
    public void testExecutionExceptionWithNullCauseIsNotTimeoutException() {
        Assertions.assertFalse((boolean)ControllerExceptions.isTimeoutException((Throwable)new ExecutionException(null)));
    }

    @Test
    public void testNewPreMigrationExceptionWithNoController() {
        ControllerExceptionsTest.assertExceptionsMatch((Throwable)new NotControllerException("No controller appears to be active."), (Throwable)ControllerExceptions.newPreMigrationException((OptionalInt)OptionalInt.empty()));
    }

    @Test
    public void testNewPreMigrationExceptionWithActiveController() {
        ControllerExceptionsTest.assertExceptionsMatch((Throwable)new NotControllerException("The controller is in pre-migration mode."), (Throwable)ControllerExceptions.newPreMigrationException((OptionalInt)OptionalInt.of(1)));
    }

    @Test
    public void testNewWrongControllerExceptionWithNoController() {
        ControllerExceptionsTest.assertExceptionsMatch((Throwable)new NotControllerException("No controller appears to be active."), (Throwable)ControllerExceptions.newWrongControllerException((OptionalInt)OptionalInt.empty()));
    }

    @Test
    public void testNewWrongControllerExceptionWithActiveController() {
        ControllerExceptionsTest.assertExceptionsMatch((Throwable)new NotControllerException("The active controller appears to be node 1."), (Throwable)ControllerExceptions.newWrongControllerException((OptionalInt)OptionalInt.of(1)));
    }

    static void assertExceptionsMatch(Throwable a, Throwable b) {
        Assertions.assertEquals(a.getClass(), b.getClass());
        Assertions.assertEquals((Object)a.getMessage(), (Object)b.getMessage());
        if (a.getCause() != null) {
            Assertions.assertNotNull((Object)b.getCause());
            ControllerExceptionsTest.assertExceptionsMatch(a.getCause(), b.getCause());
        } else {
            Assertions.assertNull((Object)b.getCause());
        }
    }
}

