/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.controller.PartitionReassignmentRevert;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionReassignmentRevertTest {
    @Test
    public void testNoneAddedOrRemoved() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{3, 2, 1}).setIsr(new int[]{3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"Qln01zZAQMKzFTRCw22Y4w"), Uuid.fromString((String)"jjUcnIL2TxWEGMZ1mHvkPA"), Uuid.fromString((String)"JSZNFA0uQFmH1N75hQxWug")}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3, 2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testSomeRemoving() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{3, 2, 1}).setIsr(new int[]{3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"WG58zlb5RR6TqdI81SCXeA"), Uuid.fromString((String)"izoB1H6TQdOExQ4XNMNXeQ"), Uuid.fromString((String)"TluNaJDjRemuy17sO7dDKg")}).setRemovingReplicas(new int[]{2, 1}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3, 2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testSomeAdding() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{4, 5, 3, 2, 1}).setIsr(new int[]{4, 5, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"gR9P3R9NQ5GhtewattwuZw"), Uuid.fromString((String)"vzgieGUjSr6vPvl3ZAWQcg"), Uuid.fromString((String)"8UWF5CQfQDqSyzcChmbrgw"), Uuid.fromString((String)"X3J9b4K5TumAM5a3YOKk2w"), Uuid.fromString((String)"LjZGhHfFRSCSCQw42dLlNA")}).setAddingReplicas(new int[]{4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testSomeRemovingAndAdding() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{4, 5, 3, 2, 1}).setIsr(new int[]{4, 5, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"IHR5DKGdQju05pbDpwfdbA"), Uuid.fromString((String)"9zsVmGReTDOAyuPEtp58Cw"), Uuid.fromString((String)"bsUouEfRSLi50Pj3nqke2A"), Uuid.fromString((String)"8l9R5BMcQZGbICOXPmxZNw"), Uuid.fromString((String)"3n5Gwv8jRMiIFMgoTxVCdA")}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testIsrSpecialCase() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{4, 5, 3, 2, 1}).setIsr(new int[]{4, 5}).setDirectories(new Uuid[]{Uuid.fromString((String)"1oXnuHL6T8y7yMtEP4FSdg"), Uuid.fromString((String)"3ddu6izxT2aCpQrA3C2bjw"), Uuid.fromString((String)"WvCpqmaZTaSbifd43Vl2Xg"), Uuid.fromString((String)"n0cmj6NgTaahRMwa75FnRA"), Uuid.fromString((String)"S2mDcyiAQAe92ZrlyodaDw")}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3), (Object)revert.isr());
        Assertions.assertTrue((boolean)revert.unclean());
    }

    @Test
    public void testAddSyncReplicaAndObserver() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2, 6, 7, 8), Arrays.asList(6, 7, 8), __ -> DirectoryId.MIGRATING), new PartitionAssignment(Arrays.asList(0, 1, 2, 3, 6, 7, 8, 9), Arrays.asList(6, 7, 8, 9), __ -> DirectoryId.MIGRATING));
        PartitionRegistration registration = PartitionReassignmentRevertTest.partitionRegistration(replicas);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 6, 7, 8), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(6, 7, 8), (Object)revert.observers());
    }

    @Test
    public void testRemoveSyncReplicaAndObserver() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2, 3, 6, 7, 8, 9), Arrays.asList(6, 7, 8, 9), __ -> DirectoryId.MIGRATING), new PartitionAssignment(Arrays.asList(0, 1, 2, 6, 7, 8), Arrays.asList(6, 7, 8), __ -> DirectoryId.MIGRATING));
        PartitionRegistration registration = PartitionReassignmentRevertTest.partitionRegistration(replicas);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3, 6, 7, 8, 9), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(6, 7, 8, 9), (Object)revert.observers());
    }

    @Test
    public void testAddAndRemoveSyncReplicaAndObserver() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2, 6, 7, 8), Arrays.asList(6, 7, 8), __ -> DirectoryId.MIGRATING), new PartitionAssignment(Arrays.asList(0, 1, 3, 6, 7, 9), Arrays.asList(6, 7, 9), __ -> DirectoryId.MIGRATING));
        PartitionRegistration registration = PartitionReassignmentRevertTest.partitionRegistration(replicas);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 6, 7, 8), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(6, 7, 8), (Object)revert.observers());
    }

    @Test
    public void testSwapOneSyncReplicaAndObserver() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2, 6, 7, 8), Arrays.asList(6, 7, 8), __ -> DirectoryId.MIGRATING), new PartitionAssignment(Arrays.asList(0, 7, 2, 6, 1, 8), Arrays.asList(6, 1, 8), __ -> DirectoryId.MIGRATING));
        PartitionRegistration registration = PartitionReassignmentRevertTest.partitionRegistration(replicas);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(0, 2, 1, 6, 8, 7), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(6, 8, 7), (Object)revert.observers());
    }

    @Test
    public void testFullSwapSyncReplicasAndObservers() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2, 3, 4, 5), Arrays.asList(3, 4, 5), __ -> DirectoryId.MIGRATING), new PartitionAssignment(Arrays.asList(3, 4, 5, 0, 1, 2), Arrays.asList(0, 1, 2), __ -> DirectoryId.MIGRATING));
        PartitionRegistration registration = PartitionReassignmentRevertTest.partitionRegistration(replicas);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3, 4, 5), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)revert.observers());
    }

    @Test
    public void testPartialSwapSyncReplicasAndObservers() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2, 6, 7, 8), Arrays.asList(6, 7, 8), __ -> DirectoryId.MIGRATING), new PartitionAssignment(Arrays.asList(0, 7, 3, 6, 1, 9), Arrays.asList(6, 1, 9), __ -> DirectoryId.MIGRATING));
        PartitionRegistration registration = PartitionReassignmentRevertTest.partitionRegistration(replicas);
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 6, 7, 8), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(6, 7, 8), (Object)revert.observers());
    }

    private static PartitionRegistration partitionRegistration(PartitionReassignmentReplicas partitionReassignmentReplicas) {
        return new PartitionRegistration.Builder().setReplicas(Replicas.toArray((List)partitionReassignmentReplicas.replicas())).setDirectories(DirectoryId.migratingArray((int)partitionReassignmentReplicas.replicas().size())).setObservers(Replicas.toArray((List)partitionReassignmentReplicas.observers())).setIsr(Replicas.toArray((List)partitionReassignmentReplicas.targetSyncReplicas())).setRemovingReplicas(Replicas.toArray((List)partitionReassignmentReplicas.removing())).setAddingReplicas(Replicas.toArray((List)partitionReassignmentReplicas.adding())).setRemovingObservers(Replicas.toArray((List)partitionReassignmentReplicas.removingObservers())).setAddingObservers(Replicas.toArray((List)partitionReassignmentReplicas.addingObservers())).setLeader((Integer)partitionReassignmentReplicas.targetSyncReplicas().get(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(100)).build();
    }
}

