/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.PartitionAssignmentTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionReassignmentReplicasTest {
    @Test
    public void testNoneAddedOrRemoved() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 2, 1)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 2, 1)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)replicas.replicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals((Object)replicas.adding(), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals((Object)replicas.removing(), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)replicas.originalReplicas());
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)replicas.targetReplicas());
        Assertions.assertEquals((Object)replicas.targetReplicas(), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals((Object)replicas.originalReplicas(), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.originalObservers());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.targetObservers());
    }

    @Test
    public void testAdditions() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 2, 1)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 6, 2, 1, 5)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(5, 6), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 6, 2, 1, 5), (Object)replicas.replicas());
        Assertions.assertEquals(Arrays.asList(6, 5), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(new HashSet(replicas.adding()), new HashSet(replicas.addingSyncReplicas()));
        Assertions.assertEquals((Object)replicas.removing(), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)replicas.originalReplicas());
        Assertions.assertEquals(Arrays.asList(3, 6, 2, 1, 5), (Object)replicas.targetReplicas());
        Assertions.assertEquals((Object)replicas.targetReplicas(), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals((Object)replicas.originalReplicas(), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.originalObservers());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.targetObservers());
    }

    @Test
    public void testRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 2, 1, 0)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 1)));
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 1, 0, 2), (Object)replicas.replicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals((Object)replicas.adding(), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals((Object)replicas.removing(), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(3, 1, 0, 2), (Object)replicas.originalReplicas());
        Assertions.assertEquals(Arrays.asList(3, 1), (Object)replicas.targetReplicas());
        Assertions.assertEquals((Object)replicas.targetReplicas(), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals((Object)replicas.originalReplicas(), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.originalObservers());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.targetObservers());
    }

    @Test
    public void testAdditionsAndRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 2, 1, 0)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(7, 3, 1, 9)));
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(7, 9), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(7, 3, 1, 9, 0, 2), (Object)replicas.replicas());
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(7, 9), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals((Object)replicas.adding(), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals((Object)replicas.removing(), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(3, 1, 0, 2), (Object)replicas.originalReplicas());
        Assertions.assertEquals(Arrays.asList(7, 3, 1, 9), (Object)replicas.targetReplicas());
        Assertions.assertEquals((Object)replicas.targetReplicas(), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals((Object)replicas.originalReplicas(), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.originalObservers());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.targetObservers());
    }

    @Test
    public void testRearrangement() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 2, 1, 0)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 3, 2)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(0, 1, 3, 2), (Object)replicas.replicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals((Object)replicas.adding(), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals((Object)replicas.removing(), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(0, 1, 3, 2), (Object)replicas.originalReplicas());
        Assertions.assertEquals(Arrays.asList(0, 1, 3, 2), (Object)replicas.targetReplicas());
        Assertions.assertEquals((Object)replicas.targetReplicas(), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals((Object)replicas.originalReplicas(), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.originalObservers());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.targetObservers());
    }

    @Test
    public void testDoesNotCompleteReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 2)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 4, 5)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2, 3, 4));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testDoesNotCompleteReassignmentIfNoneOngoing() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Collections.emptyList(), Collections.emptyList(), Arrays.asList(0, 1, 2));
        Assertions.assertFalse((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testDoesCompleteReassignmentAllNewReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 2)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(3, 4, 5)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2, 3, 4, 5));
        Assertions.assertTrue((boolean)reassignmentOptional.isPresent());
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = (PartitionReassignmentReplicas.CompletedReassignment)reassignmentOptional.get();
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)completedReassignment.isr);
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)completedReassignment.replicas);
    }

    @Test
    public void testDoesCompleteReassignmentSomeNewReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 2)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 3)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2, 3));
        Assertions.assertTrue((boolean)reassignmentOptional.isPresent());
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = (PartitionReassignmentReplicas.CompletedReassignment)reassignmentOptional.get();
        Assertions.assertEquals(Arrays.asList(0, 1, 3), (Object)completedReassignment.isr);
        Assertions.assertEquals(Arrays.asList(0, 1, 3), (Object)completedReassignment.replicas);
    }

    @Test
    public void testIsReassignmentInProgress() {
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"HEKOeWDdQOqr2cmHrnjqjA"), Uuid.fromString((String)"I8kmmcM5TjOwNFnGvJLCjA"), Uuid.fromString((String)"x8osEoRkQdupZNYpU5c3Lw"), Uuid.fromString((String)"OT6qgtRqTiuiX8EikvAVow")}).setIsr(new int[]{0, 1, 3, 2}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{3}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"QrbOddSYQg6JgFu7hLvOTg"), Uuid.fromString((String)"S585FNNoSmiSH6ZYCrNqCg"), Uuid.fromString((String)"wjT5ieLARfKYMWIzTFwcag"), Uuid.fromString((String)"qzX9qWPVTWuLbiEQL0cgeg")}).setIsr(new int[]{0, 1, 3, 2}).setRemovingReplicas(new int[]{2}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"QIyJnfdUSz6laFLCgj3AjA"), Uuid.fromString((String)"1QIvvBx2QVqNw2dsnYXUZg"), Uuid.fromString((String)"yPvPnGrxR0q8KC2Q5k0FIg"), Uuid.fromString((String)"a0lnxzleTcWVf1IyalE9cA")}).setIsr(new int[]{0, 1, 3, 2}).setAddingReplicas(new int[]{3}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
        Assertions.assertFalse((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"I4qCCBe9TYGOB0xvmvTI7w"), Uuid.fromString((String)"JvzGem0nTxiNPM5jIzNzlA"), Uuid.fromString((String)"EfWjZ2EsSKSvEn9PkG7lWQ")}).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
    }

    @Test
    public void testDoesNotCompleteReassignmentIfIsrDoesNotHaveAllTargetReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 2)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 3)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(3));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testOriginalReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 2)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 3)));
        Assertions.assertEquals(Arrays.asList(0, 1, 2), (Object)replicas.originalReplicas());
    }

    @Test
    public void testAddSyncReplicaAndObserver() {
        List<Integer> originalReplicas = Arrays.asList(0, 1, 2, 6, 7, 8);
        List<Integer> originalObservers = Arrays.asList(6, 7, 8);
        List<Integer> targetReplicas = Arrays.asList(0, 1, 2, 3, 6, 7, 8, 9);
        List<Integer> targetObservers = Arrays.asList(6, 7, 8, 9);
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(originalReplicas, originalObservers, __ -> DirectoryId.MIGRATING), new PartitionAssignment(targetReplicas, targetObservers, __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3, 6, 7, 8, 9), (Object)replicas.replicas());
        Assertions.assertEquals(Arrays.asList(6, 7, 8, 9), (Object)replicas.observers());
        Assertions.assertEquals(originalReplicas, (Object)replicas.originalReplicas());
        Assertions.assertEquals(originalReplicas.subList(0, originalReplicas.size() - originalObservers.size()), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(originalObservers, (Object)replicas.originalObservers());
        Assertions.assertEquals(targetReplicas, (Object)replicas.targetReplicas());
        Assertions.assertEquals(targetReplicas.subList(0, targetReplicas.size() - targetObservers.size()), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals(targetObservers, (Object)replicas.targetObservers());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(3, 9), (Object)replicas.adding());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(3), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removingObservers());
        Assertions.assertEquals(Arrays.asList(9), (Object)replicas.addingObservers());
    }

    @Test
    public void testRemoveSyncReplicaAndObserver() {
        List<Integer> originalReplicas = Arrays.asList(0, 1, 2, 3, 6, 7, 8, 9);
        List<Integer> originalObservers = Arrays.asList(6, 7, 8, 9);
        List<Integer> targetReplicas = Arrays.asList(0, 1, 2, 6, 7, 8);
        List<Integer> targetObservers = Arrays.asList(6, 7, 8);
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(originalReplicas, originalObservers, __ -> DirectoryId.MIGRATING), new PartitionAssignment(targetReplicas, targetObservers, __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3, 6, 7, 8, 9), (Object)replicas.replicas());
        Assertions.assertEquals(Arrays.asList(6, 7, 8, 9), (Object)replicas.observers());
        Assertions.assertEquals(originalReplicas, (Object)replicas.originalReplicas());
        Assertions.assertEquals(originalReplicas.subList(0, originalReplicas.size() - originalObservers.size()), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(originalObservers, (Object)replicas.originalObservers());
        Assertions.assertEquals(targetReplicas, (Object)replicas.targetReplicas());
        Assertions.assertEquals(targetReplicas.subList(0, targetReplicas.size() - targetObservers.size()), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals(targetObservers, (Object)replicas.targetObservers());
        Assertions.assertEquals(Arrays.asList(3, 9), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(9), (Object)replicas.removingObservers());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.addingObservers());
        Assertions.assertEquals(originalReplicas, (Object)replicas.originalReplicas());
        Assertions.assertEquals(originalReplicas.subList(0, originalReplicas.size() - originalObservers.size()), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(originalObservers, (Object)replicas.originalObservers());
        Assertions.assertEquals(targetReplicas, (Object)replicas.targetReplicas());
        Assertions.assertEquals(targetReplicas.subList(0, targetReplicas.size() - targetObservers.size()), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals(targetObservers, (Object)replicas.targetObservers());
    }

    @Test
    public void testAddAndRemoveSyncReplicaAndObserver() {
        List<Integer> originalReplicas = Arrays.asList(0, 1, 2, 6, 7, 8);
        List<Integer> originalObservers = Arrays.asList(6, 7, 8);
        List<Integer> targetReplicas = Arrays.asList(0, 1, 3, 6, 7, 9);
        List<Integer> targetObservers = Arrays.asList(6, 7, 9);
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(originalReplicas, originalObservers, __ -> DirectoryId.MIGRATING), new PartitionAssignment(targetReplicas, targetObservers, __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals(Arrays.asList(0, 1, 3, 2, 6, 7, 9, 8), (Object)replicas.replicas());
        Assertions.assertEquals(Arrays.asList(6, 7, 9, 8), (Object)replicas.observers());
        Assertions.assertEquals(originalReplicas, (Object)replicas.originalReplicas());
        Assertions.assertEquals(originalReplicas.subList(0, originalReplicas.size() - originalObservers.size()), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(originalObservers, (Object)replicas.originalObservers());
        Assertions.assertEquals(targetReplicas, (Object)replicas.targetReplicas());
        Assertions.assertEquals(targetReplicas.subList(0, targetReplicas.size() - targetObservers.size()), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals(targetObservers, (Object)replicas.targetObservers());
        Assertions.assertEquals(Arrays.asList(2, 8), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(3, 9), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(2), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(3), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(8), (Object)replicas.removingObservers());
        Assertions.assertEquals(Arrays.asList(9), (Object)replicas.addingObservers());
    }

    @Test
    public void testSwapOneSyncReplicaAndObserver() {
        List<Integer> originalReplicas = Arrays.asList(0, 1, 2, 6, 7, 8);
        List<Integer> originalObservers = Arrays.asList(6, 7, 8);
        List<Integer> targetReplicas = Arrays.asList(0, 7, 2, 6, 1, 8);
        List<Integer> targetObservers = Arrays.asList(6, 1, 8);
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(originalReplicas, originalObservers, __ -> DirectoryId.MIGRATING), new PartitionAssignment(targetReplicas, targetObservers, __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals(Arrays.asList(0, 7, 2, 1, 6, 8), (Object)replicas.replicas());
        Assertions.assertEquals(Arrays.asList(6, 1, 8, 7), (Object)replicas.observers());
        Assertions.assertEquals(Arrays.asList(0, 2, 1, 6, 8, 7), (Object)replicas.originalReplicas());
        Assertions.assertEquals(Arrays.asList(0, 2, 1), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(Arrays.asList(6, 8, 7), (Object)replicas.originalObservers());
        Assertions.assertEquals(targetReplicas, (Object)replicas.targetReplicas());
        Assertions.assertEquals(targetReplicas.subList(0, targetReplicas.size() - targetObservers.size()), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals(targetObservers, (Object)replicas.targetObservers());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(1), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(7), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(7), (Object)replicas.removingObservers());
        Assertions.assertEquals(Arrays.asList(1), (Object)replicas.addingObservers());
    }

    @Test
    public void testFullSwapSyncReplicasAndObservers() {
        List<Integer> originalReplicas = Arrays.asList(0, 1, 2, 3, 4, 5);
        List<Integer> originalObservers = Arrays.asList(3, 4, 5);
        List<Integer> targetReplicas = Arrays.asList(3, 4, 5, 0, 1, 2);
        List<Integer> targetObservers = Arrays.asList(0, 1, 2);
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(originalReplicas, originalObservers, __ -> DirectoryId.MIGRATING), new PartitionAssignment(targetReplicas, targetObservers, __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals(Arrays.asList(3, 4, 5, 0, 1, 2), (Object)replicas.replicas());
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3, 4, 5), (Object)replicas.observers());
        Assertions.assertEquals(originalReplicas, (Object)replicas.originalReplicas());
        Assertions.assertEquals(originalReplicas.subList(0, originalReplicas.size() - originalObservers.size()), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(originalObservers, (Object)replicas.originalObservers());
        Assertions.assertEquals(targetReplicas, (Object)replicas.targetReplicas());
        Assertions.assertEquals(targetReplicas.subList(0, targetReplicas.size() - targetObservers.size()), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals(targetObservers, (Object)replicas.targetObservers());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(0, 1, 2), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)replicas.removingObservers());
        Assertions.assertEquals(Arrays.asList(0, 1, 2), (Object)replicas.addingObservers());
    }

    @Test
    public void testPartialSwapSyncReplicasAndObservers() {
        List<Integer> originalReplicas = Arrays.asList(0, 1, 2, 6, 7, 8);
        List<Integer> originalObservers = Arrays.asList(6, 7, 8);
        List<Integer> targetReplicas = Arrays.asList(0, 7, 3, 6, 1, 9);
        List<Integer> targetObservers = Arrays.asList(6, 1, 9);
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(originalReplicas, originalObservers, __ -> DirectoryId.MIGRATING), new PartitionAssignment(targetReplicas, targetObservers, __ -> DirectoryId.MIGRATING));
        Assertions.assertEquals(Arrays.asList(0, 7, 3, 1, 2, 6, 9, 8), (Object)replicas.replicas());
        Assertions.assertEquals(Arrays.asList(6, 1, 9, 7, 8), (Object)replicas.observers());
        Assertions.assertEquals(originalReplicas, (Object)replicas.originalReplicas());
        Assertions.assertEquals(originalReplicas.subList(0, originalReplicas.size() - originalObservers.size()), (Object)replicas.originalSyncReplicas());
        Assertions.assertEquals(originalObservers, (Object)replicas.originalObservers());
        Assertions.assertEquals(targetReplicas, (Object)replicas.targetReplicas());
        Assertions.assertEquals(targetReplicas.subList(0, targetReplicas.size() - targetObservers.size()), (Object)replicas.targetSyncReplicas());
        Assertions.assertEquals(targetObservers, (Object)replicas.targetObservers());
        Assertions.assertEquals(Arrays.asList(2, 8), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(3, 9), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(1, 2), (Object)replicas.removingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(7, 3), (Object)replicas.addingSyncReplicas());
        Assertions.assertEquals(Arrays.asList(7, 8), (Object)replicas.removingObservers());
        Assertions.assertEquals(Arrays.asList(1, 9), (Object)replicas.addingObservers());
    }

    @Test
    public void testStaticIsReassigning() {
        Assertions.assertFalse((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration(new PartitionRecord().setReplicas(Arrays.asList(0)))));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration(new PartitionRecord().setAddingReplicas(Arrays.asList(0)))));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration(new PartitionRecord().setRemovingReplicas(Arrays.asList(0)))));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration(new PartitionRecord().setAddingObservers(Arrays.asList(0)))));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration(new PartitionRecord().setRemovingObservers(Arrays.asList(0)))));
    }

    @Test
    public void testStaticTargetReplicas() {
        List<Integer> replicas = Arrays.asList(4, 2, 1, 3, 5);
        List<Integer> observers = Arrays.asList(4, 5);
        List<Integer> adding = Arrays.asList(1, 4);
        List<Integer> removing = Arrays.asList(2, 5);
        List<Integer> addingObservers = Arrays.asList(4);
        List<Integer> removingObservers = Arrays.asList(5);
        PartitionRegistration part = new PartitionRegistration(new PartitionRecord().setReplicas(replicas).setAddingReplicas(adding).setRemovingReplicas(removing).setObservers(observers).setAddingObservers(addingObservers).setRemovingObservers(removingObservers));
        List targetObservers = PartitionReassignmentReplicas.targetObservers(observers, removingObservers);
        Assertions.assertEquals(Arrays.asList(4), (Object)targetObservers);
        Assertions.assertEquals(Arrays.asList(1, 3, 4), (Object)PartitionReassignmentReplicas.targetReplicas(replicas, removing, (List)targetObservers));
        Assertions.assertEquals(Arrays.asList(1, 3, 4), (Object)PartitionReassignmentReplicas.targetReplicas((PartitionRegistration)part));
    }
}

