/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.message.AlterMirrorTopicsResponseData;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.message.AlterMirrorsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterMirrorsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.MirrorTopicControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MirrorTopicControlManagerTest {
    LogContext logContext = new LogContext();
    SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
    FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(this.snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultFeatureMap((boolean)true), Collections.singletonList(0))).setMetadataVersion(MetadataVersion.latestTesting()).build();

    @Test
    public void testAddMirrorTopicRecord() {
        Uuid clusterLinkId = Uuid.randomUuid();
        String clusterLinkName = "link";
        Map<String, Uuid> clusterLinks = Collections.singletonMap(clusterLinkName, clusterLinkId);
        Map<Uuid, ClusterLink> uuidClusterLinkMap = Collections.singletonMap(clusterLinkId, new ClusterLink(clusterLinkName, clusterLinkId, "", "", "DESTINATION"));
        MirrorTopicControlManager mirrorTopicControl = new MirrorTopicControlManager(this.snapshotRegistry, this.logContext, Time.SYSTEM, __ -> Optional.empty(), linkName -> Optional.ofNullable(clusterLinks.get(linkName)), linkId -> Optional.ofNullable(uuidClusterLinkMap.get(linkId)), __ -> Optional.empty(), this.featureControl);
        ArrayList mirrorTopicRecord = new ArrayList(1);
        Uuid topicId = Uuid.randomUuid();
        ApiError error = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName("topic").setLinkName("link").setMirrorTopic("foo-origin").setSourceTopicId(Uuid.ZERO_UUID), topicId, mirrorTopicRecord::add);
        Assertions.assertEquals((Object)ApiError.NONE, (Object)error);
        Assertions.assertEquals((int)1, (int)mirrorTopicRecord.size());
        MirrorTopicRecord record = (MirrorTopicRecord)((ApiMessageAndVersion)mirrorTopicRecord.get(0)).message();
        Assertions.assertEquals((Object)record.topicId(), (Object)topicId);
        Assertions.assertEquals((Object)record.clusterLinkId(), (Object)clusterLinks.get("link"));
        Assertions.assertEquals((Object)record.mirrorTopicState(), (Object)MirrorTopic.State.MIRROR.stateName());
        Assertions.assertEquals((Object)record.sourceTopicId(), (Object)Uuid.ZERO_UUID);
        Assertions.assertEquals((Object)record.sourceTopicName(), (Object)"foo-origin");
    }

    @Test
    public void testAddRecordMissingLink() {
        MirrorTopicControlManager mirrorTopicControl = new MirrorTopicControlManager(this.snapshotRegistry, this.logContext, Time.SYSTEM, __ -> Optional.empty(), __ -> Optional.empty(), __ -> Optional.empty(), __ -> Optional.empty(), this.featureControl);
        ApiError error = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName("topic").setLinkName("link").setMirrorTopic("foo-origin").setSourceTopicId(Uuid.ZERO_UUID), Uuid.randomUuid(), Collections.emptyList()::add);
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)error.error());
    }

    @Test
    public void testAddRecordCreateTopic() {
        MirrorTopicControlManager mirrorTopicControl = new MirrorTopicControlManager(this.snapshotRegistry, this.logContext, Time.SYSTEM, __ -> Optional.empty(), __ -> Optional.empty(), __ -> Optional.empty(), __ -> Optional.empty(), this.featureControl);
        ArrayList mirrorTopicRecord = new ArrayList(1);
        ApiError error = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName("topic"), Uuid.randomUuid(), mirrorTopicRecord::add);
        Assertions.assertEquals((Object)Errors.NONE, (Object)error.error());
        Assertions.assertEquals((int)0, (int)mirrorTopicRecord.size());
        error = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName("topic").setMirrorTopic("foo-origin"), Uuid.randomUuid(), mirrorTopicRecord::add);
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)error.error());
        Assertions.assertEquals((int)0, (int)mirrorTopicRecord.size());
        error = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName("topic").setLinkName("link"), Uuid.randomUuid(), mirrorTopicRecord::add);
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)error.error());
        Assertions.assertEquals((int)0, (int)mirrorTopicRecord.size());
    }

    @Test
    public void testAlterMirrorTopics() {
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        HashMap<String, Uuid> linkIds = new HashMap<String, Uuid>();
        HashMap<Uuid, ClusterLink> clusterLinkMap = new HashMap<Uuid, ClusterLink>();
        Map clusterLinkConfigMap = Collections.emptyMap();
        MirrorTopicControlManager mirrorTopicControl = new MirrorTopicControlManager(this.snapshotRegistry, this.logContext, Time.SYSTEM, topicId -> Optional.ofNullable(topicIds.get(topicId)), linkId -> Optional.ofNullable(linkIds.get(linkId)), linkId -> Optional.ofNullable(clusterLinkMap.get(linkId)), linkId -> Optional.of(clusterLinkConfigMap), this.featureControl);
        Uuid topicId2 = Uuid.randomUuid();
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>(1);
        ApiError error = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName("foo").setLinkName("cluster-link").setMirrorTopic("foo-origin").setSourceTopicId(Uuid.randomUuid()), topicId2, records::add);
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)error.error());
        Assertions.assertEquals((int)0, (int)records.size());
        Uuid clusterLinkId = Uuid.randomUuid();
        String clusterLinkName = "cluster-link";
        linkIds.put(clusterLinkName, clusterLinkId);
        clusterLinkMap.put(clusterLinkId, new ClusterLink(clusterLinkName, clusterLinkId, "", "", "DESTINATION"));
        error = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName("foo").setLinkName("cluster-link").setMirrorTopic("foo-origin").setSourceTopicId(Uuid.randomUuid()), topicId2, records::add);
        Assertions.assertEquals((Object)Errors.NONE, (Object)error.error());
        Assertions.assertEquals((int)1, (int)records.size());
        RecordTestUtils.replayAll(mirrorTopicControl, records);
        ControllerResult result = mirrorTopicControl.alterMirrorTopics(MirrorTopicControlManagerTest.alterMirrorTopicRequest(alterMirrorTopic -> alterMirrorTopic.setTopic("foo").setMirrorTopicState(MirrorTopic.State.FAILED.stateName()), true));
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_ID.code(), (short)((AlterMirrorTopicsResponseData.AlterMirrorResult)((AlterMirrorTopicsResponseData)result.response()).alterMirrorResults().get(0)).errorCode());
        topicIds.put("foo", topicId2);
        result = mirrorTopicControl.alterMirrorTopics(MirrorTopicControlManagerTest.alterMirrorTopicRequest(alterMirrorTopic -> alterMirrorTopic.setTopic("foo").setMirrorTopicState(MirrorTopic.State.FAILED.stateName()), true));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((AlterMirrorTopicsResponseData)result.response()).errorCode());
        Assertions.assertEquals((int)0, (int)result.records().size());
        result = mirrorTopicControl.alterMirrorTopics(MirrorTopicControlManagerTest.alterMirrorTopicRequest(alterMirrorTopic -> alterMirrorTopic.setTopic("foo").setMirrorTopicState(MirrorTopic.State.FAILED.stateName()), false));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((AlterMirrorTopicsResponseData)result.response()).errorCode());
        Assertions.assertEquals((int)1, (int)result.records().size());
        RecordTestUtils.replayAll(mirrorTopicControl, result.records());
        Assertions.assertEquals((Object)MirrorTopic.State.FAILED, mirrorTopicControl.mirrorTopic(topicId2).map(MirrorTopic::mirrorState).orElse(null));
    }

    public ControllerResult<List<AlterMirrorsResponseData.AlterMirrorResult>> alterMirrors(MirrorTopicControlManager mirrorTopicControl, ControllerRequestContext context, AlterMirrorOp op, boolean validateOnly) {
        return this.alterMirrors(mirrorTopicControl, context, op, validateOnly, null);
    }

    public ControllerResult<List<AlterMirrorsResponseData.AlterMirrorResult>> alterMirrors(MirrorTopicControlManager mirrorTopicControl, ControllerRequestContext context, AlterMirrorOp op, boolean validateOnly, AlterMirrorsRequestData.MirrorOperationData data) {
        AlterMirrorsRequestData.MirrorOperation alterOp = new AlterMirrorsRequestData.MirrorOperation().setTopic("foo").setOperationCode(op.id()).setMirrorOperationData(data);
        AlterMirrorsRequest request = (AlterMirrorsRequest)new AlterMirrorsRequest.Builder(Collections.singletonList(alterOp), validateOnly, 10000).build();
        return mirrorTopicControl.alterMirrors(context, request.mirrorOperations(), request.validateOnly());
    }

    @Test
    public void testReverseAndSwapFailsWithMultipleLinkIds() {
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        HashMap<String, Uuid> linkIds = new HashMap<String, Uuid>();
        HashMap<Uuid, ClusterLink> clusterLinkMap = new HashMap<Uuid, ClusterLink>();
        MirrorTopicControlManager mirrorTopicControl = new MirrorTopicControlManager(this.snapshotRegistry, this.logContext, Time.SYSTEM, topicName -> Optional.ofNullable(topicIds.get(topicName)), name -> Optional.ofNullable(linkIds.get(name)), linkId -> Optional.ofNullable(clusterLinkMap.get(linkId)), __ -> Optional.empty(), this.featureControl);
        Uuid topicId1 = Uuid.randomUuid();
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>(2);
        Uuid clusterLinkId1 = Uuid.randomUuid();
        String clusterLinkName1 = "cluster-link1";
        String topicName1 = "foo1";
        linkIds.put(clusterLinkName1, clusterLinkId1);
        topicIds.put(topicName1, topicId1);
        clusterLinkMap.put(clusterLinkId1, new ClusterLink(clusterLinkName1, clusterLinkId1, "", "", "BIDIRECTIONAL"));
        ApiError error1 = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName(topicName1).setLinkName(clusterLinkName1).setMirrorTopic(topicName1).setSourceTopicId(Uuid.randomUuid()).setMirrorStartOffsets(Arrays.asList(0L, 0L, 0L, 0L)), topicId1, records::add);
        Assertions.assertEquals((Object)Errors.NONE, (Object)error1.error());
        Assertions.assertEquals((int)1, (int)records.size());
        Uuid topicId2 = Uuid.randomUuid();
        Uuid clusterLinkId2 = Uuid.randomUuid();
        String clusterLinkName2 = "cluster-link2";
        String topicName2 = "foo2";
        linkIds.put(clusterLinkName2, clusterLinkId2);
        topicIds.put(topicName2, topicId2);
        clusterLinkMap.put(clusterLinkId2, new ClusterLink(clusterLinkName2, clusterLinkId2, "", "", "BIDIRECTIONAL"));
        ApiError error2 = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName(topicName2).setLinkName(clusterLinkName2).setMirrorTopic(topicName2).setSourceTopicId(Uuid.randomUuid()).setMirrorStartOffsets(Arrays.asList(0L, 0L, 0L, 0L)), topicId2, records::add);
        Assertions.assertEquals((Object)Errors.NONE, (Object)error2.error());
        Assertions.assertEquals((int)2, (int)records.size());
        RecordTestUtils.replayAll(mirrorTopicControl, records);
        AlterMirrorsRequestData.MirrorOperation alterOp1 = new AlterMirrorsRequestData.MirrorOperation().setTopic(topicName1).setOperationCode(AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR.id());
        AlterMirrorsRequestData.MirrorOperation alterOp2 = new AlterMirrorsRequestData.MirrorOperation().setTopic(topicName2).setOperationCode(AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR.id());
        List<AlterMirrorsRequestData.MirrorOperation> mirrorOperations = Arrays.asList(alterOp1, alterOp2);
        AlterMirrorsRequest request = (AlterMirrorsRequest)new AlterMirrorsRequest.Builder(mirrorOperations, false, 10000).build();
        Throwable exception = Assertions.assertThrows(InvalidRequestException.class, () -> mirrorTopicControl.alterMirrors(null, request.mirrorOperations(), request.validateOnly()));
        Assertions.assertEquals((Object)"Reverse and swap operations are only supported on topics that are on the same cluster link", (Object)exception.getMessage());
    }

    @Test
    public void testTruncateAndRestoreFailsWithMultipleLinkIds() {
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        HashMap<String, Uuid> linkIds = new HashMap<String, Uuid>();
        HashMap<Uuid, ClusterLink> clusterLinkMap = new HashMap<Uuid, ClusterLink>();
        MirrorTopicControlManager mirrorTopicControl = new MirrorTopicControlManager(this.snapshotRegistry, this.logContext, Time.SYSTEM, topicName -> Optional.ofNullable(topicIds.get(topicName)), name -> Optional.ofNullable(linkIds.get(name)), linkId -> Optional.ofNullable(clusterLinkMap.get(linkId)), __ -> Optional.empty(), this.featureControl);
        Uuid topicId1 = Uuid.randomUuid();
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>(2);
        Uuid clusterLinkId1 = Uuid.randomUuid();
        String clusterLinkName1 = "cluster-link1";
        String topicName1 = "foo1";
        linkIds.put(clusterLinkName1, clusterLinkId1);
        topicIds.put(topicName1, topicId1);
        clusterLinkMap.put(clusterLinkId1, new ClusterLink(clusterLinkName1, clusterLinkId1, "", "", "BIDIRECTIONAL"));
        ApiError error1 = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName(topicName1).setLinkName(clusterLinkName1).setMirrorTopic(topicName1).setSourceTopicId(Uuid.randomUuid()).setMirrorStartOffsets(Arrays.asList(0L, 0L, 0L, 0L)), topicId1, records::add);
        Assertions.assertEquals((Object)Errors.NONE, (Object)error1.error());
        Assertions.assertEquals((int)1, (int)records.size());
        Uuid topicId2 = Uuid.randomUuid();
        Uuid clusterLinkId2 = Uuid.randomUuid();
        String clusterLinkName2 = "cluster-link2";
        String topicName2 = "foo2";
        linkIds.put(clusterLinkName2, clusterLinkId2);
        topicIds.put(topicName2, topicId2);
        clusterLinkMap.put(clusterLinkId2, new ClusterLink(clusterLinkName2, clusterLinkId2, "", "", "BIDIRECTIONAL"));
        ApiError error2 = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName(topicName2).setLinkName(clusterLinkName2).setMirrorTopic(topicName2).setSourceTopicId(Uuid.randomUuid()).setMirrorStartOffsets(Arrays.asList(0L, 0L, 0L, 0L)), topicId2, records::add);
        Assertions.assertEquals((Object)Errors.NONE, (Object)error2.error());
        Assertions.assertEquals((int)2, (int)records.size());
        RecordTestUtils.replayAll(mirrorTopicControl, records);
        AlterMirrorsRequestData.MirrorOperation alterOp1 = new AlterMirrorsRequestData.MirrorOperation().setTopic(topicName1).setOperationCode(AlterMirrorOp.TRUNCATE_AND_RESTORE.id());
        AlterMirrorsRequestData.MirrorOperation alterOp2 = new AlterMirrorsRequestData.MirrorOperation().setTopic(topicName2).setOperationCode(AlterMirrorOp.TRUNCATE_AND_RESTORE.id());
        List<AlterMirrorsRequestData.MirrorOperation> mirrorOperations = Arrays.asList(alterOp1, alterOp2);
        AlterMirrorsRequest request = (AlterMirrorsRequest)new AlterMirrorsRequest.Builder(mirrorOperations, false, 10000).build();
        Throwable exception = Assertions.assertThrows(InvalidRequestException.class, () -> mirrorTopicControl.alterMirrors(null, request.mirrorOperations(), request.validateOnly()));
        Assertions.assertEquals((Object)"Restore operations are only supported on topics that are on the same cluster link", (Object)exception.getMessage());
    }

    @Test
    public void testAlterMirrors() {
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        HashMap<String, Uuid> linkIds = new HashMap<String, Uuid>();
        HashMap<Uuid, ClusterLink> clusterLinkMap = new HashMap<Uuid, ClusterLink>();
        HashMap<String, String> clusterLinkConfigMap = new HashMap<String, String>();
        MirrorTopicControlManager mirrorTopicControl = new MirrorTopicControlManager(this.snapshotRegistry, this.logContext, Time.SYSTEM, topicId -> Optional.ofNullable(topicIds.get(topicId)), name -> Optional.ofNullable(linkIds.get(name)), linkId -> Optional.ofNullable(clusterLinkMap.get(linkId)), linkId -> Optional.of(clusterLinkConfigMap), this.featureControl);
        Uuid topicId2 = Uuid.randomUuid();
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>(1);
        Uuid clusterLinkId = Uuid.randomUuid();
        String clusterLinkName = "cluster-link";
        linkIds.put(clusterLinkName, clusterLinkId);
        clusterLinkConfigMap.put("link.mode", ClusterLinkConfig.LinkMode.BIDIRECTIONAL.name());
        clusterLinkMap.put(clusterLinkId, new ClusterLink(clusterLinkName, clusterLinkId, "", "", "BIDIRECTIONAL"));
        ApiError error = mirrorTopicControl.maybeAddMirrorTopicRecord(new CreateTopicsRequestData.CreatableTopic().setName("foo").setLinkName("cluster-link").setMirrorTopic("foo-origin").setSourceTopicId(Uuid.randomUuid()).setMirrorStartOffsets(Arrays.asList(0L, 0L, 0L, 0L)), topicId2, records::add);
        Assertions.assertEquals((Object)Errors.NONE, (Object)error.error());
        Assertions.assertEquals((int)1, (int)records.size());
        RecordTestUtils.replayAll(mirrorTopicControl, records);
        ControllerRequestContext context = ControllerRequestContextUtil.anonymousContextFor(ApiKeys.ALTER_MIRRORS, (Uuid)linkIds.get("cluster-link"));
        for (AlterMirrorOp op : AlterMirrorOp.values()) {
            ControllerResult<List<AlterMirrorsResponseData.AlterMirrorResult>> result = this.alterMirrors(mirrorTopicControl, context, op, true);
            Assertions.assertFalse((boolean)((List)result.response()).isEmpty());
            Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((AlterMirrorsResponseData.AlterMirrorResult)((List)result.response()).get(0)).errorCode());
            Assertions.assertTrue((boolean)result.records().isEmpty());
        }
        topicIds.put("foo", topicId2);
        for (Boolean validateOnly : Arrays.asList(true, false)) {
            for (AlterMirrorOp op : AlterMirrorOp.values()) {
                Errors expectedError;
                ControllerResult<List<AlterMirrorsResponseData.AlterMirrorResult>> result = this.alterMirrors(mirrorTopicControl, context, op, validateOnly);
                Assertions.assertFalse((boolean)((List)result.response()).isEmpty());
                switch (op) {
                    case CLEAR: 
                    case STOP: 
                    case CONVERT_TO_START_PENDING_MIRROR: 
                    case CONVERT_TO_PAUSE_PENDING_MIRROR: 
                    case FAIL_MIRROR: 
                    case START_PENDING_MIRROR: 
                    case PAUSE_PENDING_MIRROR: 
                    case TRUNCATE_AND_RESTORE: 
                    case CONVERT_TO_PENDING_RESTORE_MIRROR: 
                    case START_PENDING_RESTORE_MIRROR: 
                    case REPAIR: 
                    case COMPLETE_REPAIR: 
                    case ROLLBACK: {
                        expectedError = Errors.INVALID_REQUEST;
                        break;
                    }
                    default: {
                        expectedError = Errors.NONE;
                    }
                }
                Assertions.assertEquals((short)expectedError.code(), (short)((AlterMirrorsResponseData.AlterMirrorResult)((List)result.response()).get(0)).errorCode(), (String)("Incorrect error received for operation " + op + " with message: " + ((AlterMirrorsResponseData.AlterMirrorResult)((List)result.response()).get(0)).errorMessage()));
                if (expectedError != Errors.NONE) {
                    Assertions.assertTrue((boolean)result.records().isEmpty(), (String)("Unexpected records for op " + op));
                    continue;
                }
                if (validateOnly.booleanValue()) {
                    Assertions.assertTrue((boolean)result.records().isEmpty(), (String)("Unexpected records for op " + op));
                    continue;
                }
                if (op == AlterMirrorOp.RESUME || op == AlterMirrorOp.RESUME_LINK) {
                    Assertions.assertTrue((boolean)result.records().isEmpty(), (String)("Unexpected records for op " + op));
                    continue;
                }
                Assertions.assertFalse((boolean)result.records().isEmpty(), (String)("Unexpected records for op " + op));
            }
        }
        ControllerResult<List<AlterMirrorsResponseData.AlterMirrorResult>> result = this.alterMirrors(mirrorTopicControl, context, AlterMirrorOp.STOP, false, new AlterMirrorsRequestData.MirrorOperationData().setStoppedLogEndOffsets(Arrays.asList(0L, 0L, 0L, 0L)));
        Assertions.assertFalse((boolean)((List)result.response()).isEmpty());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((AlterMirrorsResponseData.AlterMirrorResult)((List)result.response()).get(0)).errorCode());
        Assertions.assertTrue((boolean)result.records().isEmpty());
        result = this.alterMirrors(mirrorTopicControl, context, AlterMirrorOp.PROMOTE, false);
        Assertions.assertFalse((boolean)((List)result.response()).isEmpty());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((AlterMirrorsResponseData.AlterMirrorResult)((List)result.response()).get(0)).errorCode());
        Assertions.assertFalse((boolean)result.records().isEmpty());
        RecordTestUtils.replayAll(mirrorTopicControl, result.records());
        Optional mirrorTopicOpt = mirrorTopicControl.mirrorTopic(topicId2);
        Assertions.assertTrue((boolean)mirrorTopicOpt.isPresent());
        Assertions.assertEquals((Object)MirrorTopic.State.PENDING_STOPPED, (Object)((MirrorTopic)mirrorTopicOpt.get()).mirrorState());
        result = this.alterMirrors(mirrorTopicControl, context, AlterMirrorOp.STOP, false);
        Assertions.assertFalse((boolean)((List)result.response()).isEmpty());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)((AlterMirrorsResponseData.AlterMirrorResult)((List)result.response()).get(0)).errorCode());
        Assertions.assertTrue((boolean)result.records().isEmpty());
        result = this.alterMirrors(mirrorTopicControl, context, AlterMirrorOp.STOP, false, new AlterMirrorsRequestData.MirrorOperationData().setStoppedLogEndOffsets(Arrays.asList(0L, 0L, 0L, 0L)));
        Assertions.assertFalse((boolean)((List)result.response()).isEmpty());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((AlterMirrorsResponseData.AlterMirrorResult)((List)result.response()).get(0)).errorCode(), (String)((AlterMirrorsResponseData.AlterMirrorResult)((List)result.response()).get(0)).errorMessage());
        RecordTestUtils.replayAll(mirrorTopicControl, result.records());
        mirrorTopicOpt = mirrorTopicControl.mirrorTopic(topicId2);
        Assertions.assertTrue((boolean)mirrorTopicOpt.isPresent());
        Assertions.assertEquals((Object)MirrorTopic.State.STOPPED, (Object)((MirrorTopic)mirrorTopicOpt.get()).mirrorState());
    }

    @Test
    public void testMirrorTopicStateMachine() {
        HashMap<MirrorTopic.State, HashSet<MirrorTopic.State>> allowed = new HashMap<MirrorTopic.State, HashSet<MirrorTopic.State>>();
        allowed.put(MirrorTopic.State.MIRROR, new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.MIRROR, MirrorTopic.State.PAUSED, MirrorTopic.State.FAILED, MirrorTopic.State.PENDING_STOPPED, MirrorTopic.State.PENDING_SYNCHRONIZE)));
        allowed.put(MirrorTopic.State.PAUSED, new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.PAUSED, MirrorTopic.State.MIRROR, MirrorTopic.State.FAILED, MirrorTopic.State.PENDING_REPAIR, MirrorTopic.State.PENDING_STOPPED, MirrorTopic.State.PENDING_SYNCHRONIZE)));
        allowed.put(MirrorTopic.State.FAILED, new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.FAILED, MirrorTopic.State.PENDING_REPAIR, MirrorTopic.State.PAUSED, MirrorTopic.State.PENDING_STOPPED)));
        allowed.put(MirrorTopic.State.PENDING_STOPPED, new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.PENDING_STOPPED, MirrorTopic.State.STOPPED, MirrorTopic.State.MIRROR)));
        allowed.put(MirrorTopic.State.STOPPED, new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.STOPPED, MirrorTopic.State.PENDING_MIRROR)));
        allowed.put(MirrorTopic.State.PENDING_MIRROR, new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.PENDING_MIRROR, MirrorTopic.State.MIRROR, MirrorTopic.State.PENDING_STOPPED, MirrorTopic.State.PAUSED, MirrorTopic.State.FAILED)));
        allowed.put(MirrorTopic.State.PENDING_REPAIR, new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.PENDING_REPAIR, MirrorTopic.State.MIRROR, MirrorTopic.State.FAILED, MirrorTopic.State.PAUSED, MirrorTopic.State.PENDING_STOPPED)));
        allowed.put(MirrorTopic.State.PENDING_SYNCHRONIZE, new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.PENDING_SYNCHRONIZE, MirrorTopic.State.PENDING_STOPPED, MirrorTopic.State.FAILED, MirrorTopic.State.PAUSED, MirrorTopic.State.MIRROR)));
        HashSet<MirrorTopic.State> validStates = new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.values()));
        HashSet<MirrorTopic.State> unsupportedAlterMirrorTopicStates = new HashSet<MirrorTopic.State>(Arrays.asList(MirrorTopic.State.PENDING_SETUP_FOR_RESTORE, MirrorTopic.State.PENDING_RESTORE));
        for (MirrorTopic.State initialState : validStates) {
            for (MirrorTopic.State proposedState : validStates) {
                if (unsupportedAlterMirrorTopicStates.contains(initialState) || unsupportedAlterMirrorTopicStates.contains(proposedState)) {
                    Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.tryStateChange(initialState, proposedState), (String)("Expected an error for transition from " + initialState + " to " + proposedState));
                    continue;
                }
                boolean isAllowed = ((Set)allowed.get(initialState)).contains(proposedState);
                if (!isAllowed) {
                    Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.tryStateChange(initialState, proposedState), (String)("Expected an error for transition from " + initialState + " to " + proposedState));
                    continue;
                }
                Assertions.assertEquals((Object)Errors.NONE, (Object)this.tryStateChange(initialState, proposedState), (String)("Expected no error for transition from " + initialState + " to " + proposedState));
            }
        }
    }

    @Test
    public void testUnsupportedRollbackStates() {
        MirrorTopicControlManager mirrorTopicControl = new MirrorTopicControlManager(this.snapshotRegistry, this.logContext, Time.SYSTEM, __ -> Optional.empty(), __ -> Optional.empty(), __ -> Optional.empty(), __ -> Optional.empty(), this.featureControl);
        Assertions.assertThrows(InvalidRequestException.class, () -> mirrorTopicControl.validateNotUnsupportedRollbackState(MirrorTopic.State.MIRROR));
        Assertions.assertThrows(InvalidRequestException.class, () -> mirrorTopicControl.validateNotUnsupportedRollbackState(MirrorTopic.State.PAUSED));
        Assertions.assertThrows(InvalidRequestException.class, () -> mirrorTopicControl.validateNotUnsupportedRollbackState(MirrorTopic.State.FAILED));
        Assertions.assertThrows(InvalidRequestException.class, () -> mirrorTopicControl.validateNotUnsupportedRollbackState(MirrorTopic.State.PENDING_MIRROR));
        mirrorTopicControl.validateNotUnsupportedRollbackState(MirrorTopic.State.PENDING_STOPPED);
        mirrorTopicControl.validateNotUnsupportedRollbackState(MirrorTopic.State.PENDING_SYNCHRONIZE);
    }

    Errors tryStateChange(MirrorTopic.State initialState, MirrorTopic.State state) {
        Uuid topicId = Uuid.randomUuid();
        MirrorTopic mirrorTopic = MirrorTopicControlManagerTest.mirrorTopic(topicId, initialState);
        MirrorTopicControlManager mirrorTopicControl = new MirrorTopicControlManager(this.snapshotRegistry, this.logContext, Time.SYSTEM, __ -> Optional.of(topicId), __ -> Optional.empty(), __ -> Optional.empty(), __ -> Optional.empty(), this.featureControl);
        mirrorTopicControl.replay(MirrorTopic.toSnapshotRecord((MirrorTopic)mirrorTopic, (String)"foo"));
        Assertions.assertTrue((boolean)mirrorTopicControl.isMirrorTopic(topicId));
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic();
        alterMirrorTopic.setTopic("foo").setMirrorTopicState(state.stateName()).setNextState(MirrorTopic.State.PAUSED.stateName());
        return mirrorTopicControl.alterMirrorState(alterMirrorTopic, __ -> {}).error();
    }

    static MirrorTopic mirrorTopic(Uuid topicId, MirrorTopic.State state) {
        return MirrorTopic.fromRecord((MirrorTopicRecord)new MirrorTopicRecord().setClusterLinkId(Uuid.randomUuid()).setClusterLinkName("foo-link").setTopicId(topicId).setTopicName("foo").setMirrorTopicState(state.stateName()).setSourceTopicName("foo-origin").setSourceTopicId(Uuid.randomUuid()).setPreviousToPausedState(MirrorTopic.State.MIRROR.stateName()).setNextState(MirrorTopic.State.PAUSED.stateName()));
    }

    static AlterMirrorTopicsRequestData alterMirrorTopicRequest(Consumer<AlterMirrorTopicsRequestData.AlterMirrorTopic> consumer, boolean validateOnly) {
        AlterMirrorTopicsRequestData request = new AlterMirrorTopicsRequestData();
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic();
        consumer.accept(alterMirrorTopic);
        request.setAlterMirrorTopics(Collections.singletonList(alterMirrorTopic));
        request.setValidateOnly(validateOnly);
        return request;
    }
}

