/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.OptionalLong;
import java.util.function.Consumer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.controller.ControllerRequestContext;

public class ControllerRequestContextUtil {
    public static final ControllerRequestContext ANONYMOUS_CONTEXT = new ControllerRequestContext(new RequestHeaderData(), KafkaPrincipal.ANONYMOUS, OptionalLong.empty());
    public static final String QUOTA_EXCEEDED_IN_TEST_MSG = "Quota exceeded in test";

    public static ControllerRequestContext anonymousContextFor(ApiKeys apiKeys) {
        return ControllerRequestContextUtil.anonymousContextFor(apiKeys, apiKeys.latestVersion(), __ -> {});
    }

    public static ControllerRequestContext anonymousContextFor(ApiKeys apiKeys, Uuid linkId) {
        return ControllerRequestContextUtil.anonymousContextFor(apiKeys, apiKeys.latestVersion(), __ -> {}, linkId);
    }

    public static ControllerRequestContext anonymousContextWithMutationQuotaExceededFor(ApiKeys apiKeys) {
        return ControllerRequestContextUtil.anonymousContextFor(apiKeys, apiKeys.latestVersion(), x -> {
            throw new ThrottlingQuotaExceededException(QUOTA_EXCEEDED_IN_TEST_MSG);
        });
    }

    public static ControllerRequestContext anonymousContextFor(ApiKeys apiKeys, short version) {
        return ControllerRequestContextUtil.anonymousContextFor(apiKeys, version, __ -> {});
    }

    public static ControllerRequestContext anonymousContextFor(ApiKeys apiKeys, short version, Consumer<Integer> partitionChangeQuotaApplier) {
        return ControllerRequestContextUtil.anonymousContextFor(apiKeys, version, partitionChangeQuotaApplier, Uuid.ZERO_UUID);
    }

    public static ControllerRequestContext anonymousContextFor(ApiKeys apiKeys, short version, Consumer<Integer> partitionChangeQuotaApplier, Uuid linkId) {
        return new ControllerRequestContext(new RequestHeaderData().setRequestApiKey(apiKeys.id).setRequestApiVersion(version).setClusterLinkId(linkId), KafkaPrincipal.ANONYMOUS, OptionalLong.empty(), partitionChangeQuotaApplier);
    }
}

