/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metalog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metalog.LocalLogManager;
import org.apache.kafka.metalog.MockMetaLogManagerListener;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.test.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLogManagerTestEnv
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(LocalLogManagerTestEnv.class);
    private final String clusterId;
    final AtomicReference<String> firstError = new AtomicReference<Object>(null);
    private final File dir;
    private final LocalLogManager.SharedLogData shared;
    private final List<LocalLogManager> logManagers;

    private LocalLogManagerTestEnv(int numManagers, Optional<RawSnapshotReader> snapshotReader, Consumer<LocalLogManager.SharedLogData> sharedLogDataInitializer) {
        this.clusterId = Uuid.randomUuid().toString();
        this.dir = TestUtils.tempDirectory();
        this.shared = new LocalLogManager.SharedLogData(snapshotReader);
        sharedLogDataInitializer.accept(this.shared);
        ArrayList<LocalLogManager> newLogManagers = new ArrayList<LocalLogManager>(numManagers);
        try {
            for (int nodeId = 0; nodeId < numManagers; ++nodeId) {
                newLogManagers.add(new LocalLogManager(new LogContext(String.format("[LocalLogManager %d] ", nodeId)), nodeId, this.shared, String.format("LocalLogManager-%d_", nodeId)));
            }
        }
        catch (Throwable t) {
            for (LocalLogManager logManager : newLogManagers) {
                logManager.close();
            }
            throw t;
        }
        this.logManagers = newLogManagers;
    }

    public List<ApiMessageAndVersion> allRecords() {
        return this.shared.allRecords();
    }

    public void appendInitialRecords(List<ApiMessageAndVersion> records) {
        int initialLeaderEpoch = 1;
        this.shared.append(OptionalLong.empty(), new LocalLogManager.LeaderChangeBatch(new LeaderAndEpoch(OptionalInt.empty(), initialLeaderEpoch + 1)));
        this.shared.append(OptionalLong.empty(), new LocalLogManager.LocalRecordBatch(initialLeaderEpoch + 1, 0L, records));
        this.shared.append(OptionalLong.empty(), new LocalLogManager.LeaderChangeBatch(new LeaderAndEpoch(OptionalInt.of(0), initialLeaderEpoch + 2)));
    }

    public String clusterId() {
        return this.clusterId;
    }

    AtomicReference<String> firstError() {
        return this.firstError;
    }

    File dir() {
        return this.dir;
    }

    LeaderAndEpoch waitForLeader() throws InterruptedException {
        AtomicReference<Object> value = new AtomicReference<Object>(null);
        TestUtils.retryOnExceptionWithTimeout((long)20000L, (long)3L, () -> {
            LeaderAndEpoch result = null;
            for (LocalLogManager logManager : this.logManagers) {
                int nodeId;
                LeaderAndEpoch leader = logManager.leaderAndEpoch();
                if (!leader.isLeader(nodeId = logManager.nodeId().getAsInt())) continue;
                if (result != null) {
                    throw new RuntimeException("node " + nodeId + " thinks it's the leader, but so does " + result.leaderId());
                }
                result = leader;
            }
            if (result == null) {
                throw new RuntimeException("No leader found.");
            }
            value.set(result);
        });
        return value.get();
    }

    public List<LocalLogManager> logManagers() {
        return this.logManagers;
    }

    public RawSnapshotReader waitForSnapshot(long committedOffset) throws InterruptedException {
        return this.shared.waitForSnapshot(committedOffset);
    }

    public RawSnapshotReader waitForLatestSnapshot() throws InterruptedException {
        return this.shared.waitForLatestSnapshot();
    }

    public long appendedBytes() {
        return this.shared.appendedBytes();
    }

    public LeaderAndEpoch leaderAndEpoch() {
        return this.shared.leaderAndEpoch();
    }

    @Override
    public void close() throws InterruptedException {
        try {
            for (LocalLogManager logManager : this.logManagers) {
                logManager.beginShutdown();
            }
            for (LocalLogManager logManager : this.logManagers) {
                logManager.close();
            }
            Utils.delete((File)this.dir);
        }
        catch (IOException e) {
            log.error("Error deleting {}", (Object)this.dir.getAbsolutePath(), (Object)e);
        }
    }

    public static class Builder {
        private final int numManagers;
        private Optional<RawSnapshotReader> snapshotReader = Optional.empty();
        private Consumer<LocalLogManager.SharedLogData> sharedLogDataInitializer = __ -> {};

        public Builder(int numManagers) {
            this.numManagers = numManagers;
        }

        public Builder setSnapshotReader(RawSnapshotReader snapshotReader) {
            this.snapshotReader = Optional.of(snapshotReader);
            return this;
        }

        public Builder setSharedLogDataInitializer(Consumer<LocalLogManager.SharedLogData> sharedLogDataInitializer) {
            this.sharedLogDataInitializer = sharedLogDataInitializer;
            return this;
        }

        public LocalLogManagerTestEnv build() {
            return new LocalLogManagerTestEnv(this.numManagers, this.snapshotReader, this.sharedLogDataInitializer);
        }

        public LocalLogManagerTestEnv buildWithMockListeners() {
            LocalLogManagerTestEnv env = this.build();
            try {
                for (LocalLogManager logManager : env.logManagers) {
                    logManager.register(new MockMetaLogManagerListener(logManager.nodeId().getAsInt()));
                }
            }
            catch (Exception e) {
                try {
                    env.close();
                }
                catch (Exception t) {
                    log.error("Error while closing new log environment", (Throwable)t);
                }
                throw e;
            }
            return env;
        }
    }
}

