/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PartitionAssignmentTest {
    public static PartitionAssignment partitionAssignment(List<Integer> replicas) {
        return new PartitionAssignment(replicas, __ -> DirectoryId.MIGRATING);
    }

    @Test
    public void testPartitionAssignmentReplicas() {
        List<Integer> replicas = Arrays.asList(0, 1, 2);
        Assertions.assertEquals(replicas, (Object)PartitionAssignmentTest.partitionAssignment(replicas).replicas());
    }

    @Test
    public void testConsistentEqualsAndHashCode() {
        List<PartitionAssignment> partitionAssignments = Arrays.asList(PartitionAssignmentTest.partitionAssignment(Arrays.asList(0, 1, 2)), PartitionAssignmentTest.partitionAssignment(Arrays.asList(1, 2, 0)));
        for (int i = 0; i < partitionAssignments.size(); ++i) {
            for (int j = 0; j < partitionAssignments.size(); ++j) {
                if (i == j) {
                    Assertions.assertEquals((Object)partitionAssignments.get(i), (Object)partitionAssignments.get(j));
                    Assertions.assertEquals((Object)partitionAssignments.get(i), (Object)PartitionAssignmentTest.partitionAssignment(partitionAssignments.get(i).replicas()));
                    Assertions.assertEquals((int)partitionAssignments.get(i).hashCode(), (int)partitionAssignments.get(j).hashCode());
                    continue;
                }
                Assertions.assertNotEquals((Object)partitionAssignments.get(i), (Object)partitionAssignments.get(j));
                Assertions.assertNotEquals((int)partitionAssignments.get(i).hashCode(), (int)partitionAssignments.get(j).hashCode());
            }
        }
    }

    @Test
    public void testToString() {
        List<Integer> replicas = Arrays.asList(0, 1, 2);
        List<Uuid> directories = Arrays.asList(Uuid.fromString((String)"65WMNfybQpCDVulYOxMCTw"), Uuid.fromString((String)"VkZ5AkuESPGkMc2OxpKUjw"), Uuid.fromString((String)"wFtTi4FxTlOhhHytfxv7fQ"));
        PartitionAssignment partitionAssignment = new PartitionAssignment(replicas, directories::get);
        Assertions.assertEquals((Object)"PartitionAssignment(replicas=[0, 1, 2], directories=[65WMNfybQpCDVulYOxMCTw, VkZ5AkuESPGkMc2OxpKUjw, wFtTi4FxTlOhhHytfxv7fQ])", (Object)partitionAssignment.toString());
    }
}

