/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BrokerRegistrationTest {
    private static final List<BrokerRegistration> REGISTRATIONS = Arrays.asList(new BrokerRegistration.Builder().setId(0).setEpoch(0L).setIncarnationId(Uuid.fromString((String)"pc1GhUlBS92cGGaKXl6ipw")).setListeners(Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9090))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)2))).setRack(Optional.empty()).setFenced(false).setInControlledShutdown(false).build(), new BrokerRegistration.Builder().setId(1).setEpoch(0L).setIncarnationId(Uuid.fromString((String)"3MfdxWlNSn2UDYsmDP1pYg")).setListeners(Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9091))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)2))).setRack(Optional.empty()).setFenced(true).setInControlledShutdown(false).build(), new BrokerRegistration.Builder().setId(2).setEpoch(0L).setIncarnationId(Uuid.fromString((String)"eY7oaG1RREie5Kk9uy1l6g")).setListeners(Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9092))).setSupportedFeatures(Stream.of(new AbstractMap.SimpleEntry<String, VersionRange>("foo", VersionRange.of((short)2, (short)3)), new AbstractMap.SimpleEntry<String, VersionRange>("bar", VersionRange.of((short)1, (short)4))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue))).setRack(Optional.of("myrack")).setFenced(false).setInControlledShutdown(true).build(), new BrokerRegistration.Builder().setId(3).setEpoch(0L).setIncarnationId(Uuid.fromString((String)"1t8VyWx2TCSTpUWuqj-FOw")).setListeners(Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9093))).setSupportedFeatures(Stream.of(new AbstractMap.SimpleEntry<String, VersionRange>("metadata.version", VersionRange.of((short)7, (short)7))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue))).setRack(Optional.empty()).setFenced(false).setInControlledShutdown(true).setIsMigratingZkBroker(true).setDirectories(Arrays.asList(Uuid.fromString((String)"r4HpEsMuST6nQ4rznIEJVA"))).build());

    @Test
    public void testValues() {
        Assertions.assertEquals((int)0, (int)REGISTRATIONS.get(0).id());
        Assertions.assertEquals((int)1, (int)REGISTRATIONS.get(1).id());
        Assertions.assertEquals((int)2, (int)REGISTRATIONS.get(2).id());
        Assertions.assertEquals((int)3, (int)REGISTRATIONS.get(3).id());
    }

    @Test
    public void testEquals() {
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(0), (Object)REGISTRATIONS.get(1));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(1), (Object)REGISTRATIONS.get(0));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(0), (Object)REGISTRATIONS.get(2));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(2), (Object)REGISTRATIONS.get(0));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(3), (Object)REGISTRATIONS.get(0));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(3), (Object)REGISTRATIONS.get(1));
        Assertions.assertNotEquals((Object)REGISTRATIONS.get(3), (Object)REGISTRATIONS.get(2));
        Assertions.assertEquals((Object)REGISTRATIONS.get(0), (Object)REGISTRATIONS.get(0));
        Assertions.assertEquals((Object)REGISTRATIONS.get(1), (Object)REGISTRATIONS.get(1));
        Assertions.assertEquals((Object)REGISTRATIONS.get(2), (Object)REGISTRATIONS.get(2));
        Assertions.assertEquals((Object)REGISTRATIONS.get(3), (Object)REGISTRATIONS.get(3));
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"BrokerRegistration(id=1, epoch=0, incarnationId=3MfdxWlNSn2UDYsmDP1pYg, listeners=[Endpoint(listenerName='INTERNAL', securityProtocol=PLAINTEXT, host='localhost', port=9091)], supportedFeatures={foo: 1-2}, rack=Optional.empty, fenced=true, inControlledShutdown=false, isMigratingZkBroker=false, directories=[])", (Object)REGISTRATIONS.get(1).toString());
        Assertions.assertEquals((Object)"BrokerRegistration(id=2, epoch=0, incarnationId=eY7oaG1RREie5Kk9uy1l6g, listeners=[Endpoint(listenerName='INTERNAL', securityProtocol=PLAINTEXT, host='localhost', port=9092)], supportedFeatures={bar: 1-4, foo: 2-3}, rack=Optional[myrack], fenced=false, inControlledShutdown=true, isMigratingZkBroker=false, directories=[])", (Object)REGISTRATIONS.get(2).toString());
        Assertions.assertEquals((Object)"BrokerRegistration(id=3, epoch=0, incarnationId=1t8VyWx2TCSTpUWuqj-FOw, listeners=[Endpoint(listenerName='INTERNAL', securityProtocol=PLAINTEXT, host='localhost', port=9093)], supportedFeatures={metadata.version: 7}, rack=Optional.empty, fenced=false, inControlledShutdown=true, isMigratingZkBroker=true, directories=[r4HpEsMuST6nQ4rznIEJVA])", (Object)REGISTRATIONS.get(3).toString());
    }

    @Test
    public void testFromRecordAndToRecord() {
        this.testRoundTrip(REGISTRATIONS.get(0));
        this.testRoundTrip(REGISTRATIONS.get(1));
        this.testRoundTrip(REGISTRATIONS.get(2));
        this.testRoundTrip(REGISTRATIONS.get(3));
    }

    private void testRoundTrip(BrokerRegistration registration) {
        ImageWriterOptions options = new ImageWriterOptions.Builder().build();
        ApiMessageAndVersion messageAndVersion = registration.toRecord(options);
        BrokerRegistration registration2 = BrokerRegistration.fromRecord((RegisterBrokerRecord)((RegisterBrokerRecord)messageAndVersion.message()));
        Assertions.assertEquals((Object)registration, (Object)registration2);
        ApiMessageAndVersion messageAndVersion2 = registration2.toRecord(options);
        Assertions.assertEquals((Object)messageAndVersion, (Object)messageAndVersion2);
    }

    @Test
    public void testToNode() {
        Assertions.assertEquals(Optional.empty(), (Object)REGISTRATIONS.get(0).node("NONEXISTENT"));
        Assertions.assertEquals(Optional.of(new Node(0, "localhost", 9090, null)), (Object)REGISTRATIONS.get(0).node("INTERNAL"));
        Assertions.assertEquals(Optional.of(new Node(1, "localhost", 9091, null)), (Object)REGISTRATIONS.get(1).node("INTERNAL"));
        Assertions.assertEquals(Optional.of(new Node(2, "localhost", 9092, "myrack")), (Object)REGISTRATIONS.get(2).node("INTERNAL"));
        Assertions.assertEquals(Optional.of(new Node(3, "localhost", 9093, null)), (Object)REGISTRATIONS.get(3).node("INTERNAL"));
    }

    @Test
    public void testDirectoriesAreSorted() {
        BrokerRegistration registration = new BrokerRegistration.Builder().setId(0).setEpoch(0L).setIncarnationId(Uuid.fromString((String)"ik32HZbLTW6ulw1yyrC8jQ")).setListeners(Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9090))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)2))).setRack(Optional.empty()).setFenced(false).setInControlledShutdown(false).setDirectories(Arrays.asList(Uuid.fromString((String)"3MWIBL9NR4eXhtdfBVA7Bw"), Uuid.fromString((String)"SZQIVeLMQGiNi68StNSNZA"), Uuid.fromString((String)"LWZsWPBrQruOMMrnEBj7bw"), Uuid.fromString((String)"OpIJIaO6RKaOGvHlNmOEhA"), Uuid.fromString((String)"JhYia5HRTLihf2FFJVxopQ"), Uuid.fromString((String)"VNetSHnySxSbvjwKrBzpkw"))).build();
        Assertions.assertEquals(Arrays.asList(Uuid.fromString((String)"3MWIBL9NR4eXhtdfBVA7Bw"), Uuid.fromString((String)"JhYia5HRTLihf2FFJVxopQ"), Uuid.fromString((String)"LWZsWPBrQruOMMrnEBj7bw"), Uuid.fromString((String)"OpIJIaO6RKaOGvHlNmOEhA"), Uuid.fromString((String)"SZQIVeLMQGiNi68StNSNZA"), Uuid.fromString((String)"VNetSHnySxSbvjwKrBzpkw")), (Object)registration.directories());
    }

    @Test
    void testHasOnlineDir() {
        BrokerRegistration registration = new BrokerRegistration.Builder().setId(0).setEpoch(0L).setIncarnationId(Uuid.fromString((String)"m6CiJvfITZeKVC6UuhlZew")).setListeners(Arrays.asList(new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "localhost", 9090))).setSupportedFeatures(Collections.singletonMap("foo", VersionRange.of((short)1, (short)2))).setRack(Optional.empty()).setFenced(false).setInControlledShutdown(false).setDirectories(Arrays.asList(Uuid.fromString((String)"dir1G6EtuR1OTdAzFw1AFQ"), Uuid.fromString((String)"dir2gwpjTvKC7sMfcLNd8g"), Uuid.fromString((String)"dir3Ir8mQ0mMxfv93RITDA"))).build();
        Assertions.assertTrue((boolean)registration.hasOnlineDir(Uuid.fromString((String)"dir1G6EtuR1OTdAzFw1AFQ")));
        Assertions.assertTrue((boolean)registration.hasOnlineDir(Uuid.fromString((String)"dir2gwpjTvKC7sMfcLNd8g")));
        Assertions.assertTrue((boolean)registration.hasOnlineDir(Uuid.fromString((String)"dir3Ir8mQ0mMxfv93RITDA")));
        Assertions.assertTrue((boolean)registration.hasOnlineDir(DirectoryId.UNASSIGNED));
        Assertions.assertTrue((boolean)registration.hasOnlineDir(DirectoryId.MIGRATING));
        Assertions.assertFalse((boolean)registration.hasOnlineDir(Uuid.fromString((String)"sOwN7HH7S1maxpU1WzlzXg")));
        Assertions.assertFalse((boolean)registration.hasOnlineDir(DirectoryId.LOST));
    }
}

