/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.publisher.BrokerRegistrationTracker;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Timeout(value=40L)
public class BrokerRegistrationTrackerTest {
    static final Uuid INCARNATION_ID = Uuid.fromString((String)"jyjLbk31Tpa53pFrU9Y-Ng");
    static final Uuid A = Uuid.fromString((String)"Ahw3vXfnThqeZbb7HD1w6Q");
    static final Uuid B = Uuid.fromString((String)"BjOacT0OTNqIvUWIlKhahg");
    static final Uuid C = Uuid.fromString((String)"CVHi_iv2Rvy5_1rtPdasfg");

    @Test
    public void testTrackerName() {
        BrokerRegistrationTrackerTestContext ctx = new BrokerRegistrationTrackerTestContext();
        Assertions.assertEquals((Object)"BrokerRegistrationTracker(id=1)", (Object)ctx.tracker.name());
    }

    @Test
    public void testMetadataVersionUpdateWithoutRegistrationDoesNothing() {
        BrokerRegistrationTrackerTestContext ctx = new BrokerRegistrationTrackerTestContext();
        MetadataDelta delta = ctx.newDelta();
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_7_IV2.featureLevel()));
        ctx.onMetadataUpdate(delta);
        Assertions.assertEquals((int)0, (int)ctx.numCalls.get());
    }

    @Test
    public void testBrokerUpdateWithoutNewMvDoesNothing() {
        BrokerRegistrationTrackerTestContext ctx = new BrokerRegistrationTrackerTestContext();
        MetadataDelta delta = ctx.newDelta();
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setIncarnationId(INCARNATION_ID).setLogDirs(Arrays.asList(A, B, C)));
        ctx.onMetadataUpdate(delta);
        Assertions.assertEquals((int)0, (int)ctx.numCalls.get());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testBrokerUpdateWithNewMv(boolean jbodMv) {
        BrokerRegistrationTrackerTestContext ctx = new BrokerRegistrationTrackerTestContext();
        MetadataDelta delta = ctx.newDelta();
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setIncarnationId(INCARNATION_ID).setLogDirs(Arrays.asList(new Uuid[0])));
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(jbodMv ? MetadataVersion.IBP_3_7_IV2.featureLevel() : MetadataVersion.IBP_3_7_IV1.featureLevel()));
        ctx.onMetadataUpdate(delta);
        if (jbodMv) {
            Assertions.assertEquals((int)1, (int)ctx.numCalls.get());
        } else {
            Assertions.assertEquals((int)0, (int)ctx.numCalls.get());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testBrokerUpdateWithNewMvWithTwoDeltas(boolean jbodMv) {
        BrokerRegistrationTrackerTestContext ctx = new BrokerRegistrationTrackerTestContext();
        MetadataDelta delta = ctx.newDelta();
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setIncarnationId(INCARNATION_ID).setLogDirs(Arrays.asList(new Uuid[0])));
        ctx.onMetadataUpdate(delta);
        Assertions.assertEquals((int)0, (int)ctx.numCalls.get());
        delta = ctx.newDelta();
        delta.replay(new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(jbodMv ? MetadataVersion.IBP_3_7_IV2.featureLevel() : MetadataVersion.IBP_3_7_IV1.featureLevel()));
        ctx.onMetadataUpdate(delta);
        if (jbodMv) {
            Assertions.assertEquals((int)1, (int)ctx.numCalls.get());
        } else {
            Assertions.assertEquals((int)0, (int)ctx.numCalls.get());
        }
    }

    static class BrokerRegistrationTrackerTestContext {
        AtomicInteger numCalls = new AtomicInteger(0);
        BrokerRegistrationTracker tracker = new BrokerRegistrationTracker(1, Arrays.asList(B, A), () -> this.numCalls.incrementAndGet());
        MetadataImage image = MetadataImage.EMPTY;

        BrokerRegistrationTrackerTestContext() {
        }

        void onMetadataUpdate(MetadataDelta delta) {
            MetadataProvenance provenance = new MetadataProvenance(0L, 0, 0L);
            this.image = delta.apply(provenance);
            LogDeltaManifest manifest = new LogDeltaManifest.Builder().provenance(provenance).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(1).elapsedNs(1L).numBytes(1L).build();
            this.tracker.onMetadataUpdate(delta, this.image, (LoaderManifest)manifest);
        }

        MetadataDelta newDelta() {
            return new MetadataDelta.Builder().setImage(this.image).build();
        }
    }
}

