/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.node.ClusterImageBrokersNode;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.VersionRange;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClusterImageBrokersNodeTest {
    private static final ClusterImage TEST_IMAGE = new ClusterImage(Collections.singletonMap(1, new BrokerRegistration.Builder().setId(1).setEpoch(1001L).setIncarnationId(Uuid.fromString((String)"MJkaH0j0RwuC3W2GHQHtWA")).setListeners(Collections.emptyList()).setSupportedFeatures(Collections.singletonMap("metadata.version", VersionRange.of((int)1, (int)4))).setRack(Optional.empty()).setFenced(false).setDirectories(Arrays.asList(Uuid.fromString((String)"anCdBWcFTlu8gE1wP6bh3g"), Uuid.fromString((String)"JsnDDNVyTL289kYk6sPzig"))).setInControlledShutdown(false).build()), Collections.emptyMap());
    private static final ClusterImageBrokersNode NODE = new ClusterImageBrokersNode(TEST_IMAGE);

    @Test
    public void testChildNames() {
        Assertions.assertEquals(Arrays.asList("1"), (Object)NODE.childNames());
    }

    @Test
    public void testNode1Child() {
        MetadataNode child = NODE.child("1");
        Assertions.assertNotNull((Object)child);
        Assertions.assertEquals((Object)"BrokerRegistration(id=1, epoch=1001, incarnationId=MJkaH0j0RwuC3W2GHQHtWA, listeners=[], supportedFeatures={metadata.version: 1-4}, rack=Optional.empty, fenced=false, inControlledShutdown=false, isMigratingZkBroker=false, directories=[JsnDDNVyTL289kYk6sPzig, anCdBWcFTlu8gE1wP6bh3g])", (Object)child.stringify());
    }

    @Test
    public void testUnknownChild() {
        Assertions.assertNull((Object)NODE.child("2"));
    }
}

