/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.ZkMigrationStateRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ImageDowngradeTest {
    static final List<ApiMessageAndVersion> TEST_RECORDS = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("foo").setTopicId(Uuid.fromString((String)"5JPuABiJTPu2pQjpZWM6_A")), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(Uuid.fromString((String)"5JPuABiJTPu2pQjpZWM6_A")).setReplicas(Arrays.asList(0, 1)).setIsr(Arrays.asList(0, 1)).setLeader(0).setLeaderEpoch(1).setPartitionEpoch(2), 0));

    static ApiMessageAndVersion metadataVersionRecord(MetadataVersion metadataVersion) {
        return new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()), 0);
    }

    @Test
    public void testPremodernVersion() {
        ImageDowngradeTest.writeWithExpectedLosses(MetadataVersion.IBP_3_2_IV0, Arrays.asList("feature flag(s): foo.feature"), Arrays.asList(ImageDowngradeTest.metadataVersionRecord(MetadataVersion.IBP_3_3_IV0), TEST_RECORDS.get(0), TEST_RECORDS.get(1), new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo.feature").setFeatureLevel((short)4), 0)), Arrays.asList(TEST_RECORDS.get(0), TEST_RECORDS.get(1)));
    }

    @Test
    public void testPreControlledShutdownStateVersion() {
        ImageDowngradeTest.writeWithExpectedLosses(MetadataVersion.IBP_3_3_IV2, Arrays.asList("the inControlledShutdown state of one or more brokers"), Arrays.asList(ImageDowngradeTest.metadataVersionRecord(MetadataVersion.IBP_3_3_IV3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(123).setIncarnationId(Uuid.fromString((String)"XgjKo16hRWeWrTui0iR5Nw")).setBrokerEpoch(456L).setRack(null).setFenced(false).setInControlledShutdown(true), 1), TEST_RECORDS.get(0), TEST_RECORDS.get(1)), Arrays.asList(ImageDowngradeTest.metadataVersionRecord(MetadataVersion.IBP_3_3_IV2), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(123).setIncarnationId(Uuid.fromString((String)"XgjKo16hRWeWrTui0iR5Nw")).setBrokerEpoch(456L).setRack(null).setFenced(false), 0), TEST_RECORDS.get(0), TEST_RECORDS.get(1)));
    }

    @Test
    public void testPreZkMigrationSupportVersion() {
        ImageDowngradeTest.writeWithExpectedLosses(MetadataVersion.IBP_3_3_IV3, Arrays.asList("the isMigratingZkBroker state of one or more brokers"), Arrays.asList(ImageDowngradeTest.metadataVersionRecord(MetadataVersion.IBP_3_4_IV0), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(123).setIncarnationId(Uuid.fromString((String)"XgjKo16hRWeWrTui0iR5Nw")).setBrokerEpoch(456L).setRack(null).setFenced(false).setInControlledShutdown(true).setIsMigratingZkBroker(true), 2), TEST_RECORDS.get(0), TEST_RECORDS.get(1)), Arrays.asList(ImageDowngradeTest.metadataVersionRecord(MetadataVersion.IBP_3_3_IV3), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(123).setIncarnationId(Uuid.fromString((String)"XgjKo16hRWeWrTui0iR5Nw")).setBrokerEpoch(456L).setRack(null).setFenced(false).setInControlledShutdown(true), 1), TEST_RECORDS.get(0), TEST_RECORDS.get(1)));
    }

    @Test
    void testDirectoryAssignmentState() {
        MetadataVersion outputMetadataVersion;
        MetadataVersion inputMetadataVersion = outputMetadataVersion = MetadataVersion.IBP_3_7_IV0;
        PartitionRecord testPartitionRecord = (PartitionRecord)TEST_RECORDS.get(1).message();
        ImageDowngradeTest.writeWithExpectedLosses(outputMetadataVersion, Collections.singletonList("the directory assignment state of one or more replicas"), Arrays.asList(ImageDowngradeTest.metadataVersionRecord(inputMetadataVersion), TEST_RECORDS.get(0), new ApiMessageAndVersion((ApiMessage)testPartitionRecord.duplicate().setDirectories(Arrays.asList(Uuid.fromString((String)"c7QfSi6xSIGQVh3Qd5RJxA"), Uuid.fromString((String)"rWaCHejCRRiptDMvW5Xw0g"))), 2)), Arrays.asList(ImageDowngradeTest.metadataVersionRecord(outputMetadataVersion), new ApiMessageAndVersion((ApiMessage)new ZkMigrationStateRecord(), 0), TEST_RECORDS.get(0), new ApiMessageAndVersion((ApiMessage)testPartitionRecord.duplicate().setDirectories(Collections.emptyList()), 0)));
    }

    private static void writeWithExpectedLosses(MetadataVersion metadataVersion, List<String> expectedLosses, List<ApiMessageAndVersion> inputs, List<ApiMessageAndVersion> expectedOutputs) {
        MockLossConsumer lossConsumer = new MockLossConsumer(metadataVersion);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        RecordTestUtils.replayAll(delta, inputs);
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().setMetadataVersion(metadataVersion).setLossHandler((Consumer)lossConsumer).build());
        Assertions.assertEquals(expectedLosses, (Object)lossConsumer.losses, (String)"Failed to get expected metadata losses.");
        Assertions.assertEquals(expectedOutputs, (Object)writer.records(), (String)"Failed to get expected output records.");
    }

    static class MockLossConsumer
    implements Consumer<UnwritableMetadataException> {
        private final MetadataVersion expectedMetadataVersion;
        private final List<String> losses;

        MockLossConsumer(MetadataVersion expectedMetadataVersion) {
            this.expectedMetadataVersion = expectedMetadataVersion;
            this.losses = new ArrayList<String>();
        }

        @Override
        public void accept(UnwritableMetadataException e) {
            Assertions.assertEquals((Object)this.expectedMetadataVersion, (Object)e.metadataVersion());
            this.losses.add(e.loss());
        }
    }
}

