/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metalog.LocalLogManagerTestEnv;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.test.TestUtils;

public class QuorumControllerTestEnv
implements AutoCloseable {
    private final List<QuorumController> controllers;
    private final LocalLogManagerTestEnv logEnv;
    private final Map<Integer, MockFaultHandler> fatalFaultHandlers = new HashMap<Integer, MockFaultHandler>();
    private final Map<Integer, MockFaultHandler> nonFatalFaultHandlers = new HashMap<Integer, MockFaultHandler>();

    private QuorumControllerTestEnv(LocalLogManagerTestEnv logEnv, Consumer<QuorumController.Builder> controllerBuilderInitializer, OptionalLong sessionTimeoutMillis, OptionalLong leaderImbalanceCheckIntervalNs, boolean eligibleLeaderReplicasEnabled, BootstrapMetadata bootstrapMetadata) throws Exception {
        this.logEnv = logEnv;
        int numControllers = logEnv.logManagers().size();
        this.controllers = new ArrayList<QuorumController>(numControllers);
        try {
            List nodeIds = IntStream.range(0, numControllers).boxed().collect(Collectors.toList());
            for (int nodeId = 0; nodeId < numControllers; ++nodeId) {
                QuorumController.Builder builder = new QuorumController.Builder(nodeId, logEnv.clusterId());
                builder.setRaftClient((RaftClient)logEnv.logManagers().get(nodeId));
                builder.setBootstrapMetadata(bootstrapMetadata);
                builder.setLeaderImbalanceCheckIntervalNs(leaderImbalanceCheckIntervalNs);
                builder.setQuorumFeatures(new QuorumFeatures(nodeId, QuorumFeatures.defaultFeatureMap((boolean)true), nodeIds));
                sessionTimeoutMillis.ifPresent(timeout -> builder.setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)));
                MockFaultHandler fatalFaultHandler = new MockFaultHandler("fatalFaultHandler");
                builder.setFatalFaultHandler((FaultHandler)fatalFaultHandler);
                this.fatalFaultHandlers.put(nodeId, fatalFaultHandler);
                MockFaultHandler nonFatalFaultHandler = new MockFaultHandler("nonFatalFaultHandler");
                builder.setNonFatalFaultHandler((FaultHandler)nonFatalFaultHandler);
                builder.setEligibleLeaderReplicasEnabled(eligibleLeaderReplicasEnabled);
                this.nonFatalFaultHandlers.put(nodeId, fatalFaultHandler);
                controllerBuilderInitializer.accept(builder);
                this.controllers.add(builder.build());
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    QuorumController activeController() throws InterruptedException {
        return this.activeController(false);
    }

    QuorumController activeController(boolean waitForActivation) throws InterruptedException {
        AtomicReference<Object> value = new AtomicReference<Object>(null);
        TestUtils.retryOnExceptionWithTimeout((long)20000L, (long)3L, () -> {
            LeaderAndEpoch leader = this.logEnv.leaderAndEpoch();
            for (QuorumController controller : this.controllers) {
                if (!OptionalInt.of(controller.nodeId()).equals(leader.leaderId()) || controller.curClaimEpoch() != leader.epoch()) continue;
                value.set(controller);
                break;
            }
            if (value.get() == null) {
                throw new RuntimeException(String.format("Expected to see %s as leader", leader));
            }
        });
        if (waitForActivation) {
            try {
                ((QuorumController)value.get()).appendReadEvent("wait for activation", OptionalLong.empty(), () -> null).get(20000L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed while waiting for controller activation", t);
            }
        }
        return value.get();
    }

    public List<QuorumController> controllers() {
        return this.controllers;
    }

    public MockFaultHandler fatalFaultHandler(Integer nodeId) {
        return this.fatalFaultHandlers.get(nodeId);
    }

    public void ignoreFatalFaults() {
        for (MockFaultHandler faultHandler : this.fatalFaultHandlers.values()) {
            faultHandler.setIgnore(true);
        }
    }

    @Override
    public void close() throws InterruptedException {
        for (QuorumController controller : this.controllers) {
            controller.beginShutdown();
        }
        for (QuorumController controller : this.controllers) {
            controller.close();
        }
        for (MockFaultHandler faultHandler : this.fatalFaultHandlers.values()) {
            faultHandler.maybeRethrowFirstException();
        }
        for (MockFaultHandler faultHandler : this.nonFatalFaultHandlers.values()) {
            faultHandler.maybeRethrowFirstException();
        }
    }

    public static class Builder {
        private final LocalLogManagerTestEnv logEnv;
        private Consumer<QuorumController.Builder> controllerBuilderInitializer = __ -> {};
        private OptionalLong sessionTimeoutMillis = OptionalLong.empty();
        private OptionalLong leaderImbalanceCheckIntervalNs = OptionalLong.empty();
        private boolean eligibleLeaderReplicasEnabled = false;
        private BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.latestTesting(), (String)"test-provided version");

        public Builder(LocalLogManagerTestEnv logEnv) {
            this.logEnv = logEnv;
        }

        public Builder setControllerBuilderInitializer(Consumer<QuorumController.Builder> controllerBuilderInitializer) {
            this.controllerBuilderInitializer = controllerBuilderInitializer;
            return this;
        }

        public Builder setSessionTimeoutMillis(OptionalLong sessionTimeoutMillis) {
            this.sessionTimeoutMillis = sessionTimeoutMillis;
            return this;
        }

        public Builder setLeaderImbalanceCheckIntervalNs(OptionalLong leaderImbalanceCheckIntervalNs) {
            this.leaderImbalanceCheckIntervalNs = leaderImbalanceCheckIntervalNs;
            return this;
        }

        public Builder setBootstrapMetadata(BootstrapMetadata bootstrapMetadata) {
            this.bootstrapMetadata = bootstrapMetadata;
            return this;
        }

        public QuorumControllerTestEnv build() throws Exception {
            return new QuorumControllerTestEnv(this.logEnv, this.controllerBuilderInitializer, this.sessionTimeoutMillis, this.leaderImbalanceCheckIntervalNs, this.bootstrapMetadata.metadataVersion().isElrSupported(), this.bootstrapMetadata);
        }
    }
}

