/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collections;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.metadata.ProducerIdsRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ClusterControlManager;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.controller.FeatureControlManager;
import org.apache.kafka.controller.ProducerIdControlManager;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ProducerIdControlManagerTest {
    private ProducerIdControlManager producerIdControlManager;

    @BeforeEach
    public void setUp() {
        MockTime time = new MockTime();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        FeatureControlManager featureControl = new FeatureControlManager.Builder().setSnapshotRegistry(snapshotRegistry).setQuorumFeatures(new QuorumFeatures(0, QuorumFeatures.defaultFeatureMap((boolean)true), Collections.singletonList(0))).build();
        ClusterControlManager clusterControl = new ClusterControlManager.Builder().setTime((Time)time).setSnapshotRegistry(snapshotRegistry).setSessionTimeoutNs(1000L).setFeatureControlManager(featureControl).setBrokerUncleanShutdownHandler((brokerId, records) -> {}).build();
        clusterControl.activate();
        for (int i = 0; i < 4; ++i) {
            RegisterBrokerRecord brokerRecord = new RegisterBrokerRecord().setBrokerEpoch(100L).setBrokerId(i);
            brokerRecord.endPoints().add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setPort(9092).setName("PLAINTEXT").setHost(String.format("broker-%02d.example.org", i)));
            clusterControl.replay(brokerRecord, 100L);
        }
        this.producerIdControlManager = new ProducerIdControlManager.Builder().setClusterControlManager(clusterControl).setSnapshotRegistry(snapshotRegistry).build();
    }

    @Test
    public void testInitialResult() {
        ControllerResult result = this.producerIdControlManager.generateNextProducerId(1, 100L);
        Assertions.assertEquals((long)0L, (long)((ProducerIdsBlock)result.response()).firstProducerId());
        Assertions.assertEquals((int)1000, (int)((ProducerIdsBlock)result.response()).size());
        ProducerIdsRecord record = (ProducerIdsRecord)((ApiMessageAndVersion)result.records().get(0)).message();
        Assertions.assertEquals((long)1000L, (long)record.nextProducerId());
    }

    @Test
    public void testMonotonic() {
        this.producerIdControlManager.replay(new ProducerIdsRecord().setBrokerId(1).setBrokerEpoch(100L).setNextProducerId(42L));
        ProducerIdsBlock range = (ProducerIdsBlock)this.producerIdControlManager.generateNextProducerId(1, 100L).response();
        Assertions.assertEquals((long)42L, (long)range.firstProducerId());
        Assertions.assertThrows(RuntimeException.class, () -> this.producerIdControlManager.replay(new ProducerIdsRecord().setBrokerId(1).setBrokerEpoch(100L).setNextProducerId(40L)), (String)"Producer ID range must only increase");
        Assertions.assertThrows(RuntimeException.class, () -> this.producerIdControlManager.replay(new ProducerIdsRecord().setBrokerId(2).setBrokerEpoch(100L).setNextProducerId(42L)), (String)"Producer ID range must only increase");
        range = (ProducerIdsBlock)this.producerIdControlManager.generateNextProducerId(3, 100L).response();
        Assertions.assertEquals((long)42L, (long)range.firstProducerId());
        this.producerIdControlManager.replay(new ProducerIdsRecord().setBrokerId(1).setBrokerEpoch(100L).setNextProducerId(50L));
        range = (ProducerIdsBlock)this.producerIdControlManager.generateNextProducerId(1, 100L).response();
        Assertions.assertEquals((long)50L, (long)range.firstProducerId());
    }

    @Test
    public void testUnknownBrokerOrEpoch() {
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> this.producerIdControlManager.generateNextProducerId(99, 0L));
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> this.producerIdControlManager.generateNextProducerId(1, 99L));
    }

    @Test
    public void testMaxValue() {
        this.producerIdControlManager.replay(new ProducerIdsRecord().setBrokerId(1).setBrokerEpoch(100L).setNextProducerId(0x7FFFFFFFFFFFFFFEL));
        Assertions.assertThrows(UnknownServerException.class, () -> this.producerIdControlManager.generateNextProducerId(1, 100L));
    }

    @Test
    public void testGenerateProducerIds() {
        for (int i = 0; i < 100; ++i) {
            ProducerIdControlManagerTest.generateProducerIds(this.producerIdControlManager, i % 4, 100L);
        }
        Assertions.assertEquals((Object)new ProducerIdsBlock(3, 100000L, 1000), (Object)this.producerIdControlManager.nextProducerBlock());
    }

    static ProducerIdsBlock generateProducerIds(ProducerIdControlManager producerIdControlManager, int brokerId, long brokerEpoch) {
        ControllerResult result = producerIdControlManager.generateNextProducerId(brokerId, brokerEpoch);
        result.records().forEach(apiMessageAndVersion -> producerIdControlManager.replay((ProducerIdsRecord)apiMessageAndVersion.message()));
        return (ProducerIdsBlock)result.response();
    }
}

