/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.migration.MigrationManifest;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MigrationManifestTest {
    @Test
    public void testEmpty() {
        MockTime time = new MockTime();
        MigrationManifest.Builder manifestBuilder = MigrationManifest.newBuilder((Time)time);
        MigrationManifest manifest = manifestBuilder.build();
        Assertions.assertEquals((long)0L, (long)manifest.durationMs());
        Assertions.assertEquals((Object)"0 records were generated in 0 ms across 0 batches. The average time spent waiting on a batch was -1.00 ms. The record types were {}", (Object)manifest.toString());
    }

    @Test
    public void testOneBatch() {
        MockTime time = new MockTime();
        MigrationManifest.Builder manifestBuilder = MigrationManifest.newBuilder((Time)time);
        manifestBuilder.acceptBatch(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new TopicRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord(), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord(), 0)), 20L);
        time.sleep(10L);
        MigrationManifest manifest = manifestBuilder.build();
        Assertions.assertEquals((long)10L, (long)manifest.durationMs());
        Assertions.assertEquals((Object)"13 records were generated in 10 ms across 1 batches. The average time spent waiting on a batch was 0.00 ms. The record types were {TOPIC_RECORD=2, PARTITION_RECORD=9, CONFIG_RECORD=2}", (Object)manifest.toString());
    }

    @Test
    public void testManyBatch() {
        MockTime time = new MockTime();
        MigrationManifest.Builder manifestBuilder = MigrationManifest.newBuilder((Time)time);
        manifestBuilder.acceptBatch(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0)), 20000000L);
        manifestBuilder.acceptBatch(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new TopicRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord(), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord(), 0)), 20000000L);
        manifestBuilder.acceptBatch(Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new ConfigRecord(), 0)), 5000000L);
        time.sleep(60L);
        MigrationManifest manifest = manifestBuilder.build();
        Assertions.assertEquals((long)60L, (long)manifest.durationMs());
        Assertions.assertEquals((Object)"13 records were generated in 60 ms across 3 batches. The average time spent waiting on a batch was 15.00 ms. The record types were {TOPIC_RECORD=2, PARTITION_RECORD=9, CONFIG_RECORD=2}", (Object)manifest.toString());
    }
}

