/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Timeout(value=40L)
public class PartitionRegistrationTest {
    @Test
    public void testElectionWasClean() {
        Assertions.assertTrue((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[]{1, 2}));
        Assertions.assertFalse((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[]{0, 2}));
        Assertions.assertFalse((boolean)PartitionRegistration.electionWasClean((int)1, (int[])new int[0]));
        Assertions.assertTrue((boolean)PartitionRegistration.electionWasClean((int)3, (int[])new int[]{1, 2, 3, 4, 5, 6}));
    }

    @Test
    public void testPartitionControlInfoMergeAndDiff() {
        PartitionRegistration a = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{1, 2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        PartitionRegistration b = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{3}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(1)).build();
        PartitionRegistration c = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{1}).setLastKnownElr(new int[]{3}).setElr(new int[]{2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(1)).build();
        Assertions.assertEquals((Object)b, (Object)a.merge(new PartitionChangeRecord().setLeader(3).setIsr(Arrays.asList(3))));
        Assertions.assertEquals((Object)"isr: [1, 2] -> [3], leader: 1 -> 3, leaderEpoch: 0 -> 1, partitionEpoch: 0 -> 1", (Object)b.diff(a));
        Assertions.assertEquals((Object)"isr: [1, 2] -> [1], elr: [] -> [2], lastKnownElr: [] -> [3], partitionEpoch: 0 -> 1", (Object)c.diff(a));
    }

    @Test
    public void testRecordRoundTrip() {
        PartitionRegistration registrationA = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.migratingArray((int)3)).setIsr(new int[]{1, 2}).setRemovingReplicas(new int[]{1}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build();
        Uuid topicId = Uuid.fromString((String)"OGdAI5nxT_m-ds3rJMqPLA");
        int partitionId = 4;
        ApiMessageAndVersion record = registrationA.toRecord(topicId, partitionId, new ImageWriterOptions.Builder().setMetadataVersion(MetadataVersion.IBP_3_7_IV0).build());
        PartitionRegistration registrationB = new PartitionRegistration((PartitionRecord)record.message());
        Assertions.assertEquals((Object)registrationA, (Object)registrationB);
    }

    @Test
    public void testToLeaderAndIsrPartitionState() {
        PartitionRegistration a = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"NSmkU0ieQuy2IHN59Ce0Bw"), Uuid.fromString((String)"Y8N9gnSKSLKKFCioX2laGA"), Uuid.fromString((String)"Oi7nvb8KQPyaGEqr4JtCRw")}).setIsr(new int[]{1, 2}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(123)).setPartitionEpoch(Integer.valueOf(456)).build();
        PartitionRegistration b = new PartitionRegistration.Builder().setReplicas(new int[]{2, 3, 4}).setDirectories(new Uuid[]{Uuid.fromString((String)"tAn3q03aQAWEYkNajXm3lA"), Uuid.fromString((String)"zgj8rqatTmWMyWBsRZyiVg"), Uuid.fromString((String)"bAAlGAz1TN2doZjtWlvhRQ")}).setIsr(new int[]{2, 3, 4}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(234)).setPartitionEpoch(Integer.valueOf(567)).build();
        Assertions.assertEquals((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("foo").setPartitionIndex(1).setControllerEpoch(-1).setLeader(1).setLeaderEpoch(123).setIsr(Arrays.asList(1, 2)).setPartitionEpoch(456).setReplicas(Arrays.asList(1, 2, 3)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()).setIsNew(true).toString(), (Object)a.toLeaderAndIsrPartitionState(new TopicPartition("foo", 1), true).toString());
        Assertions.assertEquals((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("bar").setPartitionIndex(0).setControllerEpoch(-1).setLeader(2).setLeaderEpoch(234).setIsr(Arrays.asList(2, 3, 4)).setPartitionEpoch(567).setReplicas(Arrays.asList(2, 3, 4)).setAddingReplicas(Collections.emptyList()).setRemovingReplicas(Collections.emptyList()).setIsNew(false).toString(), (Object)b.toLeaderAndIsrPartitionState(new TopicPartition("bar", 0), false).toString());
    }

    @Test
    public void testMergePartitionChangeRecordWithReassignmentData() {
        Uuid dir1 = Uuid.fromString((String)"FbRuu7CeQtq5YFreEzg16g");
        Uuid dir2 = Uuid.fromString((String)"4rtHTelWSSStAFMODOg3cQ");
        Uuid dir3 = Uuid.fromString((String)"Id1WXzHURROilVxZWJNZlw");
        PartitionRegistration partition0 = new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setDirectories(new Uuid[]{dir1, dir2, dir3}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionRegistration partition1 = partition0.merge(new PartitionChangeRecord().setRemovingReplicas(Collections.singletonList(3)).setAddingReplicas(Collections.singletonList(4)).setReplicas(Arrays.asList(1, 2, 3, 4)).setDirectories(Arrays.asList(dir1, dir2, dir3, DirectoryId.UNASSIGNED)));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4}).setDirectories(new Uuid[]{dir1, dir2, dir3, DirectoryId.UNASSIGNED}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{3}).setAddingReplicas(new int[]{4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).build(), (Object)partition1);
        PartitionRegistration partition2 = partition1.merge(new PartitionChangeRecord().setIsr(Arrays.asList(1, 2, 4)).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setReplicas(Arrays.asList(1, 2, 4)).setDirectories(Arrays.asList(dir1, dir2, DirectoryId.UNASSIGNED)));
        Assertions.assertEquals((Object)new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 4}).setDirectories(new Uuid[]{dir1, dir2, DirectoryId.UNASSIGNED}).setIsr(new int[]{1, 2, 4}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(202)).build(), (Object)partition2);
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingReplicas() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder();
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set replicas.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingIsr() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setDirectories(new Uuid[]{DirectoryId.UNASSIGNED});
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set isr.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLeader() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setDirectories(new Uuid[]{DirectoryId.LOST}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0});
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set leader.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLeaderRecoveryState() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setDirectories(new Uuid[]{DirectoryId.MIGRATING}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(0));
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set leader recovery state.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingLeaderEpoch() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setDirectories(new Uuid[]{Uuid.fromString((String)"OP4I696sRmCPanlNidxJYw")}).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set leader epoch.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderThrowsIllegalStateExceptionWhenMissingPartitionEpoch() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0}).setDirectories(DirectoryId.migratingArray((int)1)).setIsr(new int[]{0}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{0}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0));
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> builder.build());
        Assertions.assertEquals((Object)"You must set partition epoch.", (Object)exception.getMessage());
    }

    @Test
    public void testBuilderSuccess() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(DirectoryId.unassignedArray((int)3)).setIsr(new int[]{0, 1}).setElr(new int[]{2}).setLastKnownElr(new int[]{0, 1, 2}).setRemovingReplicas(new int[]{0}).setAddingReplicas(new int[]{1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0, 1, 2}), (Object)Replicas.toList((int[])partitionRegistration.replicas));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0, 1}), (Object)Replicas.toList((int[])partitionRegistration.isr));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{2}), (Object)Replicas.toList((int[])partitionRegistration.elr));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0, 1, 2}), (Object)Replicas.toList((int[])partitionRegistration.lastKnownElr));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{0}), (Object)Replicas.toList((int[])partitionRegistration.removingReplicas));
        Assertions.assertEquals((Object)Replicas.toList((int[])new int[]{1}), (Object)Replicas.toList((int[])partitionRegistration.addingReplicas));
        Assertions.assertEquals((int)0, (int)partitionRegistration.leader);
        Assertions.assertEquals((Object)LeaderRecoveryState.RECOVERED, (Object)partitionRegistration.leaderRecoveryState);
        Assertions.assertEquals((int)0, (int)partitionRegistration.leaderEpoch);
        Assertions.assertEquals((int)0, (int)partitionRegistration.partitionEpoch);
    }

    @Test
    public void testBuilderSetsDefaultAddingAndRemovingReplicas() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1}).setDirectories(DirectoryId.migratingArray((int)2)).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.removingReplicas));
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.addingReplicas));
    }

    private static Stream<Arguments> metadataVersionsForTestPartitionRegistration() {
        return Arrays.asList(MetadataVersion.IBP_3_7_IV1, MetadataVersion.IBP_3_7_IV2, MetadataVersion.IBP_3_8_IV0).stream().map(mv -> Arguments.of((Object[])new Object[]{mv}));
    }

    @ParameterizedTest
    @MethodSource(value={"metadataVersionsForTestPartitionRegistration"})
    public void testPartitionRegistrationToRecord(MetadataVersion metadataVersion) {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setDirectories(new Uuid[]{DirectoryId.UNASSIGNED, Uuid.fromString((String)"KBJBm9GVRAG9Ffe25odmmg"), DirectoryId.LOST, Uuid.fromString((String)"7DZNT5qBS7yFF7VMMHS7kw"), Uuid.fromString((String)"cJGPUZsMSEqbidOLYLOIXg")}).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).setElr(new int[]{2, 3}).setLastKnownElr(new int[]{4});
        PartitionRegistration partitionRegistration = builder.build();
        Uuid topicID = Uuid.randomUuid();
        PartitionRecord expectRecord = new PartitionRecord().setTopicId(topicID).setPartitionId(0).setReplicas(Arrays.asList(0, 1, 2, 3, 4)).setIsr(Arrays.asList(0, 1)).setLeader(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()).setLeaderEpoch(0).setPartitionEpoch(0);
        if (metadataVersion.isElrSupported()) {
            expectRecord.setEligibleLeaderReplicas(Arrays.asList(2, 3)).setLastKnownELR(Arrays.asList(4));
        }
        if (metadataVersion.isDirectoryAssignmentSupported()) {
            expectRecord.setDirectories(Arrays.asList(DirectoryId.UNASSIGNED, Uuid.fromString((String)"KBJBm9GVRAG9Ffe25odmmg"), DirectoryId.LOST, Uuid.fromString((String)"7DZNT5qBS7yFF7VMMHS7kw"), Uuid.fromString((String)"cJGPUZsMSEqbidOLYLOIXg")));
        }
        ArrayList exceptions = new ArrayList();
        ImageWriterOptions options = new ImageWriterOptions.Builder().setMetadataVersion(metadataVersion).setLossHandler(exceptions::add).build();
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)expectRecord, metadataVersion.partitionRecordVersion()), (Object)partitionRegistration.toRecord(topicID, 0, options));
        if (!metadataVersion.isDirectoryAssignmentSupported()) {
            Assertions.assertTrue((boolean)exceptions.stream().anyMatch(e -> e.getMessage().contains("the directory assignment state of one or more replicas")));
        }
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.addingReplicas));
    }

    @Test
    public void testPartitionRegistrationToRecord_ElrShouldBeNullIfEmpty() {
        PartitionRegistration.Builder builder = new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2, 3, 4}).setDirectories(DirectoryId.migratingArray((int)5)).setIsr(new int[]{0, 1}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0));
        PartitionRegistration partitionRegistration = builder.build();
        Uuid topicID = Uuid.randomUuid();
        PartitionRecord expectRecord = new PartitionRecord().setTopicId(topicID).setPartitionId(0).setReplicas(Arrays.asList(0, 1, 2, 3, 4)).setIsr(Arrays.asList(0, 1)).setLeader(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()).setLeaderEpoch(0).setDirectories(Arrays.asList(DirectoryId.migratingArray((int)5))).setPartitionEpoch(0);
        ArrayList exceptions = new ArrayList();
        ImageWriterOptions options = new ImageWriterOptions.Builder().setMetadataVersion(MetadataVersion.IBP_3_8_IV0).setLossHandler(exceptions::add).build();
        Assertions.assertEquals((Object)new ApiMessageAndVersion((ApiMessage)expectRecord, 2), (Object)partitionRegistration.toRecord(topicID, 0, options));
        Assertions.assertEquals((Object)Replicas.toList((int[])Replicas.NONE), (Object)Replicas.toList((int[])partitionRegistration.addingReplicas));
        Assertions.assertTrue((boolean)exceptions.isEmpty());
    }

    @Property
    public void testConsistentEqualsAndHashCode(@ForAll(value="uniqueSamples") PartitionRegistration a, @ForAll(value="uniqueSamples") PartitionRegistration b) {
        if (a.equals((Object)b)) {
            Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode(), (String)("a=" + a + "\nb=" + b));
        }
        if (a.hashCode() != b.hashCode()) {
            Assertions.assertNotEquals((Object)a, (Object)b, (String)("a=" + a + "\nb=" + b));
        }
    }

    @Provide
    Arbitrary<PartitionRegistration> uniqueSamples() {
        return Arbitraries.of((Object[])new PartitionRegistration[]{new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"HyTsxr8hT6Gq5heZMA2Bug"), Uuid.fromString((String)"ePwTiSgFRvaKRBaUX3EcZQ"), Uuid.fromString((String)"F3zwSDR1QWGKNNLMowVoYg")}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setElr(new int[]{1, 2, 3}).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"94alcrMLQ6GOV8EHfAxJnA"), Uuid.fromString((String)"LlD2QCA5RpalzKwPsUTGpw"), Uuid.fromString((String)"Ahfjx9j5SIKpmz48pTLFRg")}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(101)).setPartitionEpoch(Integer.valueOf(200)).setLastKnownElr(new int[]{1, 2}).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"KcXLjTpYSPGjM20DjHd5rA"), Uuid.fromString((String)"NXiBSMNHSvWqvz3qM8a6Vg"), Uuid.fromString((String)"yWinzh1DRD25nHuXUxLfBQ")}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(201)).setElr(new int[]{1, 2}).setLastKnownElr(new int[]{1, 2}).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1, 2, 3}).setDirectories(new Uuid[]{Uuid.fromString((String)"9bDLWtoRRaKUToKixl3NUg"), Uuid.fromString((String)"nLJMwhSUTEOU7DEI0U2GOw"), Uuid.fromString((String)"ULAltTBAQlG2peJh9DZZrw")}).setLeader(Integer.valueOf(2)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setLastKnownElr(new int[]{1, 2}).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3}).setIsr(new int[]{1}).setDirectories(new Uuid[]{Uuid.fromString((String)"kWM0QcMoRg6BHc7sdVsjZg"), Uuid.fromString((String)"84F4VbPGTRWewKhlCYctbQ"), Uuid.fromString((String)"W505iUM0S6a5Ds83d1WjcQ")}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERING).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{4, 5, 6}).setAddingReplicas(new int[]{1, 2, 3}).setDirectories(DirectoryId.unassignedArray((int)6)).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setElr(new int[]{1, 2, 3}).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{1, 2, 3}).setAddingReplicas(new int[]{4, 5, 6}).setDirectories(DirectoryId.migratingArray((int)6)).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setLastKnownElr(new int[]{1, 2}).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setRemovingReplicas(new int[]{1, 3}).setDirectories(DirectoryId.unassignedArray((int)6)).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setElr(new int[]{1, 2, 3}).build(), new PartitionRegistration.Builder().setReplicas(new int[]{1, 2, 3, 4, 5, 6}).setIsr(new int[]{1, 2, 3}).setAddingReplicas(new int[]{4, 5, 6}).setDirectories(DirectoryId.migratingArray((int)6)).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).setElr(new int[]{2, 3}).setLastKnownElr(new int[]{1, 2}).build()});
    }

    @Test
    public void testDirectories() {
        PartitionRegistration partitionRegistration = new PartitionRegistration.Builder().setReplicas(new int[]{3, 2, 1}).setDirectories(new Uuid[]{Uuid.fromString((String)"FbRuu7CeQtq5YFreEzg16g"), Uuid.fromString((String)"4rtHTelWSSStAFMODOg3cQ"), Uuid.fromString((String)"Id1WXzHURROilVxZWJNZlw")}).setIsr(new int[]{1, 2, 3}).setLeader(Integer.valueOf(1)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        Assertions.assertEquals((Object)Uuid.fromString((String)"Id1WXzHURROilVxZWJNZlw"), (Object)partitionRegistration.directory(1));
        Assertions.assertEquals((Object)Uuid.fromString((String)"4rtHTelWSSStAFMODOg3cQ"), (Object)partitionRegistration.directory(2));
        Assertions.assertEquals((Object)Uuid.fromString((String)"FbRuu7CeQtq5YFreEzg16g"), (Object)partitionRegistration.directory(3));
        Assertions.assertThrows(IllegalArgumentException.class, () -> partitionRegistration.directory(4));
    }

    @Test
    public void testMigratingRecordDirectories() {
        PartitionRecord record = new PartitionRecord().setTopicId(Uuid.fromString((String)"ONlQ7DDzQtGESsG499UDQg")).setPartitionId(0).setReplicas(Arrays.asList(0, 1)).setIsr(Arrays.asList(0, 1)).setLeader(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value()).setLeaderEpoch(0).setPartitionEpoch(0);
        PartitionRegistration registration = new PartitionRegistration(record);
        Assertions.assertArrayEquals((Object[])new Uuid[]{DirectoryId.MIGRATING, DirectoryId.MIGRATING}, (Object[])registration.directories);
    }
}

