/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.PartitionReassignmentRevert;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionReassignmentRevertTest {
    @Test
    public void testNoneAddedOrRemoved() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{3, 2, 1}).setIsr(new int[]{3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"Qln01zZAQMKzFTRCw22Y4w"), Uuid.fromString((String)"jjUcnIL2TxWEGMZ1mHvkPA"), Uuid.fromString((String)"JSZNFA0uQFmH1N75hQxWug")}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3, 2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testSomeRemoving() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{3, 2, 1}).setIsr(new int[]{3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"WG58zlb5RR6TqdI81SCXeA"), Uuid.fromString((String)"izoB1H6TQdOExQ4XNMNXeQ"), Uuid.fromString((String)"TluNaJDjRemuy17sO7dDKg")}).setRemovingReplicas(new int[]{2, 1}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3, 2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testSomeAdding() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{4, 5, 3, 2, 1}).setIsr(new int[]{4, 5, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"gR9P3R9NQ5GhtewattwuZw"), Uuid.fromString((String)"vzgieGUjSr6vPvl3ZAWQcg"), Uuid.fromString((String)"8UWF5CQfQDqSyzcChmbrgw"), Uuid.fromString((String)"X3J9b4K5TumAM5a3YOKk2w"), Uuid.fromString((String)"LjZGhHfFRSCSCQw42dLlNA")}).setAddingReplicas(new int[]{4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testSomeRemovingAndAdding() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{4, 5, 3, 2, 1}).setIsr(new int[]{4, 5, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"IHR5DKGdQju05pbDpwfdbA"), Uuid.fromString((String)"9zsVmGReTDOAyuPEtp58Cw"), Uuid.fromString((String)"bsUouEfRSLi50Pj3nqke2A"), Uuid.fromString((String)"8l9R5BMcQZGbICOXPmxZNw"), Uuid.fromString((String)"3n5Gwv8jRMiIFMgoTxVCdA")}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(2), (Object)revert.isr());
        Assertions.assertFalse((boolean)revert.unclean());
    }

    @Test
    public void testIsrSpecialCase() {
        PartitionRegistration registration = new PartitionRegistration.Builder().setReplicas(new int[]{4, 5, 3, 2, 1}).setIsr(new int[]{4, 5}).setDirectories(new Uuid[]{Uuid.fromString((String)"1oXnuHL6T8y7yMtEP4FSdg"), Uuid.fromString((String)"3ddu6izxT2aCpQrA3C2bjw"), Uuid.fromString((String)"WvCpqmaZTaSbifd43Vl2Xg"), Uuid.fromString((String)"n0cmj6NgTaahRMwa75FnRA"), Uuid.fromString((String)"S2mDcyiAQAe92ZrlyodaDw")}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{4, 5}).setLeader(Integer.valueOf(3)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(100)).setPartitionEpoch(Integer.valueOf(200)).build();
        PartitionReassignmentRevert revert = new PartitionReassignmentRevert(registration);
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)revert.replicas());
        Assertions.assertEquals(Arrays.asList(3), (Object)revert.isr());
        Assertions.assertTrue((boolean)revert.unclean());
    }
}

