/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class PartitionReassignmentReplicasTest {
    @Test
    public void testNoneAddedOrRemoved() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1)), new PartitionAssignment(Arrays.asList(3, 2, 1)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 2, 1), (Object)replicas.replicas());
    }

    @Test
    public void testAdditions() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1)), new PartitionAssignment(Arrays.asList(3, 6, 2, 1, 5)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(5, 6), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 6, 2, 1, 5), (Object)replicas.replicas());
    }

    @Test
    public void testRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1, 0)), new PartitionAssignment(Arrays.asList(3, 1)));
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(3, 1, 0, 2), (Object)replicas.replicas());
    }

    @Test
    public void testAdditionsAndRemovals() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1, 0)), new PartitionAssignment(Arrays.asList(7, 3, 1, 9)));
        Assertions.assertEquals(Arrays.asList(0, 2), (Object)replicas.removing());
        Assertions.assertEquals(Arrays.asList(7, 9), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(7, 3, 1, 9, 0, 2), (Object)replicas.replicas());
    }

    @Test
    public void testRearrangement() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(3, 2, 1, 0)), new PartitionAssignment(Arrays.asList(0, 1, 3, 2)));
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.removing());
        Assertions.assertEquals(Collections.emptyList(), (Object)replicas.adding());
        Assertions.assertEquals(Arrays.asList(0, 1, 3, 2), (Object)replicas.replicas());
    }

    @Test
    public void testDoesNotCompleteReassignment() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2)), new PartitionAssignment(Arrays.asList(3, 4, 5)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2, 3, 4));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testDoesNotCompleteReassignmentIfNoneOngoing() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(Collections.emptyList(), Collections.emptyList(), Arrays.asList(0, 1, 2));
        Assertions.assertFalse((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2));
        Assertions.assertFalse((boolean)reassignmentOptional.isPresent());
    }

    @Test
    public void testDoesCompleteReassignmentAllNewReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2)), new PartitionAssignment(Arrays.asList(3, 4, 5)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2, 3, 4, 5));
        Assertions.assertTrue((boolean)reassignmentOptional.isPresent());
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = (PartitionReassignmentReplicas.CompletedReassignment)reassignmentOptional.get();
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)completedReassignment.isr);
        Assertions.assertEquals(Arrays.asList(3, 4, 5), (Object)completedReassignment.replicas);
    }

    @Test
    public void testDoesCompleteReassignmentSomeNewReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2)), new PartitionAssignment(Arrays.asList(0, 1, 3)));
        Assertions.assertTrue((boolean)replicas.isReassignmentInProgress());
        Optional reassignmentOptional = replicas.maybeCompleteReassignment(Arrays.asList(0, 1, 2, 3));
        Assertions.assertTrue((boolean)reassignmentOptional.isPresent());
        PartitionReassignmentReplicas.CompletedReassignment completedReassignment = (PartitionReassignmentReplicas.CompletedReassignment)reassignmentOptional.get();
        Assertions.assertEquals(Arrays.asList(0, 1, 3), (Object)completedReassignment.isr);
        Assertions.assertEquals(Arrays.asList(0, 1, 3), (Object)completedReassignment.replicas);
    }

    @Test
    public void testIsReassignmentInProgress() {
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"HEKOeWDdQOqr2cmHrnjqjA"), Uuid.fromString((String)"I8kmmcM5TjOwNFnGvJLCjA"), Uuid.fromString((String)"x8osEoRkQdupZNYpU5c3Lw"), Uuid.fromString((String)"OT6qgtRqTiuiX8EikvAVow")}).setIsr(new int[]{0, 1, 3, 2}).setRemovingReplicas(new int[]{2}).setAddingReplicas(new int[]{3}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"QrbOddSYQg6JgFu7hLvOTg"), Uuid.fromString((String)"S585FNNoSmiSH6ZYCrNqCg"), Uuid.fromString((String)"wjT5ieLARfKYMWIzTFwcag"), Uuid.fromString((String)"qzX9qWPVTWuLbiEQL0cgeg")}).setIsr(new int[]{0, 1, 3, 2}).setRemovingReplicas(new int[]{2}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
        Assertions.assertTrue((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 3, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"QIyJnfdUSz6laFLCgj3AjA"), Uuid.fromString((String)"1QIvvBx2QVqNw2dsnYXUZg"), Uuid.fromString((String)"yPvPnGrxR0q8KC2Q5k0FIg"), Uuid.fromString((String)"a0lnxzleTcWVf1IyalE9cA")}).setIsr(new int[]{0, 1, 3, 2}).setAddingReplicas(new int[]{3}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
        Assertions.assertFalse((boolean)PartitionReassignmentReplicas.isReassignmentInProgress((PartitionRegistration)new PartitionRegistration.Builder().setReplicas(new int[]{0, 1, 2}).setDirectories(new Uuid[]{Uuid.fromString((String)"I4qCCBe9TYGOB0xvmvTI7w"), Uuid.fromString((String)"JvzGem0nTxiNPM5jIzNzlA"), Uuid.fromString((String)"EfWjZ2EsSKSvEn9PkG7lWQ")}).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(0)).setPartitionEpoch(Integer.valueOf(0)).build()));
    }

    @Test
    public void testOriginalReplicas() {
        PartitionReassignmentReplicas replicas = new PartitionReassignmentReplicas(new PartitionAssignment(Arrays.asList(0, 1, 2)), new PartitionAssignment(Arrays.asList(0, 1, 3)));
        Assertions.assertEquals(Arrays.asList(0, 1, 2), (Object)replicas.originalReplicas());
    }
}

