/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.controller.AclControlManager;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;

public class MockAclMutator
implements AclMutator {
    private final StandardAuthorizer authorizer;
    private final AclControlManager aclControl;

    public MockAclMutator(StandardAuthorizer authorizer) {
        this.authorizer = authorizer;
        this.aclControl = new AclControlManager.Builder().build();
    }

    private void syncIdToAcl(Map<Uuid, StandardAcl> prevIdToAcl, Map<Uuid, StandardAcl> nextIdToAcl) {
        for (Map.Entry<Uuid, StandardAcl> entry : prevIdToAcl.entrySet()) {
            if (entry.getValue().equals((Object)nextIdToAcl.get(entry.getKey()))) continue;
            this.authorizer.removeAcl(entry.getKey());
        }
        for (Map.Entry<Uuid, StandardAcl> entry : nextIdToAcl.entrySet()) {
            if (entry.getValue().equals((Object)prevIdToAcl.get(entry.getKey()))) continue;
            this.authorizer.addAcl(entry.getKey(), entry.getValue());
        }
    }

    public synchronized CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings) {
        HashMap<Uuid, StandardAcl> prevIdToAcl = new HashMap<Uuid, StandardAcl>(this.aclControl.idToAcl());
        ControllerResult result = this.aclControl.createAcls(aclBindings);
        RecordTestUtils.replayAll(this.aclControl, result.records());
        this.syncIdToAcl(prevIdToAcl, this.aclControl.idToAcl());
        return CompletableFuture.completedFuture(result.response());
    }

    public synchronized CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> aclBindingFilters) {
        HashMap<Uuid, StandardAcl> prevIdToAcl = new HashMap<Uuid, StandardAcl>(this.aclControl.idToAcl());
        ControllerResult result = this.aclControl.deleteAcls(aclBindingFilters);
        RecordTestUtils.replayAll(this.aclControl, result.records());
        this.syncIdToAcl(prevIdToAcl, this.aclControl.idToAcl());
        return CompletableFuture.completedFuture(result.response());
    }
}

