/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.properties;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public final class PropertiesUtilsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadPropertiesFile() throws IOException {
        File tempFile = TestUtils.tempFile();
        try {
            String testContent = "a=1\nb=2\n#a comment\n\nc=3\nd=";
            Files.write(tempFile.toPath(), testContent.getBytes(), new OpenOption[0]);
            Properties props = PropertiesUtils.readPropertiesFile((String)tempFile.getAbsolutePath());
            Assertions.assertEquals((int)4, (int)props.size());
            Assertions.assertEquals((Object)"1", (Object)props.get("a"));
            Assertions.assertEquals((Object)"2", (Object)props.get("b"));
            Assertions.assertEquals((Object)"3", (Object)props.get("c"));
            Assertions.assertEquals((Object)"", (Object)props.get("d"));
        }
        finally {
            Files.deleteIfExists(tempFile.toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testWritePropertiesFile(boolean fsync) throws IOException {
        File tempFile = TestUtils.tempFile();
        try {
            Properties props = new Properties();
            props.setProperty("abc", "123");
            props.setProperty("def", "456");
            PropertiesUtils.writePropertiesFile((Properties)props, (String)tempFile.getAbsolutePath(), (boolean)fsync);
            Properties props2 = PropertiesUtils.readPropertiesFile((String)tempFile.getAbsolutePath());
            Assertions.assertEquals((Object)props, (Object)props2);
        }
        finally {
            Files.deleteIfExists(tempFile.toPath());
        }
    }

    @Test
    public void loadRequiredIntProp() throws IOException {
        Properties props = new Properties();
        props.setProperty("foo.bar", "123");
        Assertions.assertEquals((int)123, (int)PropertiesUtils.loadRequiredIntProp((Properties)props, (String)"foo.bar"));
    }

    @Test
    public void loadMissingRequiredIntProp() throws IOException {
        Properties props = new Properties();
        Assertions.assertEquals((Object)"Failed to find foo.bar", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> PropertiesUtils.loadRequiredIntProp((Properties)props, (String)"foo.bar"))).getMessage());
    }

    @Test
    public void loadNonIntegerRequiredIntProp() throws IOException {
        Properties props = new Properties();
        props.setProperty("foo.bar", "b");
        Assertions.assertEquals((Object)"Unable to read foo.bar as a base-10 number.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> PropertiesUtils.loadRequiredIntProp((Properties)props, (String)"foo.bar"))).getMessage());
    }
}

