/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.properties;

import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class MetaPropertiesVersionTest {
    @Test
    public void testV0ToNumber() {
        Assertions.assertEquals((int)0, (int)MetaPropertiesVersion.V0.number());
    }

    @Test
    public void testV0ToNumberString() {
        Assertions.assertEquals((Object)"0", (Object)MetaPropertiesVersion.V0.numberString());
    }

    @Test
    public void testV0FromNumber() {
        Assertions.assertEquals((Object)MetaPropertiesVersion.V0, (Object)MetaPropertiesVersion.fromNumber((int)0));
    }

    @Test
    public void testV0FromNumberString() {
        Assertions.assertEquals((Object)MetaPropertiesVersion.V0, (Object)MetaPropertiesVersion.fromNumberString((String)"0"));
    }

    @Test
    public void testV1ToNumber() {
        Assertions.assertEquals((int)1, (int)MetaPropertiesVersion.V1.number());
    }

    @Test
    public void testV1ToNumberString() {
        Assertions.assertEquals((Object)"1", (Object)MetaPropertiesVersion.V1.numberString());
    }

    @Test
    public void testV1FromNumber() {
        Assertions.assertEquals((Object)MetaPropertiesVersion.V1, (Object)MetaPropertiesVersion.fromNumber((int)1));
    }

    @Test
    public void testV1FromNumberString() {
        Assertions.assertEquals((Object)MetaPropertiesVersion.V1, (Object)MetaPropertiesVersion.fromNumberString((String)"1"));
    }

    @Test
    public void testFromInvalidNumber() {
        Assertions.assertEquals((Object)"Unknown meta.properties version number 2", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> MetaPropertiesVersion.fromNumber((int)2))).getMessage());
    }

    @Test
    public void testFromInvalidString() {
        Assertions.assertEquals((Object)"Invalid meta.properties version string 'orange'", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> MetaPropertiesVersion.fromNumberString((String)"orange"))).getMessage());
    }

    @Test
    public void testHasBrokerId() {
        Assertions.assertTrue((boolean)MetaPropertiesVersion.V0.hasBrokerId());
        Assertions.assertFalse((boolean)MetaPropertiesVersion.V1.hasBrokerId());
    }

    @Test
    public void testAlwaysHasNodeId() {
        Assertions.assertFalse((boolean)MetaPropertiesVersion.V0.alwaysHasNodeId());
        Assertions.assertTrue((boolean)MetaPropertiesVersion.V1.alwaysHasNodeId());
    }

    @Test
    public void testAlwaysHasClusterId() {
        Assertions.assertFalse((boolean)MetaPropertiesVersion.V0.alwaysHasClusterId());
        Assertions.assertTrue((boolean)MetaPropertiesVersion.V1.alwaysHasClusterId());
    }
}

