/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.properties;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class MetaPropertiesTest {
    @Test
    public void testV0SerializationWithNothing() {
        this.testV0Serialization(Optional.empty(), OptionalInt.empty(), Optional.empty(), "MetaProperties(version=0)");
    }

    @Test
    public void testV0SerializationWithJustClusterId() {
        this.testV0Serialization(Optional.of("zd2vLVrZQlCLJj8-k7A10w"), OptionalInt.empty(), Optional.empty(), "MetaProperties(version=0, clusterId=zd2vLVrZQlCLJj8-k7A10w)");
    }

    @Test
    public void testV0SerializationWithJustNodeId() {
        this.testV0Serialization(Optional.empty(), OptionalInt.of(0), Optional.empty(), "MetaProperties(version=0, nodeId=0)");
    }

    @Test
    public void testV0SerializationWithJustClusterIdAndNodeId() {
        this.testV0Serialization(Optional.of("zd2vLVrZQlCLJj8-k7A10w"), OptionalInt.of(0), Optional.empty(), "MetaProperties(version=0, clusterId=zd2vLVrZQlCLJj8-k7A10w, nodeId=0)");
    }

    @Test
    public void testV0SerializationWithAll() {
        this.testV0Serialization(Optional.of("zd2vLVrZQlCLJj8-k7A10w"), OptionalInt.of(0), Optional.of(Uuid.fromString((String)"3Adc4FjfTeypRWROmQDNIQ")), "MetaProperties(version=0, clusterId=zd2vLVrZQlCLJj8-k7A10w, nodeId=0, directoryId=3Adc4FjfTeypRWROmQDNIQ)");
    }

    private void testV0Serialization(Optional<String> clusterId, OptionalInt nodeId, Optional<Uuid> directoryId, String expectedToStringOutput) {
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V0).setClusterId(clusterId).setNodeId(nodeId).setDirectoryId(directoryId).build();
        Assertions.assertEquals((Object)MetaPropertiesVersion.V0, (Object)metaProperties.version());
        Assertions.assertEquals(clusterId, (Object)metaProperties.clusterId());
        Assertions.assertEquals((Object)nodeId, (Object)metaProperties.nodeId());
        Assertions.assertEquals(directoryId, (Object)metaProperties.directoryId());
        Properties props = new Properties();
        props.setProperty("version", "0");
        if (clusterId.isPresent()) {
            props.setProperty("cluster.id", clusterId.get());
        }
        if (nodeId.isPresent()) {
            props.setProperty("broker.id", "" + nodeId.getAsInt());
        }
        if (directoryId.isPresent()) {
            props.setProperty("directory.id", directoryId.get().toString());
        }
        Properties props2 = metaProperties.toProperties();
        Assertions.assertEquals((Object)props, (Object)props2);
        MetaProperties metaProperties2 = new MetaProperties.Builder(props2).build();
        System.out.println("metaProperties = " + metaProperties.toString());
        System.out.println("metaProperties2 = " + metaProperties2.toString());
        Assertions.assertEquals((Object)metaProperties, (Object)metaProperties2);
        Assertions.assertEquals((int)metaProperties.hashCode(), (int)metaProperties2.hashCode());
        Assertions.assertEquals((Object)metaProperties.toString(), (Object)metaProperties2.toString());
        Assertions.assertEquals((Object)expectedToStringOutput, (Object)metaProperties.toString());
    }

    @Test
    public void testV1SerializationWithoutDirectoryId() {
        this.testV1Serialization("zd2vLVrZQlCLJj8-k7A10w", 0, Optional.empty(), "MetaProperties(version=1, clusterId=zd2vLVrZQlCLJj8-k7A10w, nodeId=0)");
    }

    @Test
    public void testV1SerializationWithDirectoryId() {
        this.testV1Serialization("zd2vLVrZQlCLJj8-k7A10w", 1, Optional.of(Uuid.fromString((String)"3Adc4FjfTeypRWROmQDNIQ")), "MetaProperties(version=1, clusterId=zd2vLVrZQlCLJj8-k7A10w, nodeId=1, directoryId=3Adc4FjfTeypRWROmQDNIQ)");
    }

    @Test
    public void testV1SerializationWithNonUuidClusterId() {
        this.testV1Serialization("my@cluster@id", 2, Optional.empty(), "MetaProperties(version=1, clusterId=my@cluster@id, nodeId=2)");
    }

    private void testV1Serialization(String clusterId, int nodeId, Optional<Uuid> directoryId, String expectedToStringOutput) {
        MetaProperties metaProperties = new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(nodeId).setDirectoryId(directoryId).build();
        Assertions.assertEquals((Object)MetaPropertiesVersion.V1, (Object)metaProperties.version());
        Assertions.assertEquals(Optional.of(clusterId), (Object)metaProperties.clusterId());
        Assertions.assertEquals((Object)OptionalInt.of(nodeId), (Object)metaProperties.nodeId());
        Assertions.assertEquals(directoryId, (Object)metaProperties.directoryId());
        Properties props = new Properties();
        props.setProperty("version", "1");
        props.setProperty("cluster.id", clusterId);
        props.setProperty("node.id", "" + nodeId);
        if (directoryId.isPresent()) {
            props.setProperty("directory.id", directoryId.get().toString());
        }
        Properties props2 = metaProperties.toProperties();
        Assertions.assertEquals((Object)props, (Object)props2);
        MetaProperties metaProperties2 = new MetaProperties.Builder(props2).build();
        Assertions.assertEquals((Object)metaProperties, (Object)metaProperties2);
        Assertions.assertEquals((int)metaProperties.hashCode(), (int)metaProperties2.hashCode());
        Assertions.assertEquals((Object)metaProperties.toString(), (Object)metaProperties2.toString());
        Assertions.assertEquals((Object)expectedToStringOutput, (Object)metaProperties.toString());
    }

    @Test
    public void testClusterIdRequiredInV1() {
        Assertions.assertEquals((Object)"cluster.id was not found.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setNodeId(1).build())).getMessage());
    }

    @Test
    public void testNodeIdRequiredInV1() {
        Assertions.assertEquals((Object)"node.id was not found.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId("zd2vLVrZQlCLJj8-k7A10w").build())).getMessage());
    }
}

