/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.kafka.metadata.migration.FileMigrationTrigger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileMigrationTriggerTest {
    @Test
    public void testNoParentDirectory() {
        String message = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> FileMigrationTrigger.newFileTrigger((String)"/tmp/FileMigrationTriggerTest-not-a-real-directory/trigger.file"))).getMessage();
        Assertions.assertTrue((boolean)message.endsWith("the parent directory does not exist."));
    }

    @Test
    public void testParentNotDirectory() throws IOException {
        Path file = Files.createTempFile("testParentNotDirectory", "", new FileAttribute[0]);
        String message = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> FileMigrationTrigger.newFileTrigger((String)file.resolve("trigger.file").toString()))).getMessage();
        Assertions.assertTrue((boolean)message.endsWith("the parent path is not a directory."));
    }

    @Test
    public void testFileNotFile() throws IOException {
        Path file = Files.createTempDirectory("testFileNotFile", new FileAttribute[0]);
        String message = ((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> FileMigrationTrigger.newFileTrigger((String)file.toString()))).getMessage();
        Assertions.assertTrue((boolean)message.endsWith("the file exists, but is not a regular file."));
    }

    @Test
    public void testEmpty() {
        Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> FileMigrationTrigger.newFileTrigger((String)""))).getMessage(), (Object)"Cannot create FileMigrationTrigger for empty path");
    }

    @Test
    public void testNull() {
        Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> FileMigrationTrigger.newFileTrigger(null))).getMessage(), (Object)"Cannot create FileMigrationTrigger for empty path");
    }

    @Test
    public void testParentIsDeleted() throws IOException {
        Path dir = Files.createTempDirectory("testParentIsDirectory", new FileAttribute[0]);
        String filePath = dir.resolve("trigger.file").toString();
        FileMigrationTrigger trigger = FileMigrationTrigger.newFileTrigger((String)filePath);
        trigger.checkTrigger((shouldContinue, logMessage) -> {
            Assertions.assertFalse((boolean)shouldContinue);
            Assertions.assertEquals((Object)("Migration trigger file " + filePath + " not yet found, migration will not yet continue"), (Object)logMessage);
        });
        Files.delete(dir);
        trigger.checkTrigger((shouldContinue, logMessage) -> {
            Assertions.assertFalse((boolean)shouldContinue);
            Assertions.assertEquals((Object)("Migration trigger file " + filePath + " not yet found, migration will not yet continue"), (Object)logMessage);
        });
    }

    @Test
    public void testTriggerFileCreated() throws IOException {
        Path dir = Files.createTempDirectory("testParentIsDirectory", new FileAttribute[0]);
        String filePath = dir.resolve("trigger.file").toString();
        FileMigrationTrigger trigger = FileMigrationTrigger.newFileTrigger((String)filePath);
        trigger.checkTrigger((shouldContinue, logMessage) -> {
            Assertions.assertFalse((boolean)shouldContinue);
            Assertions.assertEquals((Object)("Migration trigger file " + filePath + " not yet found, migration will not yet continue"), (Object)logMessage);
        });
        Files.createFile(dir.resolve("trigger.file"), new FileAttribute[0]);
        trigger.checkTrigger((shouldContinue, logMessage) -> {
            Assertions.assertTrue((boolean)shouldContinue);
            Assertions.assertEquals((Object)("Migration trigger file " + filePath + " was found, migration will continue."), (Object)logMessage);
        });
    }
}

