/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;

public class CapturingTopicMigrationClient
implements TopicMigrationClient {
    public List<String> deletedTopics = new ArrayList<String>();
    public List<String> createdTopics = new ArrayList<String>();
    public LinkedHashMap<String, Map<Integer, PartitionRegistration>> updatedTopics = new LinkedHashMap();
    public LinkedHashMap<String, Set<Integer>> newTopicPartitions = new LinkedHashMap();
    public LinkedHashMap<String, Set<Integer>> updatedTopicPartitions = new LinkedHashMap();
    public LinkedHashMap<String, Set<Integer>> deletedTopicPartitions = new LinkedHashMap();

    public void reset() {
        this.createdTopics.clear();
        this.updatedTopicPartitions.clear();
        this.deletedTopics.clear();
        this.updatedTopics.clear();
        this.deletedTopicPartitions.clear();
    }

    public void iterateTopics(EnumSet<TopicMigrationClient.TopicVisitorInterest> interests, TopicMigrationClient.TopicVisitor visitor) {
    }

    public Set<String> readPendingTopicDeletions() {
        return Collections.emptySet();
    }

    public ZkMigrationLeadershipState clearPendingTopicDeletions(Set<String> pendingTopicDeletions, ZkMigrationLeadershipState state) {
        return state;
    }

    public ZkMigrationLeadershipState deleteTopic(String topicName, ZkMigrationLeadershipState state) {
        this.deletedTopics.add(topicName);
        return state;
    }

    public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, Map<Integer, PartitionRegistration> topicPartitions, Optional<MirrorTopic> mirrorTopic, ZkMigrationLeadershipState state) {
        this.createdTopics.add(topicName);
        return state;
    }

    public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, Map<Integer, PartitionRegistration> topicPartitions, ZkMigrationLeadershipState state) {
        this.createdTopics.add(topicName);
        return state;
    }

    public ZkMigrationLeadershipState updateTopic(String topicName, Uuid topicId, Map<Integer, PartitionRegistration> topicPartitions, Optional<MirrorTopic> mirrorTopic, ZkMigrationLeadershipState state) {
        this.updatedTopics.put(topicName, topicPartitions);
        return state;
    }

    public ZkMigrationLeadershipState createTopicPartitions(Map<String, Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        topicPartitions.forEach((topicName, partitionMap) -> this.newTopicPartitions.put((String)topicName, partitionMap.keySet()));
        return state;
    }

    public ZkMigrationLeadershipState updateTopicPartitions(Map<String, Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        topicPartitions.forEach((topicName, partitionMap) -> this.updatedTopicPartitions.put((String)topicName, partitionMap.keySet()));
        return state;
    }

    public ZkMigrationLeadershipState deleteTopicPartitions(Map<String, Set<Integer>> topicPartitions, ZkMigrationLeadershipState state) {
        this.deletedTopicPartitions.putAll(topicPartitions);
        return state;
    }
}

