/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.migration.AclMigrationClient;
import org.apache.kafka.metadata.migration.BrokerHealthMigrationClient;
import org.apache.kafka.metadata.migration.CapturingAclMigrationClient;
import org.apache.kafka.metadata.migration.CapturingBrokerHealthMigrationClient;
import org.apache.kafka.metadata.migration.CapturingClusterLinkMigrationClient;
import org.apache.kafka.metadata.migration.CapturingConfigMigrationClient;
import org.apache.kafka.metadata.migration.CapturingDelegationTokenMigrationClient;
import org.apache.kafka.metadata.migration.CapturingReplicaExclusionMigrationClient;
import org.apache.kafka.metadata.migration.CapturingTopicMigrationClient;
import org.apache.kafka.metadata.migration.ClusterLinkMigrationClient;
import org.apache.kafka.metadata.migration.ConfigMigrationClient;
import org.apache.kafka.metadata.migration.DelegationTokenMigrationClient;
import org.apache.kafka.metadata.migration.KRaftMigrationOperation;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.ReplicaExclusionMigrationClient;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.ProducerIdsBlock;

class CapturingMigrationClient
implements MigrationClient {
    static final MigrationBatchSupplier EMPTY_BATCH_SUPPLIER = new MigrationBatchSupplier(){};
    private final Set<Integer> brokerIds;
    private final TopicMigrationClient topicMigrationClient;
    private final ConfigMigrationClient configMigrationClient;
    private final AclMigrationClient aclMigrationClient;
    private final DelegationTokenMigrationClient delegationTokenMigrationClient;
    private final ClusterLinkMigrationClient clusterLinkMigrationClient;
    private final BrokerHealthMigrationClient brokerHealthMigrationClient;
    private final ReplicaExclusionMigrationClient replicaExclusionMigrationClient;
    private final MigrationBatchSupplier batchSupplier;
    private ZkMigrationLeadershipState state = null;

    static Builder newBuilder() {
        return new Builder();
    }

    CapturingMigrationClient(Set<Integer> brokerIdsInZk, TopicMigrationClient topicMigrationClient, ConfigMigrationClient configMigrationClient, AclMigrationClient aclMigrationClient, DelegationTokenMigrationClient delegationTokenMigrationClient, ClusterLinkMigrationClient clusterLinkMigrationClient, BrokerHealthMigrationClient brokerHealthMigrationClient, ReplicaExclusionMigrationClient replicaExclusionMigrationClient, MigrationBatchSupplier batchSupplier) {
        this.brokerIds = brokerIdsInZk;
        this.topicMigrationClient = topicMigrationClient;
        this.configMigrationClient = configMigrationClient;
        this.aclMigrationClient = aclMigrationClient;
        this.delegationTokenMigrationClient = delegationTokenMigrationClient;
        this.clusterLinkMigrationClient = clusterLinkMigrationClient;
        this.brokerHealthMigrationClient = brokerHealthMigrationClient;
        this.replicaExclusionMigrationClient = replicaExclusionMigrationClient;
        this.batchSupplier = batchSupplier;
    }

    public ZkMigrationLeadershipState getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState initialState) {
        if (this.state == null) {
            this.state = initialState;
        }
        return this.state;
    }

    public ZkMigrationLeadershipState setMigrationRecoveryState(ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public ZkMigrationLeadershipState claimControllerLeadership(ZkMigrationLeadershipState state) {
        this.state = state.zkControllerEpochZkVersion() == -2 ? state.withZkController(0, 0) : state.withZkController(state.zkControllerEpoch() + 1, state.zkControllerEpochZkVersion() + 1);
        return this.state;
    }

    public ZkMigrationLeadershipState releaseControllerLeadership(ZkMigrationLeadershipState state) {
        this.state = state.withUnknownZkController();
        return this.state;
    }

    public TopicMigrationClient topicClient() {
        return this.topicMigrationClient;
    }

    public ConfigMigrationClient configClient() {
        return this.configMigrationClient;
    }

    public AclMigrationClient aclClient() {
        return this.aclMigrationClient;
    }

    public DelegationTokenMigrationClient delegationTokenClient() {
        return this.delegationTokenMigrationClient;
    }

    public ClusterLinkMigrationClient clusterLinkClient() {
        return this.clusterLinkMigrationClient;
    }

    public BrokerHealthMigrationClient brokerHealthClient() {
        return this.brokerHealthMigrationClient;
    }

    public ReplicaExclusionMigrationClient replicaExclusionClient() {
        return this.replicaExclusionMigrationClient;
    }

    public Optional<ProducerIdsBlock> readProducerId() {
        return Optional.empty();
    }

    public ZkMigrationLeadershipState writeProducerId(long nextProducerId, ZkMigrationLeadershipState state) {
        this.state = state;
        return state;
    }

    public void cleanAndMigrateAllMetadata(Consumer<List<ApiMessageAndVersion>> batchConsumer, Consumer<Integer> brokerIdConsumer, BiConsumer<String, KRaftMigrationOperation> operationConsumer, Map<Integer, BrokerRegistration> brokerRegistrations, Uuid encryptorId, MetadataVersion metadataVersion) {
        this.batchSupplier.recordBatches().forEach(batchConsumer);
        this.batchSupplier.brokerIds().forEach(brokerIdConsumer);
    }

    public Set<Integer> readBrokerIds() {
        return this.brokerIds;
    }

    public static class Builder {
        Set<Integer> brokersInZk = Collections.emptySet();
        TopicMigrationClient topicMigrationClient = new CapturingTopicMigrationClient();
        ConfigMigrationClient configMigrationClient = new CapturingConfigMigrationClient();
        AclMigrationClient aclMigrationClient = new CapturingAclMigrationClient();
        DelegationTokenMigrationClient delegationTokenMigrationClient = new CapturingDelegationTokenMigrationClient();
        ClusterLinkMigrationClient clusterLinkMigrationClient = new CapturingClusterLinkMigrationClient();
        BrokerHealthMigrationClient brokerHealthMigrationClient = new CapturingBrokerHealthMigrationClient();
        ReplicaExclusionMigrationClient replicaExclusionMigrationClient = new CapturingReplicaExclusionMigrationClient();
        MigrationBatchSupplier batchSupplier = EMPTY_BATCH_SUPPLIER;

        public Builder setBrokersInZk(int ... brokerIds) {
            this.brokersInZk = IntStream.of(brokerIds).boxed().collect(Collectors.toSet());
            return this;
        }

        public Builder setTopicMigrationClient(TopicMigrationClient topicMigrationClient) {
            this.topicMigrationClient = topicMigrationClient;
            return this;
        }

        public Builder setConfigMigrationClient(ConfigMigrationClient configMigrationClient) {
            this.configMigrationClient = configMigrationClient;
            return this;
        }

        public Builder setAclMigrationClient(AclMigrationClient aclMigrationClient) {
            this.aclMigrationClient = aclMigrationClient;
            return this;
        }

        public Builder setClusterLinkMigrationClient(ClusterLinkMigrationClient linkMigrationClient) {
            this.clusterLinkMigrationClient = linkMigrationClient;
            return this;
        }

        public Builder setBrokerHealthMigrationClient(BrokerHealthMigrationClient brokerHealthMigrationClient) {
            this.brokerHealthMigrationClient = brokerHealthMigrationClient;
            return this;
        }

        public Builder setReplicaExclusionMigrationClient(ReplicaExclusionMigrationClient replicaExclusionMigrationClient) {
            this.replicaExclusionMigrationClient = replicaExclusionMigrationClient;
            return this;
        }

        public Builder setDelegationTokenMigrationClient(DelegationTokenMigrationClient delegationTokenMigrationClient) {
            this.delegationTokenMigrationClient = delegationTokenMigrationClient;
            return this;
        }

        public Builder setBatchSupplier(MigrationBatchSupplier batchSupplier) {
            this.batchSupplier = batchSupplier;
            return this;
        }

        public CapturingMigrationClient build() {
            return new CapturingMigrationClient(this.brokersInZk, this.topicMigrationClient, this.configMigrationClient, this.aclMigrationClient, this.delegationTokenMigrationClient, this.clusterLinkMigrationClient, this.brokerHealthMigrationClient, this.replicaExclusionMigrationClient, this.batchSupplier);
        }
    }

    static interface MigrationBatchSupplier {
        default public List<List<ApiMessageAndVersion>> recordBatches() {
            return Collections.emptyList();
        }

        default public List<Integer> brokerIds() {
            return Collections.emptyList();
        }
    }
}

