/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.config;

import java.util.HashMap;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.metadata.config.ConfigRegistry;
import org.apache.kafka.metadata.config.ConfigRegistryTestConstants;
import org.apache.kafka.metadata.config.SpecificResourceConfigMonitor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public final class ConfigRegistryTest {
    @Test
    public void testGetStaticNodeShort() {
        TestContext context = new TestContext();
        Assertions.assertEquals((short)3, (short)context.builder.getStaticNodeShort("num.foobars"));
    }

    @Test
    public void testGetStaticNodeInt() {
        TestContext context = new TestContext();
        Assertions.assertEquals((int)5, (int)context.builder.getStaticNodeInt("num.quux"));
    }

    @Test
    public void testInitialValues() {
        TestContext context = new TestContext();
        context.builder.build();
        Assertions.assertEquals((short)3, (Short)((Short)context.numFoobarsMonitor.effectiveValue()));
        Assertions.assertEquals((int)5, (Integer)((Integer)context.numQuuxMonitor.effectiveValue()));
    }

    static class TestContext {
        ConfigRegistry.Builder builder = new ConfigRegistry.Builder(new LogContext(), ConfigRegistryTestConstants.SCHEMA, ConfigRegistryTestConstants.STATIC_CONFIG_MAP, 1, () -> new HashMap());
        SpecificResourceConfigMonitor<Short> numFoobarsMonitor = this.builder.addShortNodeMonitor("num.foobars");
        SpecificResourceConfigMonitor<Integer> numQuuxMonitor = this.builder.addIntNodeMonitor("num.quux");

        TestContext() {
        }
    }
}

