/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.authorizer.StandardAclRecordIterator;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTestConstants;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class StandardAclRecordIteratorTest {
    @Test
    public void testIteration() {
        List<StandardAclWithId> allList = StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.ALL).subList(0, 7);
        StandardAclRecordIterator iterator = new StandardAclRecordIterator(allList.iterator(), 2);
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals(Arrays.asList(new ApiMessageAndVersion((ApiMessage)allList.get(0).toRecord(), 0), new ApiMessageAndVersion((ApiMessage)allList.get(1).toRecord(), 0)), (Object)iterator.next());
        Assertions.assertEquals(Arrays.asList(new ApiMessageAndVersion((ApiMessage)allList.get(2).toRecord(), 0), new ApiMessageAndVersion((ApiMessage)allList.get(3).toRecord(), 0)), (Object)iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals(Arrays.asList(new ApiMessageAndVersion((ApiMessage)allList.get(4).toRecord(), 0), new ApiMessageAndVersion((ApiMessage)allList.get(5).toRecord(), 0)), (Object)iterator.next());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals(Arrays.asList(new ApiMessageAndVersion((ApiMessage)allList.get(6).toRecord(), 0)), (Object)iterator.next());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNoSuchElementException() {
        List<StandardAclWithId> allList = StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.ALL).subList(0, 7);
        StandardAclRecordIterator iterator = new StandardAclRecordIterator(allList.iterator(), 2);
        iterator.next();
        iterator.next();
        iterator.next();
        iterator.next();
        Assertions.assertThrows(NoSuchElementException.class, () -> iterator.next());
    }
}

