/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.net.InetAddress;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.authorizer.DefaultRule;
import org.apache.kafka.metadata.authorizer.MatchingAclRule;
import org.apache.kafka.metadata.authorizer.MockAuthorizableRequestContext;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.SuperUserRule;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class MatchingRuleTest {
    static final KafkaPrincipal LARRY = new KafkaPrincipal("User", "larry");

    @Test
    public void testDefaultRule() {
        Assertions.assertEquals((Object)AuthorizationResult.DENIED, (Object)DefaultRule.DENIED.result());
        Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)new DefaultRule(AuthorizationResult.ALLOWED).result());
        Assertions.assertEquals((Object)"DefaultDeny", (Object)DefaultRule.DENIED.toString());
        Assertions.assertEquals((Object)"DefaultAllow", (Object)new DefaultRule(AuthorizationResult.ALLOWED).toString());
    }

    @Test
    public void testSuperUserRule() {
        Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)SuperUserRule.INSTANCE.result());
        Assertions.assertEquals((Object)"SuperUser", (Object)SuperUserRule.INSTANCE.toString());
    }

    @Test
    public void testMatchingAclRule() {
        StandardAcl acl1 = new StandardAcl(ResourceType.TOPIC, "bar", PatternType.LITERAL, LARRY.toString(), "127.0.0.1", AclOperation.READ, AclPermissionType.ALLOW);
        MatchingAclRule rule = new MatchingAclRule(acl1, AuthorizationResult.ALLOWED);
        Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)rule.result());
        Assertions.assertEquals((Object)"MatchingAcl(acl=StandardAcl(resourceType=TOPIC, resourceName=bar, patternType=LITERAL, principal=User:larry, host=127.0.0.1, operation=READ, permissionType=ALLOW))", (Object)rule.toString());
    }

    @Test
    public void testAppendResourcePattern() throws Exception {
        Action action = new Action(AclOperation.WRITE, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL), 1, true, true);
        Assertions.assertEquals((Object)"Principal = User:larry is Allowed operation = WRITE from host = 127.0.0.1 on resource = Topic:LITERAL:foo for request = Fetch with resourceRefCount = 1 based on rule SuperUser", (Object)SuperUserRule.INSTANCE.buildAuditMessage(LARRY, (AuthorizableRequestContext)new MockAuthorizableRequestContext.Builder().setClientAddress(InetAddress.getByName("127.0.0.1")).build(), action));
    }
}

