/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.metadata.ClusterLink;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

public class ClusterLinkTest {
    @ParameterizedTest
    @NullSource
    @ValueSource(strings={"tenantPrefix"})
    public void testHandlesTenantPrefix(String tenantPrefix) {
        String linkName = "linkName";
        Uuid linkId = Uuid.fromString((String)"UOiKbNCCQjeSl_oI5kA6rQ");
        String sourceClusterId = "sourceClusterId";
        String linkMode = "DESTINATION";
        ClusterLink clusterLink = new ClusterLink(linkName, linkId, tenantPrefix, sourceClusterId, linkMode);
        Assertions.assertEquals((Object)clusterLink, (Object)clusterLink);
        ClusterLinkRecord clusterLinkRecord = new ClusterLinkRecord();
        clusterLinkRecord.setClusterLinkId(linkId).setClusterLinkName(linkName).setLinkMode(linkMode).setRemoteClusterId(sourceClusterId).setTenantPrefix(tenantPrefix);
        Assertions.assertEquals((Object)clusterLinkRecord, (Object)clusterLink.toRecord());
        String expectedToStr = tenantPrefix != null ? "ClusterLinkImage(linkName=linkName, linkId=UOiKbNCCQjeSl_oI5kA6rQ, tenantPrefix=tenantPrefix, remoteClusterId=sourceClusterId, linkMode=DESTINATION)" : "ClusterLinkImage(linkName=linkName, linkId=UOiKbNCCQjeSl_oI5kA6rQ, remoteClusterId=sourceClusterId, linkMode=DESTINATION)";
        Assertions.assertEquals((Object)expectedToStr, (Object)clusterLink.toString());
    }
}

