/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.FaultHandlerException;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class SnapshotGeneratorTest {
    private static final MetadataDelta TEST_DELTA = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
    private static final MetadataImage TEST_IMAGE;

    static LogDeltaManifest.Builder logDeltaManifestBuilder() {
        return LogDeltaManifest.newBuilder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(1).elapsedNs(100L).numBytes(100L);
    }

    @Test
    public void testCreateSnapshot() throws Exception {
        MockFaultHandler faultHandler = new MockFaultHandler("SnapshotGenerator");
        MockEmitter emitter = new MockEmitter();
        try (SnapshotGenerator generator = new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)emitter).setFaultHandler((FaultHandler)faultHandler).setMaxBytesSinceLastSnapshot(200L).setMaxTimeSinceLastSnapshotNs(TimeUnit.DAYS.toNanos(10L)).build();){
            generator.publishLogDelta(TEST_DELTA, TEST_IMAGE, SnapshotGeneratorTest.logDeltaManifestBuilder().build());
            generator.publishLogDelta(TEST_DELTA, TEST_IMAGE, SnapshotGeneratorTest.logDeltaManifestBuilder().build());
            generator.publishLogDelta(TEST_DELTA, TEST_IMAGE, SnapshotGeneratorTest.logDeltaManifestBuilder().numBytes(2000L).build());
            Assertions.assertEquals(Collections.emptyList(), emitter.images());
            emitter.setReady();
        }
        Assertions.assertEquals(Arrays.asList(TEST_IMAGE), emitter.images());
        faultHandler.maybeRethrowFirstException();
    }

    @Test
    public void testSnapshotsDisabled() throws Exception {
        MockFaultHandler faultHandler = new MockFaultHandler("SnapshotGenerator");
        MockEmitter emitter = new MockEmitter().setReady();
        AtomicReference<String> disabledReason = new AtomicReference<String>();
        try (SnapshotGenerator generator = new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)emitter).setFaultHandler((FaultHandler)faultHandler).setMaxBytesSinceLastSnapshot(1L).setMaxTimeSinceLastSnapshotNs(0L).setDisabledReason(disabledReason).build();){
            disabledReason.compareAndSet(null, "we are testing disable()");
            generator.publishLogDelta(TEST_DELTA, TEST_IMAGE, SnapshotGeneratorTest.logDeltaManifestBuilder().build());
        }
        Assertions.assertEquals(Collections.emptyList(), emitter.images());
        faultHandler.maybeRethrowFirstException();
    }

    @Test
    public void testTimeBasedSnapshots() throws Exception {
        MockFaultHandler faultHandler = new MockFaultHandler("SnapshotGenerator");
        MockEmitter emitter = new MockEmitter().setReady();
        MockTime mockTime = new MockTime();
        try (SnapshotGenerator generator = new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)emitter).setTime((Time)mockTime).setFaultHandler((FaultHandler)faultHandler).setMaxBytesSinceLastSnapshot(200L).setMaxTimeSinceLastSnapshotNs(TimeUnit.MINUTES.toNanos(30L)).build();){
            generator.publishLogDelta(TEST_DELTA, TEST_IMAGE, SnapshotGeneratorTest.logDeltaManifestBuilder().numBytes(50L).build());
            Assertions.assertEquals(Collections.emptyList(), emitter.images());
            mockTime.sleep(TimeUnit.MINUTES.toNanos(40L));
            generator.publishLogDelta(TEST_DELTA, TEST_IMAGE, SnapshotGeneratorTest.logDeltaManifestBuilder().numBytes(50L).build());
            TestUtils.waitForCondition(() -> emitter.images().size() == 1, (String)"images.size == 1");
            generator.publishLogDelta(TEST_DELTA, TEST_IMAGE, SnapshotGeneratorTest.logDeltaManifestBuilder().numBytes(150L).build());
        }
        Assertions.assertEquals(Arrays.asList(TEST_IMAGE), emitter.images());
        faultHandler.maybeRethrowFirstException();
    }

    @Test
    public void testEmitterProblem() throws Exception {
        MockFaultHandler faultHandler = new MockFaultHandler("SnapshotGenerator");
        MockEmitter emitter = new MockEmitter().setProblem(new RuntimeException("oops"));
        try (SnapshotGenerator generator = new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)emitter).setFaultHandler((FaultHandler)faultHandler).setMaxBytesSinceLastSnapshot(200L).build();){
            for (int i = 0; i < 2; ++i) {
                generator.publishLogDelta(TEST_DELTA, TEST_IMAGE, SnapshotGeneratorTest.logDeltaManifestBuilder().elapsedNs(10000L).numBytes(50000L).build());
            }
        }
        Assertions.assertEquals(Collections.emptyList(), emitter.images());
        Assertions.assertNotNull((Object)faultHandler.firstException());
        Assertions.assertEquals(FaultHandlerException.class, faultHandler.firstException().getClass());
        Assertions.assertEquals((Object)"SnapshotGenerator: KRaft snapshot file generation error: oops", (Object)faultHandler.firstException().getMessage());
    }

    static {
        TEST_DELTA.replay(RecordTestUtils.testRecord(0).message(), RecordTestUtils.testRecord(0).version());
        TEST_IMAGE = TEST_DELTA.apply(MetadataProvenance.EMPTY);
    }

    static class MockEmitter
    implements SnapshotGenerator.Emitter {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final List<MetadataImage> images = new CopyOnWriteArrayList<MetadataImage>();
        private volatile RuntimeException problem = null;

        MockEmitter() {
        }

        MockEmitter setReady() {
            this.latch.countDown();
            return this;
        }

        synchronized MockEmitter setProblem(RuntimeException problem) {
            this.problem = problem;
            return this;
        }

        public synchronized void maybeEmit(MetadataImage image) {
            RuntimeException currentProblem = this.problem;
            if (currentProblem != null) {
                throw currentProblem;
            }
            try {
                this.latch.await(30L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            this.images.add(image);
        }

        List<MetadataImage> images() {
            return new ArrayList<MetadataImage>(this.images);
        }
    }
}

