/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.image.writer.UnwritableMetadataException;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class FeaturesImageTest {
    public static final FeaturesImage IMAGE1;
    public static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final FeaturesDelta DELTA1;
    static final FeaturesImage IMAGE2;

    @Test
    public void testEmptyImageRoundTrip() {
        FeaturesImageTest.testToImage(FeaturesImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        FeaturesImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = FeaturesImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        FeaturesImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        FeaturesImageTest.testToImage(IMAGE2);
    }

    @Test
    public void testImageWriteWithOldMetadataVersion() {
        FeaturesImage image = new FeaturesImage(Collections.singletonMap("foo", (short)100), MetadataVersion.IBP_3_3_IV3, ZkMigrationState.NONE);
        RecordListWriter writer = new RecordListWriter();
        AtomicReference exceptionReference = new AtomicReference();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().setLossHandler(exceptionReference::set).setMetadataVersion(MetadataVersion.IBP_3_2_IV0).build());
        Assertions.assertEquals((int)0, (int)writer.records().size());
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_2_IV0, (Object)((UnwritableMetadataException)exceptionReference.get()).metadataVersion());
    }

    private static void testToImage(FeaturesImage image) {
        FeaturesImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(FeaturesImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        FeaturesImageTest.testToImage(image, fromRecords.orElseGet(() -> FeaturesImageTest.getImageRecords(image)));
    }

    private static void testToImage(FeaturesImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<FeaturesDelta, FeaturesImage>(() -> FeaturesImage.EMPTY, FeaturesDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(FeaturesImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().setMetadataVersion(image.metadataVersion()).build());
        return writer.records();
    }

    @Test
    public void testEmpty() {
        Assertions.assertTrue((boolean)FeaturesImage.EMPTY.isEmpty());
        Assertions.assertFalse((boolean)new FeaturesImage(Collections.singletonMap("foo", (short)1), FeaturesImage.EMPTY.metadataVersion(), FeaturesImage.EMPTY.zkMigrationState()).isEmpty());
        Assertions.assertFalse((boolean)new FeaturesImage(FeaturesImage.EMPTY.finalizedVersions(), MetadataVersion.IBP_3_3_IV0, FeaturesImage.EMPTY.zkMigrationState()).isEmpty());
        Assertions.assertFalse((boolean)new FeaturesImage(FeaturesImage.EMPTY.finalizedVersions(), FeaturesImage.EMPTY.metadataVersion(), ZkMigrationState.MIGRATION).isEmpty());
    }

    static {
        HashMap<String, Short> map1 = new HashMap<String, Short>();
        map1.put("foo", (short)2);
        map1.put("bar", (short)1);
        map1.put("baz", (short)8);
        IMAGE1 = new FeaturesImage(map1, MetadataVersion.latestTesting(), ZkMigrationState.NONE);
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("foo").setFeatureLevel((short)3), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("bar").setFeatureLevel((short)0), 0));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("baz").setFeatureLevel((short)0), 0));
        DELTA1 = new FeaturesDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        HashMap<String, Short> map2 = new HashMap<String, Short>();
        map2.put("foo", (short)3);
        IMAGE2 = new FeaturesImage(map2, MetadataVersion.latestTesting(), ZkMigrationState.NONE);
    }
}

