/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClusterLinkRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveClusterLinkRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ClusterLinksDelta;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RecordListWriter;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.RecordTestUtils;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClusterLinksImageTest {
    static final ClusterLinksImage IMAGE1;
    static final List<ApiMessageAndVersion> DELTA1_RECORDS;
    static final ClusterLinksDelta DELTA1;
    static final ClusterLinksImage IMAGE2;
    static final List<ClusterLink> CLUSTER_LINKS;
    static final Uuid LINK_FOO_UUID;
    static final Uuid LINK_BAR_UUID;
    static final Uuid LINK_BAZ_UUID;

    private static ClusterLink newClusterLink(String linkName, Uuid linkId, String tenantPrefix, String sourceClusterId, ClusterLinkConfig.LinkMode linkMode) {
        return new ClusterLink(linkName, linkId, tenantPrefix, sourceClusterId, linkMode.toString());
    }

    private static Map<Uuid, ClusterLink> newLinksByIdMap(Collection<ClusterLink> links) {
        HashMap<Uuid, ClusterLink> map = new HashMap<Uuid, ClusterLink>();
        for (ClusterLink link : links) {
            map.put(link.linkId(), link);
        }
        return map;
    }

    private static Map<String, ClusterLink> newLinksByNameMap(Collection<ClusterLink> links) {
        HashMap<String, ClusterLink> map = new HashMap<String, ClusterLink>();
        for (ClusterLink link : links) {
            map.put(link.linkName(), link);
        }
        return map;
    }

    @Test
    public void testEmptyImageRoundTrip() {
        ClusterLinksImageTest.testToImage(ClusterLinksImage.EMPTY);
    }

    @Test
    public void testImage1RoundTrip() {
        ClusterLinksImageTest.testToImage(IMAGE1);
    }

    @Test
    public void testApplyDelta1() {
        Assertions.assertEquals((Object)IMAGE2, (Object)DELTA1.apply());
        List<ApiMessageAndVersion> records = ClusterLinksImageTest.getImageRecords(IMAGE1);
        records.addAll(DELTA1_RECORDS);
        ClusterLinksImageTest.testToImage(IMAGE2, records);
    }

    @Test
    public void testImage2RoundTrip() {
        ClusterLinksImageTest.testToImage(IMAGE2);
    }

    private static void testToImage(ClusterLinksImage image) {
        ClusterLinksImageTest.testToImage(image, Optional.empty());
    }

    private static void testToImage(ClusterLinksImage image, Optional<List<ApiMessageAndVersion>> fromRecords) {
        ClusterLinksImageTest.testToImage(image, fromRecords.orElseGet(() -> ClusterLinksImageTest.getImageRecords(image)));
    }

    private static void testToImage(ClusterLinksImage image, List<ApiMessageAndVersion> fromRecords) {
        new RecordTestUtils.TestThroughAllIntermediateImagesLeadingToFinalImageHelper<ClusterLinksDelta, ClusterLinksImage>(() -> ClusterLinksImage.EMPTY, ClusterLinksDelta::new).test(image, fromRecords);
    }

    private static List<ApiMessageAndVersion> getImageRecords(ClusterLinksImage image) {
        RecordListWriter writer = new RecordListWriter();
        image.write((ImageWriter)writer, new ImageWriterOptions.Builder().build());
        return writer.records();
    }

    static {
        LINK_FOO_UUID = Uuid.fromString((String)"ThIaNwRnSM2Nt9Mx1v0RvA");
        LINK_BAR_UUID = Uuid.fromString((String)"f62ptyETTjet8SL5ZeREiw");
        LINK_BAZ_UUID = Uuid.fromString((String)"tgHBnRglT5W_RlENnuG5vg");
        CLUSTER_LINKS = Arrays.asList(ClusterLinksImageTest.newClusterLink("foo", LINK_FOO_UUID, "", "sourceCluster0", ClusterLinkConfig.LinkMode.DESTINATION), ClusterLinksImageTest.newClusterLink("bar", LINK_BAR_UUID, "", "sourceCluster1", ClusterLinkConfig.LinkMode.SOURCE));
        IMAGE1 = new ClusterLinksImage(ClusterLinksImageTest.newLinksByIdMap(CLUSTER_LINKS), ClusterLinksImageTest.newLinksByNameMap(CLUSTER_LINKS), Collections.emptyMap());
        DELTA1_RECORDS = new ArrayList<ApiMessageAndVersion>();
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new RemoveClusterLinkRecord().setClusterLinkId(LINK_BAR_UUID), MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD.highestSupportedVersion()));
        DELTA1_RECORDS.add(new ApiMessageAndVersion((ApiMessage)new ClusterLinkRecord().setClusterLinkName("baz").setClusterLinkId(LINK_BAZ_UUID).setTenantPrefix("").setRemoteClusterId("sourceCluster2").setLinkMode(ClusterLinkConfig.LinkMode.DESTINATION.toString()), MetadataRecordType.REMOVE_CLUSTER_LINK_RECORD.highestSupportedVersion()));
        DELTA1 = new ClusterLinksDelta(IMAGE1);
        RecordTestUtils.replayAll(DELTA1, DELTA1_RECORDS);
        List<ClusterLink> clusterLinks2 = Arrays.asList(ClusterLinksImageTest.newClusterLink("foo", LINK_FOO_UUID, "", "sourceCluster0", ClusterLinkConfig.LinkMode.DESTINATION), ClusterLinksImageTest.newClusterLink("baz", LINK_BAZ_UUID, "", "sourceCluster2", ClusterLinkConfig.LinkMode.DESTINATION));
        IMAGE2 = new ClusterLinksImage(ClusterLinksImageTest.newLinksByIdMap(clusterLinks2), ClusterLinksImageTest.newLinksByNameMap(clusterLinks2), Collections.emptyMap());
    }
}

