/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.controller.metrics.TenantMetricsPublisher;
import org.apache.kafka.server.fault.FaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TenantMetricsPublisherTest {
    private TenantMetricsPublisher tenantMetricsPublisher;
    private FaultHandler faultHandler;

    @BeforeEach
    public void setUp() {
        this.faultHandler = (FaultHandler)Mockito.mock(FaultHandler.class);
        this.tenantMetricsPublisher = new TenantMetricsPublisher(this.faultHandler);
    }

    @Test
    public void testTenantMetadataPublisherInitialization() {
        Assertions.assertEquals(Collections.emptyMap(), (Object)this.tenantMetricsPublisher.tenantPartitionCountTracker);
    }

    @Test
    public void testGetPartitionCountForTenant() {
        String testTenant = "test_tenant";
        TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy metric = new TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy(Long.valueOf(10L), Long.valueOf(5L));
        this.tenantMetricsPublisher.tenantPartitionCountTracker.put(testTenant + "_", metric);
        TenantMetricsPublisher.PartitionCountMetricByCleanupPolicy retrievedMetric = this.tenantMetricsPublisher.getPartitionCountForTenant(testTenant);
        Assertions.assertEquals((Object)metric, (Object)retrievedMetric);
    }

    @Test
    public void testGetPartitionCountForTenantNonExistent() {
        String nonExistentTenant = "non_existent_tenant";
        Assertions.assertThrows(RuntimeException.class, () -> this.tenantMetricsPublisher.getPartitionCountForTenant(nonExistentTenant));
    }

    @Test
    public void testClose() {
        this.tenantMetricsPublisher.close();
        Assertions.assertEquals(new HashMap(), (Object)this.tenantMetricsPublisher.tenantPartitionCountTracker);
    }

    @Test
    public void testRegisteredTenantIteratorRemove() {
        this.tenantMetricsPublisher.setTenantRegisterInterface(this::testPublisherFunctionReturnsTrue);
        this.tenantMetricsPublisher.setIsTenantOwnedInterface(this::testPublisherFunctionReturnsTrue);
        this.tenantMetricsPublisher.setRemoveTenantGaugeInterface(this::testPublisherFunctionReturnsTrue);
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("1");
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("2");
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("3");
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("4");
        this.tenantMetricsPublisher.maybeRegisterTenantGauge("5");
        Assertions.assertEquals((int)5, (int)this.tenantMetricsPublisher.registeredTenants().size());
        this.tenantMetricsPublisher.maybeRemoveTenantGauges();
        Assertions.assertEquals((int)5, (int)this.tenantMetricsPublisher.registeredTenants().size());
        this.tenantMetricsPublisher.setIsTenantOwnedInterface(this::testPublisherFunctionReturnsFalse);
        this.tenantMetricsPublisher.maybeRemoveTenantGauges();
        Assertions.assertEquals((int)0, (int)this.tenantMetricsPublisher.registeredTenants().size());
    }

    private Boolean testPublisherFunctionReturnsTrue(String tenant) {
        return true;
    }

    private Boolean testPublisherFunctionReturnsFalse(String tenant) {
        return false;
    }
}

