/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.controller.metrics.ControllerMetricsChanges;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.DegradedBrokerHealthState;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class ControllerMetricsChangesTest {
    static final Uuid FOO_ID = Uuid.fromString((String)"wXtW6pQbTS2CL6PjdRCqVw");
    static final TopicDelta TOPIC_DELTA1;
    static final TopicDelta TOPIC_DELTA2;

    @Test
    public void testDelta() {
        Assertions.assertEquals((int)0, (int)ControllerMetricsChanges.delta((boolean)false, (boolean)false));
        Assertions.assertEquals((int)1, (int)ControllerMetricsChanges.delta((boolean)false, (boolean)true));
        Assertions.assertEquals((int)-1, (int)ControllerMetricsChanges.delta((boolean)true, (boolean)false));
        Assertions.assertEquals((int)0, (int)ControllerMetricsChanges.delta((boolean)true, (boolean)true));
    }

    private static BrokerRegistration.Builder brokerRegistrationBuilder(int brokerId, boolean fenced) {
        return new BrokerRegistration.Builder().setId(brokerId).setEpoch(100L).setIncarnationId(Uuid.fromString((String)"Pxi6QwS2RFuN8VSKjqJZyQ")).setFenced(fenced);
    }

    private static BrokerRegistration brokerRegistration(int brokerId, boolean fenced) {
        return ControllerMetricsChangesTest.brokerRegistrationBuilder(brokerId, fenced).build();
    }

    private static BrokerRegistration zkBrokerRegistration(int brokerId) {
        return new BrokerRegistration.Builder().setId(brokerId).setEpoch(100L).setIncarnationId(Uuid.fromString((String)"Pxi6QwS2RFuN8VSKjqJZyQ")).setFenced(false).setInControlledShutdown(false).setIsMigratingZkBroker(true).build();
    }

    @Test
    public void testInitialValues() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        Assertions.assertEquals((int)0, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.activeBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.migratingZkBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedStorageBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedNetworkBrokersChange());
    }

    @Test
    public void testHandleNewUnfencedBroker() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.brokerRegistration(1, false));
        Assertions.assertEquals((int)0, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)1, (int)changes.activeBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.migratingZkBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedStorageBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedNetworkBrokersChange());
    }

    @Test
    public void testHandleNewFencedBroker() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.brokerRegistration(1, true));
        Assertions.assertEquals((int)1, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.activeBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.migratingZkBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedStorageBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedNetworkBrokersChange());
    }

    @Test
    public void testHandleBrokerFencing() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistration(1, false), ControllerMetricsChangesTest.brokerRegistration(1, true));
        Assertions.assertEquals((int)1, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)-1, (int)changes.activeBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.migratingZkBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedStorageBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedNetworkBrokersChange());
    }

    @Test
    public void testHandleBrokerUnfencing() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistration(1, true), ControllerMetricsChangesTest.brokerRegistration(1, false));
        Assertions.assertEquals((int)-1, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)1, (int)changes.activeBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.migratingZkBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedStorageBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedNetworkBrokersChange());
    }

    @Test
    public void testHandleZkBroker() {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.zkBrokerRegistration(1));
        Assertions.assertEquals((int)1, (int)changes.migratingZkBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedStorageBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.degradedNetworkBrokersChange());
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.zkBrokerRegistration(2));
        changes.handleBrokerChange(null, ControllerMetricsChangesTest.zkBrokerRegistration(3));
        Assertions.assertEquals((int)3, (int)changes.migratingZkBrokersChange());
        changes.handleBrokerChange(ControllerMetricsChangesTest.zkBrokerRegistration(3), ControllerMetricsChangesTest.brokerRegistration(3, true));
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistration(3, true), ControllerMetricsChangesTest.brokerRegistration(3, false));
        Assertions.assertEquals((int)2, (int)changes.migratingZkBrokersChange());
    }

    @ParameterizedTest
    @EnumSource(value=BrokerComponent.class, names={"UNSPECIFIED", "STORAGE", "NETWORK"})
    public void testHandleBrokerDegraded(BrokerComponent component) {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistration(1, true), ControllerMetricsChangesTest.brokerRegistrationBuilder(1, true).setDegradedComponents(new HashSet<DegradedBrokerHealthState>(Arrays.asList(new DegradedBrokerHealthState(component.toString(), component)))).build());
        Assertions.assertEquals((int)0, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.activeBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.migratingZkBrokersChange());
        Assertions.assertEquals((int)1, (int)changes.degradedBrokersChange());
        if (component == BrokerComponent.STORAGE) {
            Assertions.assertEquals((int)1, (int)changes.degradedStorageBrokersChange());
        }
        if (component == BrokerComponent.NETWORK) {
            Assertions.assertEquals((int)1, (int)changes.degradedNetworkBrokersChange());
        }
    }

    @ParameterizedTest
    @EnumSource(value=BrokerComponent.class, names={"UNSPECIFIED", "STORAGE", "NETWORK"})
    public void testHandleBrokerUndegraded(BrokerComponent component) {
        ControllerMetricsChanges changes = new ControllerMetricsChanges();
        changes.handleBrokerChange(ControllerMetricsChangesTest.brokerRegistrationBuilder(1, true).setDegradedComponents(new HashSet<DegradedBrokerHealthState>(Collections.singletonList(new DegradedBrokerHealthState(component.toString(), component)))).build(), ControllerMetricsChangesTest.brokerRegistration(1, true));
        Assertions.assertEquals((int)0, (int)changes.fencedBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.activeBrokersChange());
        Assertions.assertEquals((int)0, (int)changes.migratingZkBrokersChange());
        Assertions.assertEquals((int)-1, (int)changes.degradedBrokersChange());
        if (component == BrokerComponent.STORAGE) {
            Assertions.assertEquals((int)-1, (int)changes.degradedStorageBrokersChange());
        }
        if (component == BrokerComponent.NETWORK) {
            Assertions.assertEquals((int)-1, (int)changes.degradedNetworkBrokersChange());
        }
    }

    @Test
    public void testContainsDesiredDegradedComponent() {
        BrokerRegistration degradedBrokerOnUnspecifiedComponent = ControllerMetricsChangesTest.brokerRegistrationBuilder(1, true).build();
        Assertions.assertFalse((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnUnspecifiedComponent.degradedComponents(), (BrokerComponent)BrokerComponent.UNSPECIFIED));
        Assertions.assertFalse((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnUnspecifiedComponent.degradedComponents(), (BrokerComponent)BrokerComponent.STORAGE));
        Assertions.assertFalse((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnUnspecifiedComponent.degradedComponents(), (BrokerComponent)BrokerComponent.NETWORK));
        degradedBrokerOnUnspecifiedComponent = ControllerMetricsChangesTest.brokerRegistrationBuilder(1, true).setDegradedComponents(new HashSet<DegradedBrokerHealthState>(Collections.singletonList(new DegradedBrokerHealthState("unspecified", BrokerComponent.UNSPECIFIED)))).build();
        Assertions.assertTrue((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnUnspecifiedComponent.degradedComponents(), (BrokerComponent)BrokerComponent.UNSPECIFIED));
        Assertions.assertFalse((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnUnspecifiedComponent.degradedComponents(), (BrokerComponent)BrokerComponent.STORAGE));
        Assertions.assertFalse((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnUnspecifiedComponent.degradedComponents(), (BrokerComponent)BrokerComponent.NETWORK));
        BrokerRegistration degradedBrokerOnStorageComponent = ControllerMetricsChangesTest.brokerRegistrationBuilder(1, true).setDegradedComponents(new HashSet<DegradedBrokerHealthState>(Collections.singletonList(new DegradedBrokerHealthState("storage", BrokerComponent.STORAGE)))).build();
        Assertions.assertFalse((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnStorageComponent.degradedComponents(), (BrokerComponent)BrokerComponent.UNSPECIFIED));
        Assertions.assertTrue((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnStorageComponent.degradedComponents(), (BrokerComponent)BrokerComponent.STORAGE));
        Assertions.assertFalse((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnStorageComponent.degradedComponents(), (BrokerComponent)BrokerComponent.NETWORK));
        BrokerRegistration degradedBrokerOnNetworkComponent = ControllerMetricsChangesTest.brokerRegistrationBuilder(1, true).setDegradedComponents(new HashSet<DegradedBrokerHealthState>(Collections.singletonList(new DegradedBrokerHealthState("network", BrokerComponent.NETWORK)))).build();
        Assertions.assertFalse((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnNetworkComponent.degradedComponents(), (BrokerComponent)BrokerComponent.UNSPECIFIED));
        Assertions.assertFalse((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnNetworkComponent.degradedComponents(), (BrokerComponent)BrokerComponent.STORAGE));
        Assertions.assertTrue((boolean)DegradedBrokerHealthState.containsDesiredDegradedComponent((Set)degradedBrokerOnNetworkComponent.degradedComponents(), (BrokerComponent)BrokerComponent.NETWORK));
    }

    static {
        ImageWriterOptions options = new ImageWriterOptions.Builder().setMetadataVersion(MetadataVersion.IBP_3_7_IV0).build();
        TOPIC_DELTA1 = new TopicDelta(new TopicImage("foo", FOO_ID, Collections.emptyMap(), null));
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 0, options).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 1, options).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 2, options).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER).toRecord(FOO_ID, 3, options).message());
        TOPIC_DELTA1.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER).toRecord(FOO_ID, 4, options).message());
        TOPIC_DELTA2 = new TopicDelta(TOPIC_DELTA1.apply());
        TOPIC_DELTA2.replay(new PartitionChangeRecord().setPartitionId(1).setTopicId(FOO_ID).setLeader(1));
        TOPIC_DELTA2.replay((PartitionRecord)ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL).toRecord(FOO_ID, 5, options).message());
    }
}

