/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.CellMigrationRecord;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.CellControllerMetrics;
import org.apache.kafka.controller.metrics.CellMetadataMetricsPublisher;
import org.apache.kafka.controller.metrics.ControllerMetricsTestUtils;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.loader.SnapshotManifest;
import org.apache.kafka.image.writer.ImageReWriter;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class CellMetadataMetricsPublisherTest {
    static final TopicsImage TOPICS_IMAGE1 = ControllerMetricsTestUtils.fakeTopicsImage(ControllerMetricsTestUtils.fakeTopicImage("foo", Uuid.fromString((String)"JKNp6fQaT-icHxh654ok-w"), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL)), ControllerMetricsTestUtils.fakeTopicImage("bar", Uuid.fromString((String)"pEMSdUVWTXaFQUzLTznFSw"), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NORMAL), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.NON_PREFERRED_LEADER)), ControllerMetricsTestUtils.fakeTopicImage("quux", Uuid.fromString((String)"zkUT4lyyRke6VIaTw6RQWg"), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE), ControllerMetricsTestUtils.fakePartitionRegistration(ControllerMetricsTestUtils.FakePartitionRegistrationType.OFFLINE)));
    static final MetadataImage IMAGE1 = CellMetadataMetricsPublisherTest.fakeImageFromTopicsImage(TOPICS_IMAGE1);

    @Test
    public void testMetricsBeforePublishing() {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.cellMigrationState());
        }
    }

    static MetadataImage fakeImageFromTopicsImage(TopicsImage topicsImage) {
        return new MetadataImage(MetadataProvenance.EMPTY, FeaturesImage.EMPTY, ClusterImage.EMPTY, topicsImage, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
    }

    @Test
    public void testPublish() {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.cellMigrationState());
        }
    }

    static LoaderManifest fakeManifest(boolean isSnapshot) {
        if (isSnapshot) {
            return new SnapshotManifest(MetadataProvenance.EMPTY, 0L);
        }
        return LogDeltaManifest.newBuilder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(0).elapsedNs(0L).numBytes(0L).build();
    }

    @Test
    public void testLoadSnapshot() {
        try (TestEnv env = new TestEnv();){
            MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
            ImageReWriter writer = new ImageReWriter(delta);
            IMAGE1.write((ImageWriter)writer, new ImageWriterOptions.Builder().setMetadataVersion(MetadataVersion.latestTesting()).build());
            env.publisher.onMetadataUpdate(delta, IMAGE1, CellMetadataMetricsPublisherTest.fakeManifest(true));
            Assertions.assertEquals((int)0, (int)env.metrics.cellMigrationState());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testExclusions(boolean loadSnapshot) {
        try (TestEnv env = new TestEnv();){
            Assertions.assertEquals((int)0, (int)env.metrics.cellMigrationState());
            MetadataDelta delta = new MetadataDelta.Builder().setImage(MetadataImage.EMPTY).build();
            delta.replay(new CellMigrationRecord().setState((byte)2));
            MetadataImage image2 = delta.apply(new MetadataProvenance(100L, 200, 300L));
            env.publisher.onMetadataUpdate(delta, image2, CellMetadataMetricsPublisherTest.fakeManifest(loadSnapshot));
            Assertions.assertEquals((Object)CellMigrationState.INITIATED, (Object)CellMigrationState.toEnum((byte)env.metrics.cellMigrationState()));
            delta.replay(new CellMigrationRecord().setState((byte)1));
            image2 = delta.apply(new MetadataProvenance(100L, 200, 300L));
            env.publisher.onMetadataUpdate(delta, image2, CellMetadataMetricsPublisherTest.fakeManifest(loadSnapshot));
            Assertions.assertEquals((Object)CellMigrationState.PAUSED, (Object)CellMigrationState.toEnum((byte)env.metrics.cellMigrationState()));
            delta.replay(new CellMigrationRecord().setState((byte)0));
            image2 = delta.apply(new MetadataProvenance(100L, 200, 300L));
            env.publisher.onMetadataUpdate(delta, image2, CellMetadataMetricsPublisherTest.fakeManifest(loadSnapshot));
            Assertions.assertEquals((Object)CellMigrationState.INACTIVE, (Object)CellMigrationState.toEnum((byte)env.metrics.cellMigrationState()));
        }
    }

    static class TestEnv
    implements AutoCloseable {
        MockFaultHandler faultHandler = new MockFaultHandler("CellMetadataMetricsPublisher");
        MetricsRegistry metricsRegistry = new MetricsRegistry();
        CellControllerMetrics metrics = new CellControllerMetrics(this.metricsRegistry, (Time)new MockTime(), new LogContext());
        CellMetadataMetricsPublisher publisher = new CellMetadataMetricsPublisher(this.metrics, (FaultHandler)this.faultHandler);

        TestEnv() {
        }

        @Override
        public void close() {
            this.publisher.close();
            this.faultHandler.maybeRethrowFirstException();
        }
    }
}

