/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.util.stream.Stream;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.TopicTypeDetermination;
import org.apache.kafka.metadata.TopicType;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TopicTypeDeterminationTest {
    static Stream<Arguments> topicTypeParameters() {
        boolean[] bools;
        Stream.Builder<Arguments> builder = Stream.builder();
        for (boolean isMT : bools = new boolean[]{true, false}) {
            for (boolean isHC : bools) {
                for (boolean isPGEnabledInConfig : bools) {
                    for (boolean isPGInMetadataVersion : bools) {
                        builder.add(Arguments.of((Object[])new Object[]{isMT, isHC, isPGEnabledInConfig, isPGInMetadataVersion}));
                    }
                }
            }
        }
        return builder.build();
    }

    @ParameterizedTest(name="testTopicTypeDetermination with isMT: {0}, isHC: {1}, isPGEnabledInConfig: {2}, isPGInMetadataVersion: {3}")
    @MethodSource(value={"topicTypeParameters"})
    public void testTopicTypeDetermination(boolean isMT, boolean isHC, boolean isPGEnabledInConfig, boolean isPGInMetadataVersion) {
        KafkaPrincipal kafkaPrincipal;
        if (!isMT && isHC) {
            return;
        }
        if (isPGInMetadataVersion) {
            return;
        }
        ControllerRequestContext context = (ControllerRequestContext)Mockito.mock(ControllerRequestContext.class);
        if (isMT) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)Mockito.mock(MultiTenantPrincipal.class);
            TenantMetadata tenantMetadata = new TenantMetadata.Builder("clusterId", "userResourceId").healthcheckTenant(isHC).build();
            Mockito.when((Object)multiTenantPrincipal.tenantMetadata()).thenReturn((Object)tenantMetadata);
            kafkaPrincipal = multiTenantPrincipal;
        } else {
            kafkaPrincipal = (KafkaPrincipal)Mockito.mock(KafkaPrincipal.class);
        }
        Mockito.when((Object)context.principal()).thenReturn((Object)kafkaPrincipal);
        MetadataVersion metadataVersion = isPGInMetadataVersion ? MetadataVersion.latestTesting() : MetadataVersion.IBP_3_6_IV2;
        TopicType topicType = TopicTypeDetermination.forTopicCreation((ControllerRequestContext)context, (MetadataVersion)metadataVersion, (boolean)isPGEnabledInConfig);
        if (isPGEnabledInConfig && isPGInMetadataVersion && isMT && !isHC) {
            Assertions.assertEquals((Object)TopicType.K2, (Object)topicType);
        } else {
            Assertions.assertEquals((Object)TopicType.STANDARD, (Object)topicType);
        }
    }
}

