/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ImbalancedPartitions;
import org.apache.kafka.controller.ReplicationControlManager;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImbalancedPartitionsTest {
    int jvmWarmupMs = 60000;
    SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext("test"));
    Time time = new MockTime();
    byte topicType = 0;
    Uuid internalTopicId = Uuid.randomUuid();
    Uuid externalTopicId = Uuid.randomUuid();
    Uuid consumerGroupTopicId = Uuid.randomUuid();
    Uuid transactionTopicId = Uuid.randomUuid();
    String internalTopicName = "_confluent-tier-state";
    String externalTopicName = "test";
    String consumerGroupTopicName = "__consumer_offsets";
    String transactionTopicName = "__transaction_state";
    Uuid internalTopicId1 = Uuid.randomUuid();
    Uuid externalTopicId1 = Uuid.randomUuid();
    String internalTopicName1 = "_confluent_durability_audit";
    String externalTopicName1 = "test1";

    ReplicationControlManager.TopicControlInfo buildControlInfoFromTopicIdPartition(String topicName, TopicIdPartition tp) {
        return this.buildControlInfoFromTopicIdPartition(topicName, tp, new int[]{0, 1, 2});
    }

    ReplicationControlManager.TopicControlInfo buildControlInfoFromTopicIdPartition(String topicName, TopicIdPartition tp, int[] replicaSet) {
        ReplicationControlManager.TopicControlInfo iTPInfo = new ReplicationControlManager.TopicControlInfo(topicName, this.snapshotRegistry, tp.topicId(), this.topicType);
        PartitionRegistration part = new PartitionRegistration.Builder().setReplicas(replicaSet).setDirectories(DirectoryId.migratingArray((int)replicaSet.length)).setIsr(new int[]{0, 1, 2}).setLeader(Integer.valueOf(0)).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Integer.valueOf(1)).setPartitionEpoch(Integer.valueOf(0)).build();
        iTPInfo.partitions().put((Object)tp.partitionId(), (Object)part);
        return iTPInfo;
    }

    @Test
    public void testImbalancedPartitionOnOneBroker() {
        int partition;
        ImbalancedPartitions imbalancedPartitions = new ImbalancedPartitions(this.jvmWarmupMs, this.snapshotRegistry, this.time);
        for (partition = 0; partition < 10; ++partition) {
            TopicIdPartition internalTP = new TopicIdPartition(this.internalTopicId, partition);
            imbalancedPartitions.add(internalTP, this.buildControlInfoFromTopicIdPartition(this.internalTopicName, internalTP));
        }
        for (partition = 0; partition < 10; ++partition) {
            TopicIdPartition externalTP = new TopicIdPartition(this.externalTopicId, partition);
            imbalancedPartitions.add(externalTP, this.buildControlInfoFromTopicIdPartition(this.externalTopicName, externalTP));
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)20);
        ImbalancedPartitions.ImbalancedPartitionsIterator iterator = imbalancedPartitions.iterator();
        while (iterator.hasNext()) {
            TopicIdPartition topicPartition = iterator.next();
            Assertions.assertEquals((Object)topicPartition.topicId(), (Object)this.internalTopicId);
            imbalancedPartitions.remove(topicPartition);
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)10);
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertTrue((boolean)iterator.hasNextForInternalOrExternalPartitions());
        this.time.sleep((long)(this.jvmWarmupMs / 2));
        ImbalancedPartitions.ImbalancedPartitionsIterator iterator1 = imbalancedPartitions.iterator();
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)10);
        Assertions.assertFalse((boolean)iterator1.hasNext());
        Assertions.assertTrue((boolean)iterator1.hasNextForInternalOrExternalPartitions());
        this.time.sleep((long)(this.jvmWarmupMs / 2 + 1));
        ImbalancedPartitions.ImbalancedPartitionsIterator iterator2 = imbalancedPartitions.iterator();
        Assertions.assertTrue((boolean)iterator2.hasNext());
        while (iterator2.hasNext()) {
            TopicIdPartition topicPartition = iterator2.next();
            Assertions.assertEquals((Object)topicPartition.topicId(), (Object)this.externalTopicId);
            imbalancedPartitions.remove(topicPartition);
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)0);
        Assertions.assertFalse((boolean)iterator2.hasNextForInternalOrExternalPartitions());
    }

    @Test
    public void testImbalancedPartitionOnTwoBrokers() {
        int partition;
        int partition2;
        ImbalancedPartitions imbalancedPartitions = new ImbalancedPartitions(this.jvmWarmupMs, this.snapshotRegistry, this.time);
        for (partition2 = 0; partition2 < 10; ++partition2) {
            TopicIdPartition internalTP = new TopicIdPartition(this.internalTopicId, partition2);
            imbalancedPartitions.add(internalTP, this.buildControlInfoFromTopicIdPartition(this.internalTopicName, internalTP));
        }
        for (partition2 = 0; partition2 < 10; ++partition2) {
            TopicIdPartition externalTP = new TopicIdPartition(this.externalTopicId, partition2);
            imbalancedPartitions.add(externalTP, this.buildControlInfoFromTopicIdPartition(this.externalTopicName, externalTP));
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)20);
        ImbalancedPartitions.ImbalancedPartitionsIterator iterator = imbalancedPartitions.iterator();
        while (iterator.hasNext()) {
            TopicIdPartition topicPartition = iterator.next();
            Assertions.assertEquals((Object)topicPartition.topicId(), (Object)this.internalTopicId);
            imbalancedPartitions.remove(topicPartition);
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)10);
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertTrue((boolean)iterator.hasNextForInternalOrExternalPartitions());
        this.time.sleep((long)(this.jvmWarmupMs / 2));
        ImbalancedPartitions.ImbalancedPartitionsIterator iterator1 = imbalancedPartitions.iterator();
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)10);
        Assertions.assertFalse((boolean)iterator1.hasNext());
        Assertions.assertTrue((boolean)iterator1.hasNextForInternalOrExternalPartitions());
        for (partition = 0; partition < 10; ++partition) {
            TopicIdPartition internalTP = new TopicIdPartition(this.internalTopicId1, partition);
            imbalancedPartitions.add(internalTP, this.buildControlInfoFromTopicIdPartition(this.internalTopicName1, internalTP, new int[]{1, 0, 2}));
        }
        for (partition = 0; partition < 10; ++partition) {
            TopicIdPartition externalTP = new TopicIdPartition(this.externalTopicId1, partition);
            imbalancedPartitions.add(externalTP, this.buildControlInfoFromTopicIdPartition(this.externalTopicName1, externalTP, new int[]{1, 0, 2}));
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)30);
        this.time.sleep((long)(this.jvmWarmupMs / 2 + 1));
        ImbalancedPartitions.ImbalancedPartitionsIterator iterator2 = imbalancedPartitions.iterator();
        Assertions.assertTrue((boolean)iterator2.hasNext());
        while (iterator2.hasNext()) {
            TopicIdPartition topicPartition = iterator2.next();
            Assertions.assertTrue((topicPartition.topicId().equals((Object)this.externalTopicId) || topicPartition.topicId().equals((Object)this.internalTopicId1) ? 1 : 0) != 0);
            imbalancedPartitions.remove(topicPartition);
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)10);
        Assertions.assertTrue((boolean)iterator2.hasNextForInternalOrExternalPartitions());
        this.time.sleep((long)(this.jvmWarmupMs + 1));
        ImbalancedPartitions.ImbalancedPartitionsIterator iterator3 = imbalancedPartitions.iterator();
        Assertions.assertTrue((boolean)iterator3.hasNext());
        while (iterator3.hasNext()) {
            TopicIdPartition topicPartition = iterator3.next();
            Assertions.assertEquals((Object)topicPartition.topicId(), (Object)this.externalTopicId1);
            imbalancedPartitions.remove(topicPartition);
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)0);
        Assertions.assertFalse((boolean)iterator3.hasNextForInternalOrExternalPartitions());
    }

    @Test
    public void testImbalancedCoordinatorPartitionOnOneBroker() {
        int partition;
        ImbalancedPartitions imbalancedPartitions = new ImbalancedPartitions(this.jvmWarmupMs, this.snapshotRegistry, this.time);
        for (partition = 0; partition < 10; ++partition) {
            TopicIdPartition internalTP = new TopicIdPartition(this.internalTopicId, partition);
            imbalancedPartitions.add(internalTP, this.buildControlInfoFromTopicIdPartition(this.internalTopicName, internalTP));
        }
        for (partition = 0; partition < 6; ++partition) {
            TopicIdPartition consumerGroupTP = new TopicIdPartition(this.consumerGroupTopicId, partition);
            imbalancedPartitions.add(consumerGroupTP, this.buildControlInfoFromTopicIdPartition(this.consumerGroupTopicName, consumerGroupTP));
        }
        for (partition = 0; partition < 6; ++partition) {
            TopicIdPartition transactionTP = new TopicIdPartition(this.transactionTopicId, partition);
            imbalancedPartitions.add(transactionTP, this.buildControlInfoFromTopicIdPartition(this.transactionTopicName, transactionTP));
        }
        for (partition = 0; partition < 100; ++partition) {
            TopicIdPartition externalTP = new TopicIdPartition(this.externalTopicId, partition);
            imbalancedPartitions.add(externalTP, this.buildControlInfoFromTopicIdPartition(this.externalTopicName, externalTP));
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)122);
        ImbalancedPartitions.ImbalancedPartitionsIterator iterator = imbalancedPartitions.iterator();
        while (iterator.hasNext()) {
            TopicIdPartition topicPartition = iterator.next();
            Assertions.assertEquals((Object)topicPartition.topicId(), (Object)this.internalTopicId);
            imbalancedPartitions.remove(topicPartition);
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)112);
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertTrue((boolean)iterator.hasNextForInternalOrExternalPartitions());
        this.time.sleep((long)(this.jvmWarmupMs / 2));
        ImbalancedPartitions.ImbalancedPartitionsIterator iterator1 = imbalancedPartitions.iterator();
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)112);
        Assertions.assertFalse((boolean)iterator1.hasNext());
        Assertions.assertTrue((boolean)iterator1.hasNextForInternalOrExternalPartitions());
        this.time.sleep((long)(this.jvmWarmupMs / 2 + 1));
        for (int slice = 0; slice < 10; ++slice) {
            ImbalancedPartitions.ImbalancedPartitionsIterator it = imbalancedPartitions.iterator();
            Assertions.assertTrue((boolean)it.hasNext());
            for (int p = 0; p < 11; ++p) {
                TopicIdPartition topicPartition = it.next();
                if (p == 0) {
                    Assertions.assertTrue((topicPartition.topicId().equals((Object)this.consumerGroupTopicId) || topicPartition.topicId().equals((Object)this.transactionTopicId) ? 1 : 0) != 0);
                } else {
                    Assertions.assertEquals((Object)topicPartition.topicId(), (Object)this.externalTopicId);
                }
                imbalancedPartitions.remove(topicPartition);
            }
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)2);
        ImbalancedPartitions.ImbalancedPartitionsIterator itSlice11 = imbalancedPartitions.iterator();
        Assertions.assertTrue((boolean)itSlice11.hasNext());
        while (itSlice11.hasNext()) {
            TopicIdPartition topicPartition = itSlice11.next();
            Assertions.assertTrue((topicPartition.topicId().equals((Object)this.consumerGroupTopicId) || topicPartition.topicId().equals((Object)this.transactionTopicId) ? 1 : 0) != 0);
            imbalancedPartitions.remove(topicPartition);
        }
        Assertions.assertEquals((int)imbalancedPartitions.allImbalancedPartitions().size(), (int)0);
        Assertions.assertFalse((boolean)itSlice11.hasNextForInternalOrExternalPartitions());
    }
}

